/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.schemalessfeatures.data;

import java.awt.RenderingHints;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.geoserver.schemalessfeatures.data.ComplexContentDataAccess;
import org.geoserver.schemalessfeatures.data.ComplexFeatureCollection;
import org.geotools.api.data.FeatureListener;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.data.QueryCapabilities;
import org.geotools.api.data.ResourceInfo;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public abstract class ComplexFeatureSource
implements FeatureSource<FeatureType, Feature> {
    private ComplexContentDataAccess store;
    protected Name name;
    protected Set<Hints.Key> hints;
    public static final Logger LOG = Logging.getLogger(ComplexFeatureSource.class);

    public ComplexFeatureSource(Name name, ComplexContentDataAccess store) {
        this.store = store;
        this.name = name;
        this.hints = new HashSet<Hints.Key>();
        this.hints.add((Hints.Key)Hints.JTS_GEOMETRY_FACTORY);
        this.hints.add((Hints.Key)Hints.JTS_COORDINATE_SEQUENCE_FACTORY);
        this.addHints(this.hints);
        this.hints = Collections.unmodifiableSet(this.hints);
    }

    public Name getName() {
        return this.name;
    }

    public ResourceInfo getInfo() {
        return new ResourceInfo(){
            final Set<String> words = new HashSet<String>();
            {
                this.words.add("features");
                this.words.add(ComplexFeatureSource.this.getSchema().getName().toString());
            }

            public ReferencedEnvelope getBounds() {
                try {
                    return ComplexFeatureSource.this.getBounds();
                }
                catch (IOException e) {
                    return null;
                }
            }

            public CoordinateReferenceSystem getCRS() {
                return ComplexFeatureSource.this.getSchema().getCoordinateReferenceSystem();
            }

            public String getDescription() {
                return null;
            }

            public Set<String> getKeywords() {
                return this.words;
            }

            public String getName() {
                return ComplexFeatureSource.this.getSchema().getName().toString();
            }

            public URI getSchema() {
                Name name = ComplexFeatureSource.this.getSchema().getName();
                try {
                    URI namespace = new URI(name.getNamespaceURI());
                    return namespace;
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }

            public String getTitle() {
                Name name = ComplexFeatureSource.this.getSchema().getName();
                return name.getLocalPart();
            }
        };
    }

    public ComplexContentDataAccess getDataStore() {
        return this.store;
    }

    public QueryCapabilities getQueryCapabilities() {
        return new QueryCapabilities();
    }

    public void addFeatureListener(FeatureListener listener) {
    }

    public void removeFeatureListener(FeatureListener listener) {
    }

    public FeatureCollection<FeatureType, Feature> getFeatures(Filter filter) throws IOException {
        Query q = new Query(this.getName().toString(), filter);
        return new ComplexFeatureCollection(q, this);
    }

    public FeatureCollection<FeatureType, Feature> getFeatures(Query query) throws IOException {
        return new ComplexFeatureCollection(query, this);
    }

    public FeatureCollection<FeatureType, Feature> getFeatures() throws IOException {
        return new ComplexFeatureCollection(Query.ALL, this);
    }

    protected final Name name(String typeName) {
        return new NameImpl(typeName);
    }

    protected final Name name(String namespaceURI, String typeName) {
        return new NameImpl(namespaceURI, typeName);
    }

    public ReferencedEnvelope getBounds() throws IOException {
        return this.getBounds(Query.ALL);
    }

    public ReferencedEnvelope getBounds(Query query) throws IOException {
        return this.getBoundsInternal(query);
    }

    protected ReferencedEnvelope getBoundsInternal(Query q) throws IOException {
        try (FeatureReader<FeatureType, Feature> r = this.getReader(q);){
            ReferencedEnvelope e = new ReferencedEnvelope();
            if (r.hasNext()) {
                Feature f = r.next();
                e.init(f.getBounds());
            }
            while (r.hasNext()) {
                e.include(r.next().getBounds());
            }
            ReferencedEnvelope referencedEnvelope = e;
            return referencedEnvelope;
        }
    }

    public int getCount(Query query) throws IOException {
        return this.getCountInteral(query);
    }

    public Set<RenderingHints.Key> getSupportedHints() {
        return this.hints;
    }

    public FeatureReader<FeatureType, Feature> getReader(Query query) {
        return this.getReaderInteranl(query);
    }

    protected abstract FeatureReader<FeatureType, Feature> getReaderInteranl(Query var1);

    protected abstract int getCountInteral(Query var1);

    protected boolean isAll(Filter f) {
        return f == null || f == Filter.INCLUDE;
    }

    protected void addHints(Set<Hints.Key> hints) {
    }
}

