/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.onelogin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.security.GeoServerRoleConverter;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.config.PreAuthenticatedUserNameFilterConfig;
import org.geoserver.security.config.RoleSource;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.RoleCalculator;
import org.geotools.util.logging.Logging;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.saml.SAMLCredential;
import org.springframework.security.saml.userdetails.SAMLUserDetailsService;
import org.springframework.util.StringUtils;

public class SAMLUserDetailsServiceImpl
implements SAMLUserDetailsService {
    static final Logger LOGGER = Logging.getLogger(SAMLUserDetailsServiceImpl.class);
    private RoleSource roleSource;
    private String rolesHeaderAttribute;
    private String userGroupServiceName;
    private String roleServiceName;
    private GeoServerRoleConverter converter;
    private GeoServerSecurityManager securityManager;
    private HttpServletRequest request;

    public Object loadUserBySAML(SAMLCredential credential) throws UsernameNotFoundException {
        String principal = credential.getNameID().getValue();
        Collection<GeoServerRole> roles = null;
        if ("root".equals(principal)) {
            roles = Collections.singleton(GeoServerRole.ADMIN_ROLE);
        } else {
            try {
                roles = this.getRoles(principal);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (!roles.contains(GeoServerRole.AUTHENTICATED_ROLE)) {
                roles.add(GeoServerRole.AUTHENTICATED_ROLE);
            }
        }
        return new User(principal, "", true, true, true, true, roles);
    }

    protected Collection<GeoServerRole> getRoles(String principal) throws IOException {
        if (PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.RoleService.equals(this.roleSource)) {
            return this.getRolesFromRoleService(principal);
        }
        if (PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.UserGroupService.equals(this.roleSource)) {
            return this.getRolesFromUserGroupService(principal);
        }
        if (PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.Header.equals(this.roleSource)) {
            return this.getRolesFromHttpAttribute(principal);
        }
        throw new RuntimeException("Never should reach this point");
    }

    protected Collection<GeoServerRole> getRolesFromRoleService(String principal) throws IOException {
        boolean useActiveService = this.roleServiceName == null || this.roleServiceName.trim().length() == 0;
        GeoServerRoleService service = useActiveService ? this.securityManager.getActiveRoleService() : this.securityManager.loadRoleService(this.roleServiceName);
        RoleCalculator calc = new RoleCalculator(service);
        return calc.calculateRoles(principal);
    }

    protected Collection<GeoServerRole> getRolesFromUserGroupService(String principal) throws IOException {
        ArrayList<GeoServerRole> roles = new ArrayList<GeoServerRole>();
        GeoServerUserGroupService service = this.securityManager.loadUserGroupService(this.userGroupServiceName);
        UserDetails details = null;
        try {
            details = service.loadUserByUsername(principal);
        }
        catch (UsernameNotFoundException ex) {
            LOGGER.log(Level.WARNING, "User " + principal + " not found in " + this.userGroupServiceName);
        }
        if (details != null) {
            for (GrantedAuthority auth : details.getAuthorities()) {
                roles.add((GeoServerRole)auth);
            }
        }
        return roles;
    }

    protected Collection<GeoServerRole> getRolesFromHttpAttribute(String principal) throws IOException {
        ArrayList<GeoServerRole> roles = new ArrayList<GeoServerRole>();
        if (this.request != null) {
            String rolesString = this.request.getHeader(this.rolesHeaderAttribute);
            if (rolesString == null || rolesString.trim().length() == 0) {
                LOGGER.log(Level.WARNING, "No roles in header attribute: " + this.rolesHeaderAttribute);
                return roles;
            }
            roles.addAll(this.converter.convertRolesFromString(rolesString, principal));
            LOGGER.log(Level.FINE, "for principal " + principal + " found roles " + StringUtils.collectionToCommaDelimitedString(roles) + " in header " + this.rolesHeaderAttribute);
        }
        return roles;
    }

    public void setRoleSource(RoleSource roleSource) {
        this.roleSource = roleSource;
    }

    public void setRolesHeaderAttribute(String rolesHeaderAttribute) {
        this.rolesHeaderAttribute = rolesHeaderAttribute;
    }

    public void setUserGroupServiceName(String userGroupServiceName) {
        this.userGroupServiceName = userGroupServiceName;
    }

    public void setRoleServiceName(String roleServiceName) {
        this.roleServiceName = roleServiceName;
    }

    public void setConverter(GeoServerRoleConverter converter) {
        this.converter = converter;
    }

    public void setSecurityManager(GeoServerSecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }
}

