/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.onelogin;

import java.io.IOException;
import java.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.onelogin.GeoServerPreAuthenticatedCompositeUserNameFilter;
import org.geoserver.security.onelogin.OneloginAuthenticationFilterConfig;
import org.geoserver.security.onelogin.SAMLUserDetailsServiceImpl;
import org.geotools.util.logging.Logging;
import org.opensaml.saml2.metadata.provider.HTTPMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.xml.parse.ParserPool;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.saml.SAMLEntryPoint;
import org.springframework.security.saml.key.EmptyKeyManager;
import org.springframework.security.saml.key.KeyManager;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.metadata.ExtendedMetadataDelegate;
import org.springframework.security.saml.metadata.MetadataGenerator;
import org.springframework.security.saml.metadata.MetadataGeneratorFilter;
import org.springframework.security.saml.metadata.MetadataManager;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.logout.LogoutHandler;

public class OneloginAuthenticationFilter
extends GeoServerPreAuthenticatedCompositeUserNameFilter
implements LogoutHandler {
    static final Logger LOGGER = Logging.getLogger(OneloginAuthenticationFilter.class);
    protected SAMLEntryPoint samlEntryPoint;
    private static ApplicationContext context;

    public OneloginAuthenticationFilter(ApplicationContext ctx) {
        context = ctx;
        this.samlEntryPoint = (SAMLEntryPoint)context.getBean(SAMLEntryPoint.class);
    }

    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        OneloginAuthenticationFilterConfig authConfig = (OneloginAuthenticationFilterConfig)config;
        try {
            if (this.getNestedFilters().isEmpty()) {
                MetadataGenerator generator = new MetadataGenerator();
                generator.setEntityId(authConfig.getEntityId());
                generator.setIncludeDiscoveryExtension(false);
                generator.setKeyManager((KeyManager)new EmptyKeyManager());
                generator.setRequestSigned(false);
                generator.setWantAssertionSigned(authConfig.getWantAssertionSigned().booleanValue());
                ExtendedMetadata em = new ExtendedMetadata();
                em.setRequireLogoutRequestSigned(false);
                generator.setExtendedMetadata(em);
                MetadataGeneratorFilter metadataGeneratorFilter = new MetadataGeneratorFilter(generator);
                ParserPool parserPool = (ParserPool)context.getBean(ParserPool.class);
                HttpClientParams clientParams = new HttpClientParams();
                clientParams.setSoTimeout(5000);
                HttpClient httpClient = new HttpClient(clientParams);
                httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
                HTTPMetadataProvider pro = new HTTPMetadataProvider(new Timer(true), httpClient, authConfig.getMetadataURL());
                pro.setParserPool(parserPool);
                ExtendedMetadataDelegate emd = new ExtendedMetadataDelegate((MetadataProvider)pro, em);
                MetadataManager metadata = (MetadataManager)context.getBean(MetadataManager.class);
                metadata.addMetadataProvider((MetadataProvider)emd);
                metadata.refreshMetadata();
                metadataGeneratorFilter.setManager(metadata);
                this.getNestedFilters().add((Filter)metadataGeneratorFilter);
            } else {
                LOGGER.log(Level.FINE, "Metadata filter already added");
            }
            SAMLUserDetailsServiceImpl usd = (SAMLUserDetailsServiceImpl)context.getBean(SAMLUserDetailsServiceImpl.class);
            usd.setConverter(this.getConverter());
            usd.setRoleServiceName(this.getRoleServiceName());
            usd.setRolesHeaderAttribute(this.getRolesHeaderAttribute());
            usd.setRoleSource(this.getRoleSource());
            usd.setSecurityManager(this.securityManager);
            usd.setUserGroupServiceName(this.getUserGroupServiceName());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public AuthenticationEntryPoint getAuthenticationEntryPoint() {
        return this.samlEntryPoint;
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        req.setAttribute("_AUTHENTICATION_ENTRY_POINT_HEADER", (Object)this.samlEntryPoint);
        SAMLUserDetailsServiceImpl usd = (SAMLUserDetailsServiceImpl)context.getBean(SAMLUserDetailsServiceImpl.class);
        usd.setRequest((HttpServletRequest)req);
        super.doFilter(req, res, chain);
    }

    public boolean applicableForHtml() {
        return true;
    }

    public boolean applicableForServices() {
        return true;
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        request.setAttribute("_logout_redirect", (Object)"/saml/logout");
    }

    protected String getPreAuthenticatedPrincipalName(HttpServletRequest request) {
        return null;
    }
}

