/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.onelogin;

import java.util.List;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.security.ConstantFilterChain;
import org.geoserver.security.GeoServerSecurityFilterChain;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.SecurityManagerListener;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.AbstractFilterProvider;
import org.geoserver.security.filter.GeoServerSecurityFilter;
import org.geoserver.security.onelogin.OneloginAuthenticationFilter;
import org.geoserver.security.onelogin.OneloginAuthenticationFilterConfig;
import org.springframework.context.ApplicationContext;
import org.springframework.security.saml.SAMLAuthenticationProvider;

public class OneloginSecurityProvider
extends AbstractFilterProvider
implements SecurityManagerListener {
    private SAMLAuthenticationProvider samlAuthenticationProvider;
    private ApplicationContext context;

    public OneloginSecurityProvider(GeoServerSecurityManager securityManager) {
        this.context = securityManager.getApplicationContext();
        this.samlAuthenticationProvider = (SAMLAuthenticationProvider)this.context.getBean(SAMLAuthenticationProvider.class);
        securityManager.addListener((SecurityManagerListener)this);
    }

    public void handlePostChanged(GeoServerSecurityManager securityManager) {
        List aps = securityManager.getAuthenticationProviders();
        if (aps != null && !aps.contains(this.samlAuthenticationProvider)) {
            securityManager.getProviders().add(this.samlAuthenticationProvider);
        }
    }

    public void configure(XStreamPersister xp) {
        super.configure(xp);
        xp.getXStream().alias("oneloginAuthentication", OneloginAuthenticationFilterConfig.class);
    }

    public Class<? extends GeoServerSecurityFilter> getFilterClass() {
        return OneloginAuthenticationFilter.class;
    }

    public GeoServerSecurityFilter createFilter(SecurityNamedServiceConfig config) {
        return new OneloginAuthenticationFilter(this.context);
    }

    public void configureFilterChain(GeoServerSecurityFilterChain filterChain) {
        ConstantFilterChain samlChain;
        if (filterChain.getRequestChainByName("samlSSOChain") == null) {
            samlChain = new ConstantFilterChain(new String[]{"/saml/SSO/**"});
            samlChain.setFilterNames(new String[]{"samlWebSSOProcessingFilter"});
            samlChain.setName("samlSSOChain");
            filterChain.getRequestChains().add(0, samlChain);
        }
        if (filterChain.getRequestChainByName("samlLogoutChain") == null) {
            samlChain = new ConstantFilterChain(new String[]{"/saml/SingleLogout/**"});
            samlChain.setFilterNames(new String[]{"samlLogoutProcessingFilter"});
            samlChain.setName("samlLogoutChain");
            filterChain.getRequestChains().add(0, samlChain);
        }
        if (filterChain.getRequestChainByName("samlLogout") == null) {
            samlChain = new ConstantFilterChain(new String[]{"/saml/logout/**"});
            samlChain.setFilterNames(new String[]{"samlLogoutFilter"});
            samlChain.setName("samlLogout");
            filterChain.getRequestChains().add(0, samlChain);
        }
    }
}

