/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.onelogin.test;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.LogoutFilterChain;
import org.geoserver.security.auth.AbstractAuthenticationProviderTest;
import org.geoserver.security.config.PreAuthenticatedUserNameFilterConfig;
import org.geoserver.security.config.RoleSource;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.GeoServerLogoutFilter;
import org.geoserver.security.onelogin.OneloginAuthenticationFilter;
import org.geoserver.security.onelogin.OneloginAuthenticationFilterConfig;
import org.geoserver.security.onelogin.test.SSLUtilities;
import org.geoserver.security.onelogin.test.StringSamlDecoder;
import org.geotools.data.Base64;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.joda.time.DateTime;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opensaml.common.SAMLObject;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class OneloginAuthenticationTest
extends AbstractAuthenticationProviderTest {
    private static final String METADATA_URL = "/saml/metadata";
    private static final String REDIRECT_URL = "/trust/saml2/http-redirect/sso";
    private static final Integer IDP_PORT = 8443;
    private static final String IDP_LOGIN_URL = "http://localhost:" + IDP_PORT + "/login";
    private static OneloginAuthenticationFilterConfig config;
    private static WireMockServer idpSamlService;

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        idpSamlService.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)METADATA_URL)).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBodyFile("metadata.xml")));
        idpSamlService.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)REDIRECT_URL)).willReturn(WireMock.aResponse().withStatus(302).withHeader("Location", IDP_LOGIN_URL)));
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        SSLUtilities.registerKeyStore("keystore");
        idpSamlService = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().httpsPort(IDP_PORT));
        idpSamlService.start();
    }

    @Before
    public void before() throws Exception {
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        idpSamlService.shutdown();
    }

    @Test
    public void metadataDiscovery() throws Exception {
        this.confgiureFilter(PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.UserGroupService);
        WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)METADATA_URL)).withUrl(METADATA_URL));
    }

    @Test
    public void notAuthenticatedRedirect() throws Exception {
        this.confgiureFilter(PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.UserGroupService);
        MockHttpServletRequest request = this.createRequest("/foo/bar");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertTrue((response.getStatus() == 302 ? 1 : 0) != 0);
        String redirectURL = response.getHeader("Location");
        Assert.assertThat((Object)redirectURL, (Matcher)CoreMatchers.containsString((String)REDIRECT_URL));
        URIBuilder uriBuilder = new URIBuilder(redirectURL);
        List urlParameters = uriBuilder.getQueryParams();
        String samlRequest = null;
        for (NameValuePair par : urlParameters) {
            if (!par.getName().equals("SAMLRequest")) continue;
            samlRequest = par.getValue();
            break;
        }
        Assert.assertNotNull(samlRequest);
        StringSamlDecoder decoder = new StringSamlDecoder();
        SAMLObject samlRequestObject = decoder.decode(samlRequest);
        Assert.assertNotNull((Object)samlRequestObject);
    }

    @Test
    public void autorizationWithGroup() throws Exception {
        this.confgiureFilter(PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.UserGroupService);
        MockHttpServletRequest request = this.createRequest("/foo/bar");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        String encodedResponseMessage = this.buildSAMLRespons("abc@xyz.com");
        request = this.createRequest("/saml/SSO");
        request.setMethod("POST");
        request.addParameter("SAMLResponse", encodedResponseMessage);
        chain = new MockFilterChain();
        response = new MockHttpServletResponse();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        SecurityContext ctx = (SecurityContext)request.getSession(false).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNotNull((Object)ctx);
        Authentication auth = ctx.getAuthentication();
        Assert.assertNotNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.checkForAuthenticatedRole(auth);
        Assert.assertEquals((Object)"abc@xyz.com", (Object)auth.getPrincipal());
    }

    @Test
    public void authenticationWithRoles() throws Exception {
        this.confgiureFilter(PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.RoleService);
        MockHttpServletRequest request = this.createRequest("/foo/bar");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        String encodedResponseMessage = this.buildSAMLRespons("user1");
        request = this.createRequest("/saml/SSO");
        request.setMethod("POST");
        request.addParameter("SAMLResponse", encodedResponseMessage);
        chain = new MockFilterChain();
        response = new MockHttpServletResponse();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        SecurityContext ctx = (SecurityContext)request.getSession(false).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNotNull((Object)ctx);
        Authentication auth = ctx.getAuthentication();
        Assert.assertNotNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.checkForAuthenticatedRole(auth);
        boolean hasRootRole = false;
        for (GrantedAuthority a : auth.getAuthorities()) {
            if (!a.getAuthority().equals("RootRole")) continue;
            hasRootRole = true;
            break;
        }
        Assert.assertTrue((boolean)hasRootRole);
        Assert.assertEquals((Object)"user1", (Object)auth.getPrincipal());
    }

    @Test
    public void logoutTest() throws Exception {
        LogoutFilterChain logoutchain = (LogoutFilterChain)this.getSecurityManager().getSecurityConfig().getFilterChain().getRequestChainByName("webLogout");
        this.confgiureFilter(PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.RoleService);
        MockHttpServletRequest request = this.createRequest("/foo/bar");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        String encodedResponseMessage = this.buildSAMLRespons("user1");
        request = this.createRequest("/saml/SSO");
        request.setMethod("POST");
        request.addParameter("SAMLResponse", encodedResponseMessage);
        chain = new MockFilterChain();
        response = new MockHttpServletResponse();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        SecurityContext ctx = (SecurityContext)request.getSession(false).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNotNull((Object)ctx);
        Authentication auth = ctx.getAuthentication();
        Assert.assertEquals((Object)"user1", (Object)auth.getPrincipal());
        SecurityContextHolder.setContext((SecurityContext)ctx);
        request = this.createRequest((String)logoutchain.getPatterns().get(0));
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        GeoServerLogoutFilter logoutFilter = (GeoServerLogoutFilter)this.getSecurityManager().loadFilter("formLogout");
        logoutFilter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertTrue((response.getStatus() == 302 ? 1 : 0) != 0);
        String redirectURL = response.getHeader("Location");
        Assert.assertThat((Object)redirectURL, (Matcher)CoreMatchers.containsString((String)"/saml/logout"));
    }

    private String buildSAMLRespons(String username) throws Exception {
        Node value;
        int idx;
        DateTime now = new DateTime();
        String xml = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/__files/response.xml"), (String)"UTF-8");
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        Document doc = domFactory.newDocumentBuilder().parse(new InputSource(new ByteArrayInputStream(xml.getBytes("utf-8"))));
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList nodes = (NodeList)xpath.evaluate("//@IssueInstant", doc, XPathConstants.NODESET);
        for (idx = 0; idx < nodes.getLength(); ++idx) {
            value = nodes.item(idx);
            value.setNodeValue(now.toString("yyyy-MM-dd'T'HH:mm:ssZ"));
        }
        nodes = (NodeList)xpath.evaluate("//@NotOnOrAfter", doc, XPathConstants.NODESET);
        for (idx = 0; idx < nodes.getLength(); ++idx) {
            value = nodes.item(idx);
            value.setNodeValue(now.toString("yyyy-MM-dd'T'HH:mm:ssZ"));
        }
        nodes = (NodeList)xpath.evaluate("//@NotBefore", doc, XPathConstants.NODESET);
        for (idx = 0; idx < nodes.getLength(); ++idx) {
            value = nodes.item(idx);
            value.setNodeValue(now.toString("yyyy-MM-dd'T'HH:mm:ssZ"));
        }
        nodes = (NodeList)xpath.evaluate("//@AuthnInstant", doc, XPathConstants.NODESET);
        for (idx = 0; idx < nodes.getLength(); ++idx) {
            value = nodes.item(idx);
            value.setNodeValue(now.toString("yyyy-MM-dd'T'HH:mm:ssZ"));
        }
        nodes = (NodeList)xpath.evaluate("//@SessionNotOnOrAfter", doc, XPathConstants.NODESET);
        for (idx = 0; idx < nodes.getLength(); ++idx) {
            value = nodes.item(idx);
            value.setNodeValue(now.plusDays(1).toString("yyyy-MM-dd'T'HH:mm:ssZ"));
        }
        Node node = (Node)xpath.evaluate("//*[local-name() = 'NameID']/text()", doc, XPathConstants.NODE);
        node.setNodeValue(username);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        StringWriter writer = new StringWriter();
        xformer.transform(new DOMSource(doc), new StreamResult(writer));
        String output = writer.getBuffer().toString();
        String encodedResponseMessage = Base64.encodeBytes((byte[])output.getBytes("UTF-8"), (int)8).trim();
        return encodedResponseMessage;
    }

    private void confgiureFilter(PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource serviceType) {
        try {
            String oneloginFilterName = "testOneloginFilter";
            if (config == null) {
                config = new OneloginAuthenticationFilterConfig();
                config.setWantAssertionSigned(Boolean.valueOf(false));
                config.setClassName(OneloginAuthenticationFilter.class.getName());
                config.setName(oneloginFilterName);
                config.setEntityId("geoserver");
                config.setMetadataURL("https://localhost:" + idpSamlService.httpsPort() + METADATA_URL);
            }
            config.setUserGroupServiceName(serviceType == PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.RoleService ? "rs1" : "ug1");
            config.setRoleSource((RoleSource)serviceType);
            this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
            this.prepareFilterChain(this.pattern, new String[]{oneloginFilterName});
            this.modifyChain(this.pattern, false, true, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

