/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.tiles;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.MetaTile;

class VolatileGeoServerTileLayer
extends GeoServerTileLayer {
    static final Logger LOGGER = Logging.getLogger(VolatileGeoServerTileLayer.class);

    public VolatileGeoServerTileLayer(GeoServerTileLayer layer) {
        super(layer);
    }

    protected ConveyorTile getMetatilingResponse(ConveyorTile tile, boolean tryCache, int metaX, int metaY) throws GeoWebCacheException, IOException {
        return super.getMetatilingResponse(tile, false, 1, 1);
    }

    protected void saveTiles(MetaTile metaTile, ConveyorTile tileProto, long requestTime) throws GeoWebCacheException {
        long[] gridPos;
        GridSubset gridSubset = this.getGridSubset(tileProto.getGridSetId());
        if (!gridSubset.covers(gridPos = metaTile.getTilesGridPositions()[0])) {
            return;
        }
        ByteArrayResource resource = this.getImageBuffer(WMS_BUFFER2);
        tileProto.setBlob((Resource)resource);
        try {
            boolean completed = metaTile.writeTileToStream(0, (Resource)resource);
            if (!completed) {
                LOGGER.severe("metaTile.writeTileToStream returned false, no tiles saved");
            }
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, "Unable to write image tile to ByteArrayOutputStream", ioe);
        }
    }
}

