/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.tiles;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.stream.Collectors;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.ogcapi.AbstractDocument;
import org.geoserver.ogcapi.v1.tiles.Tileset;
import org.geoserver.wms.WMS;
import org.geowebcache.layer.TileLayer;

public class TilesDocument
extends AbstractDocument {
    private final Tileset.DataType dataType;
    private final List<Tileset> tilesets;
    private final String styleId;

    public TilesDocument(WMS wms, TileLayer tileLayer, Tileset.DataType dataType) {
        this(wms, tileLayer, dataType, null);
    }

    public TilesDocument(WMS wms, TileLayer tileLayer, Tileset.DataType dataType, String styleId) {
        this.tilesets = tileLayer.getGridSubsets().stream().map(subsetId -> new Tileset(wms, tileLayer, dataType, (String)subsetId, styleId, false)).collect(Collectors.toList());
        this.id = tileLayer instanceof GeoServerTileLayer ? ((GeoServerTileLayer)tileLayer).getContextualName() : tileLayer.getName();
        this.styleId = styleId;
        this.dataType = dataType;
        if (dataType == Tileset.DataType.vector) {
            this.addSelfLinks("ogc/tiles/v1/collections/" + this.id + "/tiles");
        } else if (dataType == Tileset.DataType.map) {
            if (styleId != null) {
                this.addSelfLinks("ogc/tiles/v1/collections/" + this.id + "/styles/" + styleId + "/map/tiles");
            } else {
                this.addSelfLinks("ogc/tiles/v1/collections/" + this.id + "/map/tiles");
            }
        } else {
            throw new IllegalArgumentException("Tiles of this type are not yet supported: " + dataType);
        }
    }

    @JsonIgnore
    public String getStyleId() {
        return this.styleId;
    }

    @JsonIgnore
    public Tileset.DataType getDataType() {
        return this.dataType;
    }

    public List<Tileset> getTilesets() {
        return this.tilesets;
    }
}

