/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.tiles;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.gwc.GWC;
import org.geoserver.ogcapi.APIException;
import org.geoserver.ogcapi.AbstractDocument;
import org.geoserver.ogcapi.Link;
import org.geoserver.ogcapi.v1.tiles.TiledCollectionDocument;
import org.geoserver.wms.WMS;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.util.logging.Logging;
import org.geowebcache.layer.TileLayer;
import org.springframework.http.HttpStatus;

@JsonPropertyOrder(value={"links", "collections"})
public class TiledCollectionsDocument
extends AbstractDocument {
    static final Logger LOGGER = Logging.getLogger(TiledCollectionsDocument.class);
    private final GWC gwc;
    private final GeoServer gs;
    private final WMS wms;

    public TiledCollectionsDocument(GeoServer gs, WMS wms, GWC gwc) {
        this.gs = gs;
        this.gwc = gwc;
        this.wms = wms;
        this.addSelfLinks("ogc/tiles/v1/collections/");
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public Iterator<TiledCollectionDocument> getCollections() {
        final Iterator tileLayers = this.gwc.getTileLayers().iterator();
        final boolean skipInvalid = this.gs.getGlobal().getResourceErrorHandling() == ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS;
        return new Iterator<TiledCollectionDocument>(){
            TiledCollectionDocument next;

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                while (tileLayers.hasNext()) {
                    TileLayer tileLayer = (TileLayer)tileLayers.next();
                    try {
                        TiledCollectionDocument collection;
                        this.next = collection = new TiledCollectionDocument(TiledCollectionsDocument.this.wms, tileLayer, true);
                        return true;
                    }
                    catch (FactoryException | TransformException e) {
                        if (skipInvalid) {
                            LOGGER.log(Level.WARNING, "Skipping tile layer " + tileLayers);
                            continue;
                        }
                        throw new APIException("InternalError", "Failed to iterate over the feature types in the catalog", HttpStatus.INTERNAL_SERVER_ERROR, e);
                    }
                }
                return this.next != null;
            }

            @Override
            public TiledCollectionDocument next() {
                TiledCollectionDocument result = this.next;
                this.next = null;
                return result;
            }
        };
    }
}

