/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.tiles;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.geoserver.ogcapi.AbstractDocument;
import org.geoserver.ogcapi.LinksBuilder;
import org.geoserver.ows.util.ResponseUtils;
import org.geowebcache.grid.Grid;
import org.geowebcache.grid.GridSet;
import org.springframework.http.MediaType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TileMatrixSetDocument
extends AbstractDocument {
    private String title;
    private String abstrac;
    private String[] keywords;
    private String supportedCRS;
    private String wellKnownScaleSet;
    private final List<TileMatrixEntry> tileMatrices = new ArrayList<TileMatrixEntry>();

    public TileMatrixSetDocument(GridSet gridSet, boolean summary) {
        this.id = gridSet.getName();
        this.title = Optional.ofNullable(gridSet.getDescription()).orElse(this.id);
        this.supportedCRS = gridSet.getSrs().getNumber() == 4326 ? "http://www.opengis.net/def/crs/OGC/1.3/CRS84" : "http://www.opengis.net/def/crs/EPSG/0/" + gridSet.getSrs().getNumber();
        String path = "ogc/tiles/v1/tileMatrixSets/" + ResponseUtils.urlEncode((String)this.id, (char[])new char[0]);
        if (summary) {
            new LinksBuilder(TileMatrixSetDocument.class).segment(path).title(this.id + " definition as ").rel("tileMatrixSet").add((AbstractDocument)this);
        } else {
            this.addSelfLinks(path, MediaType.APPLICATION_JSON);
            for (int z = 0; z < gridSet.getNumLevels(); ++z) {
                this.tileMatrices.add(new TileMatrixEntry(gridSet, z));
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getAbstract() {
        return this.abstrac;
    }

    public String[] getKeywords() {
        return this.keywords;
    }

    public String getSupportedCRS() {
        return this.supportedCRS;
    }

    public String getWellKnownScaleSet() {
        return this.wellKnownScaleSet;
    }

    public List<TileMatrixEntry> getTileMatrices() {
        return this.tileMatrices;
    }

    public String getEncodedId() {
        if (this.id == null) {
            return null;
        }
        return ResponseUtils.urlEncode((String)this.id, (char[])new char[0]);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class TileMatrixEntry {
        private String id;
        private String title;
        private String abstrac;
        private String[] keywords;
        private double scaleDenominator;
        private String cornerOfOrigin = "topLeft";
        private double[] pointOfOrigin;
        private int tileWidth;
        private int tileHeight;
        private long matrixWidth;
        private long matrixHeight;

        public TileMatrixEntry(GridSet gridSet, int z) {
            Grid grid = gridSet.getGrid(z);
            this.id = grid.getName();
            this.scaleDenominator = grid.getScaleDenominator();
            this.pointOfOrigin = gridSet.getOrderedTopLeftCorner(z);
            this.tileWidth = gridSet.getTileWidth();
            this.tileHeight = gridSet.getTileHeight();
            this.matrixWidth = grid.getNumTilesWide();
            this.matrixHeight = grid.getNumTilesHigh();
        }

        public String getId() {
            return this.id;
        }

        public String getTitle() {
            return this.title;
        }

        public String getAbstract() {
            return this.abstrac;
        }

        public String[] getKeywords() {
            return this.keywords;
        }

        public double getScaleDenominator() {
            return this.scaleDenominator;
        }

        public double[] getPointOfOrigin() {
            return this.pointOfOrigin;
        }

        public int getTileWidth() {
            return this.tileWidth;
        }

        public int getTileHeight() {
            return this.tileHeight;
        }

        public long getMatrixWidth() {
            return this.matrixWidth;
        }

        public long getMatrixHeight() {
            return this.matrixHeight;
        }

        public String getCornerOfOrigin() {
            return this.cornerOfOrigin;
        }
    }
}

