/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.tiles;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.ogcapi.AbstractDocument;
import org.geoserver.ogcapi.LinksBuilder;
import org.geoserver.ogcapi.StyleDocument;
import org.geoserver.ogcapi.v1.tiles.TilesDocument;
import org.geoserver.ogcapi.v1.tiles.TilesService;
import org.geoserver.ows.util.ResponseUtils;
import org.geowebcache.layer.TileLayer;

@JsonPropertyOrder(value={"styles", "links"})
public class StylesDocument
extends AbstractDocument {
    private final TileLayer tileLayer;
    private final String tileLayerId;

    public StylesDocument(TileLayer tileLayer) {
        this.tileLayer = tileLayer;
        this.tileLayerId = TilesService.getTileLayerId(tileLayer);
        this.addSelfLinks("ogc/tiles/v1/collections/" + ResponseUtils.urlEncode((String)this.tileLayerId, (char[])new char[0]) + "/styles");
    }

    public List<StyleDocument> getStyles() {
        return this.getStyleInfos().stream().map(this::toDocument).collect(Collectors.toList());
    }

    private StyleDocument toDocument(StyleInfo s) {
        StyleDocument result = s != null ? new StyleDocument(s) : new StyleDocument("_", "Default style for " + this.tileLayerId);
        if (!this.tileLayer.getMimeTypes().stream().allMatch(mt -> mt.isVector())) {
            new LinksBuilder(TilesDocument.class, "ogc/tiles/v1/collections").segment(this.tileLayerId, true).segment("styles/map/tiles").title("Tilesets list for " + this.tileLayerId + " with style " + s.getName() + ", represented as ").rel("http://www.opengis.net/def/rel/ogc/1.0/tilesets-map").add((AbstractDocument)result);
        }
        return result;
    }

    private List<StyleInfo> getStyleInfos() {
        PublishedInfo published;
        if (this.tileLayer instanceof GeoServerTileLayer && (published = ((GeoServerTileLayer)this.tileLayer).getPublishedInfo()) instanceof LayerInfo) {
            ArrayList<StyleInfo> result = new ArrayList<StyleInfo>();
            LayerInfo layer = (LayerInfo)published;
            result.addAll(layer.getStyles());
            StyleInfo defaultStyle = layer.getDefaultStyle();
            if (!result.contains(defaultStyle)) {
                result.add(defaultStyle);
            }
            return result;
        }
        return Collections.emptyList();
    }

    @JsonIgnore
    public TileLayer getTileLayer() {
        return this.tileLayer;
    }

    @JsonIgnore
    public String getTileLayerId() {
        return this.tileLayerId;
    }
}

