/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.tiles;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.geoserver.catalog.AttributionInfo;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.impl.AttributionInfoImpl;
import org.geoserver.data.test.MockData;
import org.geoserver.ogcapi.v1.tiles.TilesTestSupport;
import org.geoserver.ogcapi.v1.tiles.Tileset;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wms.WMS;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.NameImpl;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class TilesetDescriptionTest
extends TilesTestSupport {
    @Test
    public void getDataTilesMetadata() throws Exception {
        String roadSegments = this.getLayerId(MockData.ROAD_SEGMENTS);
        DocumentContext json = this.getAsJSONPath("ogc/tiles/v1/collections/" + roadSegments + "/tiles/EPSG:4326", 200);
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/tiles/v1/collections/cite%3ARoadSegments/tiles/EPSG:4326/{tileMatrix}/{tileRow}/{tileCol}?f=application%2Fvnd.mapbox-vector-tile", (Object)this.readSingle(json, "$.links[?(@.rel=='item' && @.type=='application/vnd.mapbox-vector-tile')].href"));
        MatcherAssert.assertThat((Object)((Iterable)json.read("links[?(@.type == 'application/json' && @.href =~ /.*ogc\\/tiles\\/v1\\/collections\\/cite:RoadSegments\\/tiles\\/EPSG:4326\\?.*/)].rel", new Predicate[0])), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"self"}));
        MatcherAssert.assertThat((Object)((Iterable)json.read("links[?(@.type != 'application/json' && @.href =~ /.*ogc\\/tiles\\/v1\\/collections\\/cite:RoadSegments\\/tiles\\/EPSG:4326\\?.*/ && @.rel == 'alternate')].type", new Predicate[0])), (Matcher)Matchers.hasItems((Object[])new String[]{"application/yaml"}));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/tiles/v1/collections/cite:RoadSegments/tiles/EPSG:4326/metadata?f=application%2Fjson", (Object)this.readSingle(json, "$.links[?(@.rel=='describedBy' && @.type=='application/json')].href"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.readSingle(json, "$.links[?(@.rel=='describedBy' && @.type=='application/json')].templated"));
        this.checkRoadSegmentsTileMatrix(json, Tileset.DataType.vector, true);
    }

    @Test
    public void testTileJSONSingleLayer() throws Exception {
        DocumentContext doc = this.getAsJSONPath("/ogc/tiles/v1/collections/cite:RoadSegments/tiles/EPSG:4326/metadata?f=application%2Fjson", 200);
        MatcherAssert.assertThat((Object)((String)doc.read("name", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"cite:RoadSegments"));
        MatcherAssert.assertThat((Object)((String)doc.read("scheme", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"xyz"));
        MatcherAssert.assertThat((Object)((String)this.readSingle(doc, "tiles")), (Matcher)Matchers.equalTo((Object)"http://localhost:8080/geoserver/ogc/tiles/v1/collections/cite%3ARoadSegments/tiles/EPSG:4326/{z}/{y}/{x}?f=application%2Fvnd.mapbox-vector-tile"));
        MatcherAssert.assertThat((Object)((Integer)doc.read("minzoom", new Predicate[0])), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)((Integer)doc.read("maxzoom", new Predicate[0])), (Matcher)Matchers.equalTo((Object)21));
        MatcherAssert.assertThat((Object)((List)doc.read("center", new Predicate[0])), (Matcher)Matchers.equalTo(Arrays.asList(0.0, 0.0, 0.0)));
        MatcherAssert.assertThat((Object)((List)doc.read("bounds", new Predicate[0])), (Matcher)Matchers.equalTo(Arrays.asList(-0.0042, -0.0024, 0.0042, 0.0024)));
        MatcherAssert.assertThat((Object)((Map)this.readSingle(doc, "vector_layers[?(@.id == 'RoadSegments')].fields")), (Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"FID", (Object)"string"), (Matcher)Matchers.hasEntry((Object)"NAME", (Object)"string")));
        MatcherAssert.assertThat((Object)((String)this.readSingle(doc, "vector_layers[?(@.id == 'RoadSegments')].geometry_type")), (Matcher)Matchers.equalTo((Object)"line"));
    }

    @Test
    public void testTileJSONLayerGroup() throws Exception {
        DocumentContext doc = this.getAsJSONPath("/ogc/tiles/v1/collections/nature/tiles/EPSG:900913/metadata?f=application%2Fjson", 200);
        MatcherAssert.assertThat((Object)((String)doc.read("name", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"nature"));
        MatcherAssert.assertThat((Object)((String)doc.read("scheme", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"xyz"));
        MatcherAssert.assertThat((Object)((String)this.readSingle(doc, "tiles")), (Matcher)Matchers.equalTo((Object)"http://localhost:8080/geoserver/ogc/tiles/v1/collections/nature/tiles/EPSG:900913/{z}/{y}/{x}?f=application%2Fvnd.mapbox-vector-tile"));
        MatcherAssert.assertThat((Object)((Iterable)doc.read("center", new Predicate[0])), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.closeTo((double)0.0, (double)1.0E-6), Matchers.closeTo((double)0.0, (double)1.0E-6), Matchers.closeTo((double)0.0, (double)1.0E-6)}));
        MatcherAssert.assertThat((Object)((List)doc.read("bounds", new Predicate[0])), (Matcher)Matchers.equalTo(Arrays.asList(-180.0, -90.0, 180.0, 90.0)));
        MatcherAssert.assertThat((Object)((Map)this.readSingle(doc, "vector_layers[?(@.id == 'Lakes')].fields")), (Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"FID", (Object)"string"), (Matcher)Matchers.hasEntry((Object)"NAME", (Object)"string")));
        MatcherAssert.assertThat((Object)((String)this.readSingle(doc, "vector_layers[?(@.id == 'Lakes')].geometry_type")), (Matcher)Matchers.equalTo((Object)"polygon"));
        MatcherAssert.assertThat((Object)((Map)this.readSingle(doc, "vector_layers[?(@.id == 'Forests')].fields")), (Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"FID", (Object)"string"), (Matcher)Matchers.hasEntry((Object)"NAME", (Object)"string")));
        MatcherAssert.assertThat((Object)((String)this.readSingle(doc, "vector_layers[?(@.id == 'Forests')].geometry_type")), (Matcher)Matchers.equalTo((Object)"polygon"));
    }

    @Test
    public void getDataTilesMetadataHTML() throws Exception {
        String roadSegments = this.getLayerId(MockData.ROAD_SEGMENTS);
        this.getAsJSoup("ogc/tiles/v1/collections/" + roadSegments + "/tiles?f=text/html");
    }

    @Test
    public void getMapTilesMetadata() throws Exception {
        String roadSegments = this.getLayerId(MockData.ROAD_SEGMENTS);
        DocumentContext json = this.getAsJSONPath("ogc/tiles/v1/collections/" + roadSegments + "/map/tiles/EPSG:4326", 200);
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/tiles/v1/collections/cite%3ARoadSegments/map/tiles/EPSG:4326/{tileMatrix}/{tileRow}/{tileCol}?f=image%2Fpng", (Object)this.readSingle(json, "$.links[?(@.rel=='item' && @.type=='image/png')].href"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/tiles/v1/collections/cite%3ARoadSegments/map/tiles/EPSG:4326/{tileMatrix}/{tileRow}/{tileCol}?f=image%2Fjpeg", (Object)this.readSingle(json, "$.links[?(@.rel=='item' && @.type=='image/jpeg')].href"));
        List infoFormats = ((WMS)GeoServerExtensions.bean((String)"wms")).getAvailableFeatureInfoFormats();
        for (String infoFormat : infoFormats) {
            Assert.assertEquals((Object)("http://localhost:8080/geoserver/ogc/tiles/v1/collections/cite%3ARoadSegments/map/tiles/EPSG:4326/{tileMatrix}/{tileRow}/{tileCol}/info?f=" + ResponseUtils.urlEncode((String)infoFormat, (char[])new char[0])), (Object)this.readSingle(json, "$.links[?(@.rel=='info' && @.type=='" + infoFormat + "')].href"));
        }
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/tiles/v1/collections/cite:RoadSegments/map/tiles/EPSG:4326/metadata?f=application%2Fjson&tileFormat={tileFormat}", (Object)this.readSingle(json, "$.links[?(@.rel=='describedBy' && @.type=='application/json')].href"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.readSingle(json, "$.links[?(@.rel=='describedBy' && @.type=='application/json')].templated"));
        this.checkRoadSegmentsTileMatrix(json, Tileset.DataType.map, true);
    }

    @Test
    public void testMapTileJSONSingleLayer() throws Exception {
        DocumentContext doc = this.getAsJSONPath("/ogc/tiles/v1/collections/cite:RoadSegments/map/tiles/EPSG:4326/metadata?f=application%2Fjson&tileFormat=image%2Fpng8", 200);
        MatcherAssert.assertThat((Object)((String)doc.read("name", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"cite:RoadSegments"));
        MatcherAssert.assertThat((Object)((String)doc.read("scheme", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"xyz"));
        MatcherAssert.assertThat((Object)((String)this.readSingle(doc, "tiles")), (Matcher)Matchers.equalTo((Object)"http://localhost:8080/geoserver/ogc/tiles/v1/collections/cite%3ARoadSegments/map/tiles/EPSG:4326/{z}/{y}/{x}?f=image%2Fpng8"));
        MatcherAssert.assertThat((Object)((List)doc.read("center", new Predicate[0])), (Matcher)Matchers.equalTo(Arrays.asList(0.0, 0.0, 0.0)));
        MatcherAssert.assertThat((Object)((List)doc.read("bounds", new Predicate[0])), (Matcher)Matchers.equalTo(Arrays.asList(-0.0042, -0.0024, 0.0042, 0.0024)));
        Assert.assertFalse((boolean)this.exists(doc, "vector_layers"));
    }

    @Test
    public void testTileJSONLayerGroupZoomLevelsLayerMetadata() throws Exception {
        DocumentContext doc = this.getAsJSONPath("/ogc/tiles/v1/collections/NatureZoom/tiles/EPSG:900913/metadata?f=application%2Fjson", 200);
        MatcherAssert.assertThat((Object)((String)doc.read("name", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"NatureZoom"));
        MatcherAssert.assertThat((Object)((Integer)this.readSingle(doc, "vector_layers[?(@.id == 'LakesZoom')].minzoom")), (Matcher)Matchers.equalTo((Object)10));
        MatcherAssert.assertThat((Object)((Integer)this.readSingle(doc, "vector_layers[?(@.id == 'LakesZoom')].maxzoom")), (Matcher)Matchers.equalTo((Object)13));
        MatcherAssert.assertThat((Object)((Integer)this.readSingle(doc, "vector_layers[?(@.id == 'ForestsZoom')].minzoom")), (Matcher)Matchers.equalTo((Object)13));
        MatcherAssert.assertThat((Object)((Integer)this.readSingle(doc, "vector_layers[?(@.id == 'ForestsZoom')].maxzoom")), (Matcher)Matchers.equalTo((Object)16));
        MatcherAssert.assertThat((Object)((Integer)doc.read("minzoom", new Predicate[0])), (Matcher)Matchers.equalTo((Object)10));
        MatcherAssert.assertThat((Object)((Integer)doc.read("maxzoom", new Predicate[0])), (Matcher)Matchers.equalTo((Object)16));
    }

    @Test
    public void testAdditionalAttributesTileJson() throws Exception {
        Catalog cat = this.getCatalog();
        LayerGroupInfo group = cat.getLayerGroupByName("NatureZoom");
        AttributionInfoImpl attributionInfo = new AttributionInfoImpl();
        attributionInfo.setTitle("This is the attribution title");
        String abstractTxt = "This is the layerGroup description";
        group.setAttribution((AttributionInfo)attributionInfo);
        group.setAbstract(abstractTxt);
        cat.save(group);
        LayerInfo li = cat.getLayerByName((Name)new NameImpl(FORESTS_ZOOM.getNamespaceURI(), FORESTS_ZOOM.getLocalPart()));
        String abstractTxtLi = "This is the ForestZoom layer description";
        li.setAbstract(abstractTxtLi);
        cat.save(li);
        DocumentContext doc = this.getAsJSONPath("/ogc/tiles/v1/collections/NatureZoom/tiles/EPSG:900913/metadata?f=application%2Fjson", 200);
        MatcherAssert.assertThat((Object)((String)doc.read("name", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"NatureZoom"));
        MatcherAssert.assertThat((Object)((String)doc.read("attribution", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"This is the attribution title"));
        MatcherAssert.assertThat((Object)((String)doc.read("description", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"This is the layerGroup description"));
        MatcherAssert.assertThat((Object)((String)doc.read("format", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"application/vnd.mapbox-vector-tile"));
        MatcherAssert.assertThat((Object)((String)doc.read("tilejson", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"2.2.0"));
        MatcherAssert.assertThat((Object)((String)this.readSingle(doc, "vector_layers[?(@.id == 'ForestsZoom')].description")), (Matcher)Matchers.equalTo((Object)"This is the ForestZoom layer description"));
    }

    public void checkRoadSegmentsTileMatrix(DocumentContext json, Tileset.DataType dataType, boolean checkLimits) {
        String matrixDefinition = "http://localhost:8080/geoserver/ogc/tiles/v1/tileMatrixSets/EPSG%3A4326";
        Assert.assertEquals((Object)matrixDefinition, (Object)json.read("tileMatrixSetURI", new Predicate[0]));
        Assert.assertEquals((Object)matrixDefinition, (Object)json.read("tileMatrixSetDefinition", new Predicate[0]));
        Assert.assertEquals((Object)dataType.toString(), (Object)json.read("dataType", new Predicate[0]));
        if (checkLimits) {
            Assert.assertEquals((Object)22, (Object)json.read("tileMatrixSetLimits.size()", new Predicate[0]));
            String crs84Limit0 = "tileMatrixSetLimits[0]";
            Assert.assertEquals((Object)"EPSG:4326:0", (Object)json.read(crs84Limit0 + ".tileMatrix", new Predicate[0]));
            Assert.assertEquals((Object)0, (Object)json.read(crs84Limit0 + ".minTileRow", new Predicate[0]));
            Assert.assertEquals((Object)0, (Object)json.read(crs84Limit0 + ".maxTileRow", new Predicate[0]));
            Assert.assertEquals((Object)0, (Object)json.read(crs84Limit0 + ".minTileCol", new Predicate[0]));
            Assert.assertEquals((Object)1, (Object)json.read(crs84Limit0 + ".maxTileCol", new Predicate[0]));
            String crs84Limit10 = "tileMatrixSetLimits[10]";
            Assert.assertEquals((Object)"EPSG:4326:10", (Object)json.read(crs84Limit10 + ".tileMatrix", new Predicate[0]));
            Assert.assertEquals((Object)511, (Object)json.read(crs84Limit10 + ".minTileRow", new Predicate[0]));
            Assert.assertEquals((Object)512, (Object)json.read(crs84Limit10 + ".maxTileRow", new Predicate[0]));
            Assert.assertEquals((Object)1023, (Object)json.read(crs84Limit10 + ".minTileCol", new Predicate[0]));
            Assert.assertEquals((Object)1024, (Object)json.read(crs84Limit10 + ".maxTileCol", new Predicate[0]));
        }
    }
}

