/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.tiles;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.geoserver.catalog.AttributionInfo;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.ogcapi.OGCApiTestSupport;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.NameImpl;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.parameters.RegexParameterFilter;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.mime.ApplicationMime;
import org.geowebcache.mime.ImageMime;

public class TilesTestSupport
extends OGCApiTestSupport {
    protected static final String POLYGON_COMMENT = "PolygonComment";
    protected static final String NATURE_GROUP = "nature";
    protected static final String BASIC_STYLE_GROUP = "BasicStyleGroup";
    protected static final String BASIC_STYLE_GROUP_STYLE = "BasicStyleGroupStyle";
    static final String FOREST_WITH_SCALES_STYLE = "ForestsWithScaleDenominator";
    static final String LAKES_WITH_SCALES_STYLE = "LakesWithScaleDenominator";
    static final String NATURES_ZOOM_GROUP = "NatureZoom";
    public static QName FORESTS_ZOOM = new QName(MockData.CITE_URI, "ForestsZoom", MockData.CITE_PREFIX);
    public static QName LAKES_ZOOM = new QName(MockData.CITE_URI, "LakesZoom", MockData.CITE_PREFIX);

    protected void setUpTestData(SystemTestData testData) throws Exception {
        testData.setUpDefault();
        testData.setUpDefaultRasterLayers();
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        String roadId = this.getLayerId(MockData.ROAD_SEGMENTS);
        GeoServerTileLayer roadTiles = (GeoServerTileLayer)this.getGWC().getTileLayerByName(roadId);
        Set formats = roadTiles.getInfo().getMimeFormats();
        formats.add(ApplicationMime.mapboxVector.getFormat());
        formats.add(ApplicationMime.topojson.getFormat());
        formats.add(ApplicationMime.geojson.getFormat());
        formats.add(ImageMime.png8.getFormat());
        RegexParameterFilter cqlFilter = new RegexParameterFilter();
        cqlFilter.setKey("CQL_FILTER");
        cqlFilter.setDefaultValue("INCLUDE");
        cqlFilter.setRegex(".*");
        roadTiles.getInfo().addParameterFilter((ParameterFilter)cqlFilter);
        this.getGWC().save((TileLayer)roadTiles);
        Catalog catalog = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(catalog);
        FeatureTypeInfo roadInfo = catalog.getFeatureTypeByName(roadId);
        cb.setupBounds((ResourceInfo)roadInfo);
        catalog.save((ResourceInfo)roadInfo);
        StyleInfo generic = catalog.getStyleByName("generic");
        LayerInfo layer = catalog.getLayerByName(roadId);
        layer.getStyles().add(generic);
        catalog.save(layer);
        FeatureTypeInfo lakes = (FeatureTypeInfo)catalog.getResourceByName(this.getLayerId(MockData.LAKES), FeatureTypeInfo.class);
        lakes.getMetadata().put("cachingEnabled", (Serializable)Boolean.valueOf(true));
        String forestsId = this.getLayerId(MockData.FORESTS);
        this.addVectorTileFormats(forestsId, true);
        LayerInfo lakesLayer = catalog.getLayerByName(this.getLayerId(MockData.LAKES));
        LayerInfo forestsLayer = catalog.getLayerByName(this.getLayerId(MockData.FORESTS));
        this.createsLayerGroup(catalog, NATURE_GROUP, null, null, null, Arrays.asList(lakesLayer, forestsLayer));
        testData.addStyle(BASIC_STYLE_GROUP_STYLE, "BasicStyleGroup.sld", TilesTestSupport.class, this.getCatalog());
        LayerGroupInfo lg = catalog.getFactory().createLayerGroup();
        StyleInfo s = catalog.getStyleByName(BASIC_STYLE_GROUP_STYLE);
        lg.setName(BASIC_STYLE_GROUP);
        lg.getLayers().add(null);
        lg.getStyles().add(s);
        new CatalogBuilder(catalog).calculateLayerGroupBounds(lg);
        catalog.add(lg);
        this.addVectorTileFormats(BASIC_STYLE_GROUP, false);
        testData.addStyle(FOREST_WITH_SCALES_STYLE, ((Object)((Object)this)).getClass(), this.getCatalog());
        testData.addStyle(LAKES_WITH_SCALES_STYLE, ((Object)((Object)this)).getClass(), this.getCatalog());
        HashMap<SystemTestData.LayerProperty, String> properties = new HashMap<SystemTestData.LayerProperty, String>();
        properties.put(SystemTestData.LayerProperty.STYLE, FOREST_WITH_SCALES_STYLE);
        testData.addVectorLayer(FORESTS_ZOOM, properties, "ForestsZoomTest.properties", ((Object)((Object)this)).getClass(), catalog);
        properties.put(SystemTestData.LayerProperty.STYLE, LAKES_WITH_SCALES_STYLE);
        testData.addVectorLayer(LAKES_ZOOM, properties, "LakesZoomTest.properties", ((Object)((Object)this)).getClass(), catalog);
        LayerInfo lakesZoom = catalog.getLayerByName((Name)new NameImpl(LAKES_ZOOM.getNamespaceURI(), LAKES_ZOOM.getLocalPart()));
        LayerInfo forestsZoom = catalog.getLayerByName((Name)new NameImpl(FORESTS_ZOOM.getNamespaceURI(), FORESTS_ZOOM.getLocalPart()));
        this.addVectorTileFormats(this.getLayerId(LAKES_ZOOM), true);
        this.addVectorTileFormats(this.getLayerId(FORESTS_ZOOM), true);
        this.createsLayerGroup(catalog, NATURES_ZOOM_GROUP, null, null, null, Arrays.asList(lakesZoom, forestsZoom));
    }

    protected void addVectorTileFormats(String layerId, boolean clear) {
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)this.getGWC().getTileLayerByName(layerId);
        Set formats = tileLayer.getInfo().getMimeFormats();
        if (clear) {
            formats.clear();
        }
        formats.add(ApplicationMime.mapboxVector.getFormat());
        formats.add(ApplicationMime.geojson.getFormat());
        formats.add(ApplicationMime.topojson.getFormat());
        this.getGWC().save((TileLayer)tileLayer);
    }

    protected GWC getGWC() {
        return (GWC)applicationContext.getBean(GWC.class);
    }

    protected LayerGroupInfo createsLayerGroup(Catalog catalog, String name, String description, AttributionInfo attributionInfo, LayerGroupInfo.Mode mode, List<LayerInfo> layers) throws Exception {
        LayerGroupInfo group = catalog.getFactory().createLayerGroup();
        group.setName(name);
        if (mode != null) {
            group.setMode(mode);
        }
        if (description != null) {
            group.setAbstract(description);
        }
        if (attributionInfo != null) {
            group.setAttribution(attributionInfo);
        }
        for (LayerInfo li : layers) {
            if (li == null) continue;
            group.getLayers().add(li);
            group.getStyles().add(null);
        }
        CatalogBuilder cb = new CatalogBuilder(catalog);
        cb.calculateLayerGroupBounds(group);
        catalog.add(group);
        this.addVectorTileFormats(name, false);
        return group;
    }
}

