/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.tiles;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.JsonContext;
import org.geoserver.ogcapi.v1.tiles.TilesService;
import org.geoserver.ogcapi.v1.tiles.TilesTestSupport;
import org.geoserver.platform.Service;
import org.geotools.util.Version;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class LandingPageTest
extends TilesTestSupport {
    @Test
    public void testServiceDescriptor() {
        Service service = this.getService("Tiles", new Version("1.0.0"));
        Assert.assertNotNull((Object)service);
        Assert.assertEquals((Object)"Tiles", (Object)service.getId());
        Assert.assertEquals((Object)new Version("1.0.0"), (Object)service.getVersion());
        MatcherAssert.assertThat((Object)service.getService(), (Matcher)CoreMatchers.instanceOf(TilesService.class));
        MatcherAssert.assertThat((Object)service.getOperations(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"getApi", "describeCollection", "getCollections", "getCollectionStyles", "getLandingPage", "getConformanceDeclaration", "describeTilesets", "describeTileset", "describeDefaultMapTilesets", "describeStyledMapTilesets", "describeMapTileset", "getTile", "getDefaultMapTile", "getStyledMapTile", "getTileMatrixSet", "getTileMatrixSets", "getQueryables", "getTilesMetadata"}));
    }

    @Test
    public void testLandingPageNoSlash() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/tiles/v1", 200);
        this.checkJSONLandingPage(json);
    }

    @Test
    public void testLandingPageSlash() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/tiles/v1/", 200);
        this.checkJSONLandingPage(json);
    }

    @Test
    public void testLandingPageJSON() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/tiles/v1?f=json", 200);
        this.checkJSONLandingPage(json);
    }

    @Test
    public void testLandingPageWorkspaceSpecific() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/tiles/v1", 200);
        this.checkJSONLandingPage(json);
    }

    @Test
    @Ignore
    public void testLandingPageXML() throws Exception {
        org.w3c.dom.Document dom = this.getAsDOM("ogc/tiles/v1?f=application/xml");
        this.print(dom);
    }

    @Test
    public void testLandingPageYaml() throws Exception {
        String yaml = this.getAsString("ogc/tiles/v1?f=application/yaml");
        JsonContext json = this.convertYamlToJsonPath(yaml);
        this.assertJSONList((DocumentContext)json, "links[?(@.type == 'application/yaml' && @.href =~ /.*ogc\\/tiles\\/v1\\/\\?.*/)].rel", new String[]{"self"});
        this.assertJSONList((DocumentContext)json, "links[?(@.type != 'application/yaml' && @.href =~ /.*ogc\\/tiles\\/v1\\/\\?.*/)].rel", new String[]{"alternate", "alternate"});
        this.checkJSONLandingPageShared((DocumentContext)json);
    }

    @Test
    public void testLandingPageHTML() throws Exception {
        Document document = this.getAsJSoup("ogc/tiles/v1?f=html");
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/tiles/v1/collections?f=text%2Fhtml", (Object)document.select("#htmlCollectionsLink").attr("href"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/tiles/v1/openapi?f=text%2Fhtml", (Object)document.select("#htmlApiLink").attr("href"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/tiles/v1/conformance?f=text%2Fhtml", (Object)document.select("#htmlConformanceLink").attr("href"));
    }

    @Test
    public void testLandingPageHTMLInWorkspace() throws Exception {
        Document document = this.getAsJSoup("sf/ogc/tiles/v1?f=html");
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/sf/ogc/tiles/v1/collections?f=text%2Fhtml", (Object)document.select("#htmlCollectionsLink").attr("href"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/sf/ogc/tiles/v1/openapi?f=text%2Fhtml", (Object)document.select("#htmlApiLink").attr("href"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/sf/ogc/tiles/v1/conformance?f=text%2Fhtml", (Object)document.select("#htmlConformanceLink").attr("href"));
    }

    void checkJSONLandingPage(DocumentContext json) {
        Assert.assertEquals((long)15L, (long)((Integer)json.read("links.length()", Integer.class, new Predicate[0])).intValue());
        this.assertJSONList(json, "links[?(@.type == 'application/json' && @.href =~ /.*ogc\\/tiles\\/v1\\/\\?.*/)].rel", new String[]{"self"});
        this.assertJSONList(json, "links[?(@.type != 'application/json' && @.href =~ /.*ogc\\/tiles\\/v1\\/\\?.*/)].rel", new String[]{"alternate", "alternate"});
        this.checkJSONLandingPageShared(json);
    }

    void checkJSONLandingPageShared(DocumentContext json) {
        this.assertJSONList(json, "links[?(@.href =~ /.*ogc\\/tiles\\/v1\\/openapi.*/)].rel", new String[]{"service-desc", "service-desc", "service-doc"});
        this.assertJSONList(json, "links[?(@.href =~ /.*ogc\\/tiles\\/v1\\/conformance.*/)].rel", new String[]{"http://www.opengis.net/def/rel/ogc/1.0/conformance", "http://www.opengis.net/def/rel/ogc/1.0/conformance", "http://www.opengis.net/def/rel/ogc/1.0/conformance"});
        this.assertJSONList(json, "links[?(@.href =~ /.*ogc\\/tiles\\/v1\\/collections.*/)].rel", new String[]{"http://www.opengis.net/def/rel/ogc/1.0/data", "http://www.opengis.net/def/rel/ogc/1.0/data", "http://www.opengis.net/def/rel/ogc/1.0/data"});
        Assert.assertEquals((Object)"Tiles Service", (Object)json.read("title", new Predicate[0]));
        Assert.assertEquals((Object)"", (Object)json.read("description", new Predicate[0]));
    }
}

