/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.tiles;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.JsonContext;
import java.util.List;
import org.geoserver.data.test.MockData;
import org.geoserver.ogcapi.v1.tiles.TilesTestSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class CollectionTest
extends TilesTestSupport {
    @Test
    public void testRoadsCollectionJson() throws Exception {
        String roadSegments = this.getLayerId(MockData.ROAD_SEGMENTS);
        DocumentContext json = this.getAsJSONPath("ogc/tiles/v1/collections/" + roadSegments, 200);
        this.testRoadsCollectionJson(json);
    }

    @Test
    public void testRoadsCollectionHTML() throws Exception {
        String roadSegments = this.getLayerId(MockData.ROAD_SEGMENTS);
        this.getAsJSoup("ogc/tiles/v1/collections/" + roadSegments + "?f=text/html");
    }

    @Test
    public void testOnlyMapLinks() throws Exception {
        String lakesId = this.getLayerId(MockData.LAKES);
        DocumentContext json = this.getAsJSONPath("ogc/tiles/v1/collections/" + lakesId, 200);
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/tiles/v1/collections/cite:Lakes/map/tiles?f=application%2Fjson", (Object)this.readSingle(json, "$.links[?(@.rel=='http://www.opengis.net/def/rel/ogc/1.0/tilesets-map' && @.type=='application/json')].href"));
    }

    @Test
    public void testOnlyDataLinks() throws Exception {
        String forestsId = this.getLayerId(MockData.FORESTS);
        DocumentContext json = this.getAsJSONPath("ogc/tiles/v1/collections/" + forestsId, 200);
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/tiles/v1/collections/cite:Forests/tiles?f=application%2Fjson", (Object)this.readSingle(json, "$.links[?(@.rel=='http://www.opengis.net/def/rel/ogc/1.0/tilesets-vector' && @.type=='application/json')].href"));
    }

    private void testRoadsCollectionJson(DocumentContext json) {
        Assert.assertEquals((Object)"cite:RoadSegments", (Object)json.read("$.id", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"RoadSegments", (Object)json.read("$.title", String.class, new Predicate[0]));
        Assert.assertEquals((double)-0.0042, (double)((Double)json.read("$.extent.spatial.bbox[0][0]", Double.class, new Predicate[0])), (double)0.0);
        Assert.assertEquals((double)-0.0024, (double)((Double)json.read("$.extent.spatial.bbox[0][1]", Double.class, new Predicate[0])), (double)0.0);
        Assert.assertEquals((double)0.0042, (double)((Double)json.read("$.extent.spatial.bbox[0][2]", Double.class, new Predicate[0])), (double)0.0);
        Assert.assertEquals((double)0.0024, (double)((Double)json.read("$.extent.spatial.bbox[0][3]", Double.class, new Predicate[0])), (double)0.0);
        Assert.assertEquals((Object)"http://www.opengis.net/def/crs/OGC/1.3/CRS84", (Object)json.read("$.extent.spatial.crs", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/tiles/v1/collections/cite:RoadSegments/map/tiles?f=application%2Fjson", (Object)this.readSingle(json, "$.links[?(@.rel=='http://www.opengis.net/def/rel/ogc/1.0/tilesets-map' && @.type=='application/json')].href"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/tiles/v1/collections/cite:RoadSegments/tiles?f=application%2Fjson", (Object)this.readSingle(json, "$.links[?(@.rel=='http://www.opengis.net/def/rel/ogc/1.0/tilesets-vector' && @.type=='application/json')].href"));
        Assert.assertEquals((Object)2, (Object)json.read("$.styles.size()", new Predicate[0]));
        Assert.assertEquals((Object)"RoadSegments", (Object)json.read("$.styles[0].id", new Predicate[0]));
        Assert.assertEquals((Object)"Default Styler", (Object)json.read("$.styles[0].title", new Predicate[0]));
        Assert.assertEquals((Object)"generic", (Object)json.read("$.styles[1].id", new Predicate[0]));
        Assert.assertEquals((Object)"Generic", (Object)json.read("$.styles[1].title", new Predicate[0]));
        String queryablesLink = (String)this.readSingle(json, "$.links[?(@.rel=='queryables' && @.type=='application/schema+json')].href");
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/tiles/v1/collections/cite:RoadSegments/queryables?f=application%2Fschema%2Bjson", (Object)queryablesLink);
        String queryablesTitle = (String)this.readSingle(json, "$.links[?(@.rel=='queryables' && @.type=='application/schema+json')].title");
        Assert.assertEquals((Object)"Collection queryables as application/schema+json", (Object)queryablesTitle);
    }

    @Test
    public void testRoadsCollectionYaml() throws Exception {
        String yaml = this.getAsString("ogc/tiles/v1/collections/" + this.getLayerId(MockData.ROAD_SEGMENTS) + "?f=application/yaml");
        JsonContext json = this.convertYamlToJsonPath(yaml);
        this.testRoadsCollectionJson((DocumentContext)json);
    }

    @Test
    public void testBluemarble() throws Exception {
        String roadSegments = this.getLayerId(MockData.TASMANIA_BM);
        DocumentContext json = this.getAsJSONPath("ogc/tiles/v1/collections/" + roadSegments, 200);
        Assert.assertEquals((Object)"wcs:BlueMarble", (Object)json.read("$.id", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"BlueMarble", (Object)json.read("$.title", String.class, new Predicate[0]));
        Assert.assertEquals((double)146.5, (double)((Double)json.read("$.extent.spatial.bbox[0][0]", Double.class, new Predicate[0])), (double)0.1);
        Assert.assertEquals((double)-44.5, (double)((Double)json.read("$.extent.spatial.bbox[0][1]", Double.class, new Predicate[0])), (double)0.1);
        Assert.assertEquals((double)148.0, (double)((Double)json.read("$.extent.spatial.bbox[0][2]", Double.class, new Predicate[0])), (double)0.1);
        Assert.assertEquals((double)-43.0, (double)((Double)json.read("$.extent.spatial.bbox[0][3]", Double.class, new Predicate[0])), (double)0.1);
        Assert.assertEquals((Object)"http://www.opengis.net/def/crs/OGC/1.3/CRS84", (Object)json.read("$.extent.spatial.crs", String.class, new Predicate[0]));
        List tilesLinks = (List)json.read("$.links[?(@.rel=='http://www.opengis.net/def/rel/ogc/1.0/tilesets-map' && @.type=='application/json')].href", new Predicate[0]);
        Assert.assertEquals((long)1L, (long)tilesLinks.size());
        MatcherAssert.assertThat((Object)tilesLinks, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"http://localhost:8080/geoserver/ogc/tiles/v1/collections/wcs:BlueMarble/map/tiles?f=application%2Fjson"}));
        Assert.assertEquals((Object)1, (Object)json.read("$.styles.size()", new Predicate[0]));
        Assert.assertEquals((Object)"raster", (Object)json.read("$.styles[0].id", new Predicate[0]));
        List items = (List)json.read("$.links[?(@.rel=='queryables' && @.type=='application/json')].href", new Predicate[0]);
        MatcherAssert.assertThat((Object)items, (Matcher)Matchers.empty());
    }
}

