/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.features.tiled;

import java.util.Set;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.ogcapi.OGCApiTestSupport;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.mime.ApplicationMime;

public class TiledFeaturesTestSupport
extends OGCApiTestSupport {
    protected static final String NATURE_GROUP = "nature";

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        String roadId = this.getLayerId(MockData.ROAD_SEGMENTS);
        GeoServerTileLayer roadTiles = (GeoServerTileLayer)this.getGWC().getTileLayerByName(roadId);
        Set formats = roadTiles.getInfo().getMimeFormats();
        formats.add(ApplicationMime.mapboxVector.getFormat());
        formats.add(ApplicationMime.topojson.getFormat());
        formats.add(ApplicationMime.geojson.getFormat());
        this.getGWC().save((TileLayer)roadTiles);
        CatalogBuilder cb = new CatalogBuilder(catalog);
        FeatureTypeInfo roadInfo = catalog.getFeatureTypeByName(roadId);
        cb.setupBounds((ResourceInfo)roadInfo);
        catalog.save((ResourceInfo)roadInfo);
        LayerGroupInfo group = catalog.getFactory().createLayerGroup();
        LayerInfo lakesLayer = catalog.getLayerByName(this.getLayerId(MockData.LAKES));
        LayerInfo forestsLayer = catalog.getLayerByName(this.getLayerId(MockData.FORESTS));
        if (lakesLayer != null && forestsLayer != null) {
            group.setName(NATURE_GROUP);
            group.getLayers().add(lakesLayer);
            group.getLayers().add(forestsLayer);
            group.getStyles().add(null);
            group.getStyles().add(null);
            new CatalogBuilder(catalog).calculateLayerGroupBounds(group);
            catalog.add(group);
        }
    }

    protected GWC getGWC() {
        return (GWC)applicationContext.getBean(GWC.class);
    }
}

