/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.processes;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.geoserver.ogcapi.v1.processes.Process;
import org.geoserver.ogcapi.v1.processes.ProcessInput;
import org.geoserver.ogcapi.v1.processes.ProcessOutput;
import org.geoserver.ogcapi.v1.processes.ProcessSummaryDocument;
import org.geotools.api.data.Parameter;
import org.geotools.util.logging.Logging;
import org.springframework.context.ApplicationContext;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ProcessDocument
extends ProcessSummaryDocument {
    private static final Logger LOGGER = Logging.getLogger(ProcessDocument.class);
    Map<String, ProcessInput> inputs = new LinkedHashMap<String, ProcessInput>();
    Map<String, ProcessOutput> outputs;

    public ProcessDocument(Process process, ApplicationContext context) {
        super(process);
        Collection<String> outputMimeParameters = process.getOutputParameters().values();
        for (Parameter<?> p : process.getInputList()) {
            if (outputMimeParameters.contains(p.key)) continue;
            ProcessInput input = new ProcessInput(p, context);
            this.inputs.put(p.getName(), input);
        }
        Map<String, Parameter<?>> outs = process.getResultInfo();
        this.outputs = new LinkedHashMap<String, ProcessOutput>();
        for (Parameter<?> p : outs.values()) {
            ProcessOutput output = new ProcessOutput((Parameter)p, context);
            this.outputs.put(p.getName(), output);
        }
        this.addSelfLinks("ogc/processes/v1/processes/" + process.getName());
    }

    public Map<String, ProcessInput> getInputs() {
        return this.inputs;
    }

    public Map<String, ProcessOutput> getOutputs() {
        return this.outputs;
    }
}

