/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.processes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.geoserver.ogcapi.APIException;
import org.geoserver.wps.process.AbstractRawData;
import org.geoserver.wps.process.GeoServerProcessors;
import org.geotools.api.data.Parameter;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.NameImpl;
import org.geotools.process.ProcessFactory;
import org.springframework.http.HttpStatus;

public class Process {
    private Name name;
    private ProcessFactory pf;

    public Process(String processId) {
        this.name = Process.toName(processId);
        this.pf = GeoServerProcessors.createProcessFactory((Name)this.name, (boolean)true);
        if (this.pf == null) {
            throw new APIException("InvalidParameterValue", "Process not found: " + processId, HttpStatus.NOT_FOUND);
        }
    }

    public Process(ProcessFactory pf, Name name) {
        this.name = name;
        this.pf = pf;
    }

    private static NameImpl toName(String processId) {
        int idx = processId.indexOf(58);
        if (idx < 0) {
            return new NameImpl(processId);
        }
        String namespace = processId.substring(0, idx);
        String localPart = processId.substring(idx + 1);
        return new NameImpl(namespace, localPart);
    }

    public Name getName() {
        return this.name;
    }

    public ProcessFactory getPf() {
        return this.pf;
    }

    public Map<String, String> getOutputParameters() {
        return AbstractRawData.getOutputMimeParameters((Name)this.name, (ProcessFactory)this.pf);
    }

    public Map<String, Parameter<?>> getInputMap() {
        return this.pf.getParameterInfo(this.name);
    }

    public List<Parameter<?>> getInputList() {
        return new ArrayList(this.pf.getParameterInfo(this.name).values());
    }

    public Map<String, Parameter<?>> getResultInfo() {
        return this.pf.getResultInfo(this.name, null);
    }

    public String getVersion() {
        return this.pf.getVersion(this.name);
    }

    public String getTitle() {
        return this.pf.getTitle(this.name).toString();
    }

    public String getDescription() {
        return this.pf.getDescription(this.name).toString();
    }
}

