/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.processes;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Arrays;
import org.geoserver.ogcapi.v1.processes.InputValue;

public class InputValueDeserializer
extends JsonDeserializer<InputValue> {
    static final String CRS84 = "http://www.opengis.net/def/crs/OGC/1.3/CRS84";
    static final String CRS84H = "http://www.opengis.net/def/crs/OGC/0/CRS84h";

    public InputValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        return this.getInputValue(node);
    }

    public InputValue getInputValue(JsonNode node) throws IOException {
        if (node.isArray()) {
            InputValue.ArrayInputValue array = new InputValue.ArrayInputValue();
            for (int i = 0; i < node.size(); ++i) {
                InputValue inputValue = this.getInputValueFlat(node.get(i));
                array.getValues().add(inputValue);
            }
            return array;
        }
        return this.getInputValueFlat(node);
    }

    private InputValue getInputValueFlat(JsonNode node) throws IOException {
        if (node.isObject()) {
            if (node.has("value")) {
                if (node.has("mediaType")) {
                    InputValue.InlineFileInputValue file = new InputValue.InlineFileInputValue();
                    file.value = node.get("value").asText();
                    file.mediaType = node.get("mediaType").asText();
                    return file;
                }
                InputValue.ComplexJSONInputValue complex = new InputValue.ComplexJSONInputValue();
                complex.value = node.get("value");
                return complex;
            }
            if (node.has("href")) {
                InputValue.ReferenceInputValue ref = new InputValue.ReferenceInputValue();
                ref.href = node.get("href").asText();
                ref.type = node.has("type") ? node.get("type").asText() : null;
                return ref;
            }
            if (node.has("bbox") && node.get("bbox").isArray()) {
                return InputValueDeserializer.parseBoundingBox(node);
            }
        } else {
            InputValue.LiteralInputValue literal = new InputValue.LiteralInputValue();
            literal.value = this.extractPrimitive(node);
            return literal;
        }
        throw new IOException("Unexpected input: " + node.toPrettyString());
    }

    private static InputValue.BoundingBoxInputValue parseBoundingBox(JsonNode node) throws IOException {
        String crsSpec;
        InputValue.BoundingBoxInputValue bbox = new InputValue.BoundingBoxInputValue();
        JsonNode array = node.get("bbox");
        double[] coords = new double[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            coords[i] = array.get(i).asDouble();
        }
        String string = crsSpec = node.has("crs") ? node.get("crs").asText() : null;
        if (coords.length == 4) {
            bbox.lowerCorner = Arrays.asList(coords[0], coords[1]);
            bbox.upperCorner = Arrays.asList(coords[2], coords[3]);
            bbox.crs = crsSpec == null ? CRS84 : crsSpec;
        } else if (coords.length == 6) {
            bbox.lowerCorner = Arrays.asList(coords[0], coords[1], coords[2]);
            bbox.upperCorner = Arrays.asList(coords[3], coords[4], coords[5]);
            bbox.crs = crsSpec == null ? CRS84 : crsSpec;
        } else {
            throw new IOException("Invalid number of coordinates in bounding box (should be 4 or 6): " + node);
        }
        return bbox;
    }

    private Object extractPrimitive(JsonNode node) {
        if (node.isTextual()) {
            return node.textValue();
        }
        if (node.isNumber()) {
            if (node.isInt()) {
                return node.intValue();
            }
            if (node.isLong()) {
                return node.longValue();
            }
            if (node.isFloat()) {
                return Float.valueOf(node.floatValue());
            }
            if (node.isDouble()) {
                return node.doubleValue();
            }
            return node.numberValue();
        }
        if (node.isBoolean()) {
            return node.booleanValue();
        }
        if (node.isNull()) {
            return null;
        }
        throw new IllegalArgumentException("Expected a JSON primitive but got: " + node);
    }
}

