/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.processes;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.text.StringEscapeUtils;

class GeneratorWriter
extends Writer {
    private final JsonGenerator generator;
    boolean escape;

    public GeneratorWriter(JsonGenerator generator, boolean escape) {
        this.generator = generator;
        this.escape = escape;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.escape) {
            String string = new String(cbuf, off, len);
            String escaped = StringEscapeUtils.escapeJson((String)string);
            this.generator.writeRaw(escaped);
        } else {
            this.generator.writeRaw(cbuf, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        this.generator.flush();
    }

    @Override
    public void close() throws IOException {
    }
}

