/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.processes;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minidev.json.JSONArray;
import org.geoserver.ogcapi.OGCApiTestSupport;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.junit.Assert;
import org.junit.Test;

public class ProcessDescriptionTest
extends OGCApiTestSupport {
    @Test
    public void testBufferProcess() throws Exception {
        DocumentContext doc = this.getAsJSONPath("ogc/processes/v1/processes/JTS:buffer", 200);
        Assert.assertEquals((Object)"JTS:buffer", (Object)doc.read("id", new Predicate[0]));
        Assert.assertEquals((Object)"Buffer", (Object)doc.read("title", new Predicate[0]));
        Assert.assertEquals((Object)"Returns a polygonal geometry representing the input geometry enlarged by a given distance around its exterior.", (Object)doc.read("description", new Predicate[0]));
        Assert.assertEquals(List.of("sync-execute", "async-execute"), (Object)doc.read("jobControlOptions", new Predicate[0]));
        DocumentContext geom = this.readContext(doc, "inputs.geom");
        Assert.assertEquals((Object)"Input geometry", (Object)geom.read("description", new Predicate[0]));
        Assert.assertEquals((long)1L, (long)((Integer)geom.read("minOccurs", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)geom.read("maxOccurs", Integer.class, new Predicate[0])).intValue());
        JSONArray geomSchema = (JSONArray)this.readContext(geom, "schema.oneOf").json();
        ProcessDescriptionTest.checkGeometrySchema(geomSchema);
        DocumentContext distance = this.readContext(doc, "inputs.distance");
        Assert.assertEquals((Object)"Distance to buffer the input geometry, in the units of the geometry", (Object)distance.read("description", new Predicate[0]));
        Assert.assertEquals((long)1L, (long)((Integer)distance.read("minOccurs", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)distance.read("maxOccurs", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((Object)"number", (Object)distance.read("schema.type", new Predicate[0]));
        DocumentContext quadrants = this.readContext(doc, "inputs.quadrantSegments");
        Assert.assertEquals((Object)"Number determining the style and smoothness of buffer corners. Positive numbers create round corners with that number of segments per quarter-circle, 0 creates flat corners.", (Object)quadrants.read("description", new Predicate[0]));
        Assert.assertEquals((long)0L, (long)((Integer)quadrants.read("minOccurs", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)quadrants.read("maxOccurs", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((Object)"integer", (Object)quadrants.read("schema.type", new Predicate[0]));
        DocumentContext capStyle = this.readContext(doc, "inputs.capStyle");
        Assert.assertEquals((Object)"Style for the buffer end caps. Values are: Round - rounded ends (default), Flat - flat ends; Square - square ends.", (Object)capStyle.read("description", new Predicate[0]));
        Assert.assertEquals((long)0L, (long)((Integer)capStyle.read("minOccurs", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)capStyle.read("maxOccurs", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((Object)"string", (Object)capStyle.read("schema.type", new Predicate[0]));
        Assert.assertEquals(List.of("Round", "Flat", "Square"), (Object)capStyle.read("schema.enum", new Predicate[0]));
        DocumentContext result = this.readContext(doc, "outputs.result");
        Assert.assertEquals((Object)"Buffered geometry", (Object)result.read("description", new Predicate[0]));
        JSONArray resultSchema = (JSONArray)this.readContext(geom, "schema.oneOf").json();
        ProcessDescriptionTest.checkGeometrySchema(resultSchema);
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/processes/v1/processes/JTS:buffer?f=application%2Fjson", (Object)this.readSingle(doc, "links[?(@.rel == 'self')].href"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/processes/v1/processes/JTS:buffer?f=text%2Fhtml", (Object)this.readSingle(doc, "links[?(@.rel == 'alternate' && @.type == 'text/html')].href"));
    }

    private static void checkGeometrySchema(JSONArray geomSchema) {
        HashSet<String> expectedTypes = new HashSet<String>(Set.of("application/json", "application/gml-2.1.2", "application/gml-3.1.1"));
        for (int i = 0; i < geomSchema.size(); ++i) {
            Map schema = (Map)geomSchema.get(i);
            String type = (String)schema.get("type");
            String format = (String)schema.get("format");
            String mediaType = (String)schema.get("contentMediaType");
            Assert.assertEquals((Object)"string", (Object)type);
            if (!expectedTypes.remove(mediaType)) continue;
            Assert.assertNull((Object)format);
        }
        Assert.assertEquals((String)("Could not find some expected type: " + expectedTypes), (long)0L, (long)expectedTypes.size());
    }

    @Test
    public void testBufferProcessHTML() throws Exception {
        Document doc = this.getAsJSoup("ogc/processes/v1/processes/JTS:buffer?f=html");
        String pageTitle = doc.title();
        Assert.assertEquals((Object)"JTS:buffer", (Object)pageTitle);
        Assert.assertEquals((Object)"Buffer", (Object)doc.getElementById("JTS__buffer_title").text());
        Assert.assertEquals((Object)"Returns a polygonal geometry representing the input geometry enlarged by a given distance around its exterior.", (Object)doc.getElementById("JTS__buffer_description").text());
        Element inputsTable = doc.select("div.card:has(h2:contains(Process inputs)) table.function-table").first();
        Assert.assertNotNull((String)"Inputs table not found", (Object)inputsTable);
        Elements inputRows = inputsTable.select("tr[id]");
        Assert.assertEquals((long)4L, (long)inputRows.size());
        Set<String> geometryFormats = Set.of("application/json", "application/wkt", "application/ewkt", "application/gml-2.1.2", "application/gml-3.1.1");
        this.checkInputRow((Element)inputRows.get(0), "geom", "Geometry", "1/1", "Input geometry", geometryFormats);
        this.checkInputRow((Element)inputRows.get(1), "distance", "number", "1/1", "Distance to buffer the input geometry, in the units of the geometry", Set.of());
        this.checkInputRow((Element)inputRows.get(2), "quadrantSegments", "integer", "0/1", "Number determining the style and smoothness of buffer corners. Positive numbers create round corners with that number of segments per quarter-circle, 0 creates flat corners.", Set.of());
        this.checkInputRow((Element)inputRows.get(3), "capStyle", "string", "0/1", "Style for the buffer end caps. Values are: Round - rounded ends (default), Flat - flat ends; Square - square ends.", Set.of());
        Element outputsTable = doc.select("div.card:has(h2:contains(Process outputs)) table.function-table").first();
        Assert.assertNotNull((String)"Outputs table not found", (Object)outputsTable);
        Elements outputRows = outputsTable.select("tr[id]");
        Assert.assertEquals((long)1L, (long)outputRows.size());
        this.checkOutputRow((Element)outputRows.get(0), "result", "Geometry", "Buffered geometry", geometryFormats);
    }

    private void checkInputRow(Element row, String expectedId, String expectedType, String expectedOccurrences, String expectedDesc, Set<String> expectedFormats) {
        Elements cols = row.select("td");
        Assert.assertEquals((long)5L, (long)cols.size());
        Assert.assertEquals((Object)expectedId, (Object)((Element)cols.get(0)).text());
        Assert.assertEquals((Object)expectedType, (Object)((Element)cols.get(1)).text());
        Assert.assertEquals((Object)expectedOccurrences, (Object)((Element)cols.get(2)).text());
        Assert.assertEquals((Object)expectedDesc, (Object)((Element)cols.get(3)).text());
        Set actualFormats = ((Element)cols.get(4)).select("span").stream().map(e -> e.text()).collect(Collectors.toSet());
        if (expectedFormats.isEmpty()) {
            Assert.assertTrue((String)("No formats expected, but found: " + actualFormats), (boolean)actualFormats.isEmpty());
        } else {
            Assert.assertEquals((String)"Expected formats do not match", expectedFormats, actualFormats);
        }
    }

    private void checkOutputRow(Element row, String expectedId, String expectedType, String expectedDesc, Set<String> expectedFormats) {
        Elements cols = row.select("td");
        Assert.assertEquals((long)4L, (long)cols.size());
        Assert.assertEquals((Object)expectedId, (Object)((Element)cols.get(0)).text());
        Assert.assertEquals((Object)expectedType, (Object)((Element)cols.get(1)).text());
        Assert.assertEquals((Object)expectedDesc, (Object)((Element)cols.get(2)).text());
        Set actualFormats = ((Element)cols.get(3)).select("span").stream().map(e -> e.text()).collect(Collectors.toSet());
        if (expectedFormats.isEmpty()) {
            Assert.assertTrue((String)("No formats expected, but found: " + actualFormats), (boolean)actualFormats.isEmpty());
        } else {
            Assert.assertEquals((String)"Expected formats do not match", expectedFormats, actualFormats);
        }
    }
}

