/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.processes;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.servers.Server;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.ogcapi.OGCApiTestSupport;
import org.geoserver.test.GeoServerBaseTestSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class ApiTest
extends OGCApiTestSupport {
    @Test
    public void testApiJson() throws Exception {
        MockHttpServletResponse response = this.getAsMockHttpServletResponse("ogc/processes/v1/openapi", 200);
        this.validateJSONAPI(response);
    }

    private void validateJSONAPI(MockHttpServletResponse response) throws UnsupportedEncodingException, JsonProcessingException {
        MatcherAssert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.startsWith((String)"application/vnd.oai.openapi+json;version=3.0"));
        String json = response.getContentAsString();
        LOGGER.log(Level.INFO, json);
        ObjectMapper mapper = Json.mapper();
        OpenAPI api = (OpenAPI)mapper.readValue(json, OpenAPI.class);
        this.validateApi(api);
    }

    @Test
    public void testHTMLEncoding() throws Exception {
        MockHttpServletResponse response = this.getAsMockHttpServletResponse("ogc/processes/v1?f=text/html", 200);
        Assert.assertEquals((Object)"text/html", (Object)response.getContentType());
        String html = response.getContentAsString();
        GeoServerBaseTestSupport.LOGGER.info(html);
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">"));
    }

    @Test
    public void testApiHTML() throws Exception {
        MockHttpServletResponse response = this.getAsMockHttpServletResponse("ogc/processes/v1/openapi?f=text/html", 200);
        Assert.assertEquals((Object)"text/html", (Object)response.getContentType());
        String html = response.getContentAsString();
        LOGGER.info(html);
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<link rel=\"icon\" type=\"image/png\" href=\"http://localhost:8080/geoserver/swagger-ui/favicon-32x32.png\" sizes=\"32x32\" />"));
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<link rel=\"icon\" type=\"image/png\" href=\"http://localhost:8080/geoserver/swagger-ui/favicon-16x16.png\" sizes=\"16x16\" />"));
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<script src=\"http://localhost:8080/geoserver/swagger-ui/swagger-ui-bundle.js\">"));
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<script src=\"http://localhost:8080/geoserver/swagger-ui/swagger-ui-standalone-preset.js\">"));
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<script src=\"http://localhost:8080/geoserver/webresources/ogcapi/api.js\">"));
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<input type=\"hidden\" id=\"apiLocation\" value=\"http://localhost:8080/geoserver/ogc/processes/v1/openapi?f=application%2Fvnd.oai.openapi%2Bjson%3Bversion%3D3.0\"/>"));
        MatcherAssert.assertThat((Object)html, (Matcher)Matchers.not((Matcher)CoreMatchers.containsString((String)"<script>")));
    }

    @Test
    public void testApiYaml() throws Exception {
        String yaml = this.getAsString("ogc/processes/v1/openapi?f=application/yaml");
        this.validateYAMLApi(yaml);
    }

    private void validateYAMLApi(String yaml) throws JsonProcessingException {
        GeoServerBaseTestSupport.LOGGER.log(Level.INFO, yaml);
        ObjectMapper mapper = Yaml.mapper();
        OpenAPI api = (OpenAPI)mapper.readValue(yaml, OpenAPI.class);
        this.validateApi(api);
    }

    @Test
    public void testYamlAsAcceptsHeader() throws Exception {
        MockHttpServletRequest request = this.createRequest("ogc/processes/v1/openapi");
        request.setMethod("GET");
        request.setContent(new byte[0]);
        request.addHeader("Accept", (Object)"foo/bar, application/yaml, text/html");
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        MatcherAssert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.startsWith((String)"application/yaml"));
        String yaml = this.string(new ByteArrayInputStream(response.getContentAsString().getBytes()));
        ObjectMapper mapper = Yaml.mapper();
        OpenAPI api = (OpenAPI)mapper.readValue(yaml, OpenAPI.class);
        this.validateApi(api);
    }

    private void validateApi(OpenAPI api) {
        List servers = api.getServers();
        MatcherAssert.assertThat((Object)servers, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((Server)servers.get(0)).getUrl(), (Matcher)CoreMatchers.equalTo((Object)"http://localhost:8080/geoserver/ogc/processes/v1"));
        Assert.assertEquals((Object)"1.0.0", (Object)api.getInfo().getVersion());
        Paths paths = api.getPaths();
        PathItem landing = (PathItem)paths.get((Object)"/");
        Assert.assertNotNull((Object)landing);
        MatcherAssert.assertThat((Object)landing.getGet().getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"getLandingPage"));
        PathItem conformance = (PathItem)paths.get((Object)"/conformance");
        Assert.assertNotNull((Object)conformance);
        MatcherAssert.assertThat((Object)conformance.getGet().getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"getConformanceClasses"));
        PathItem processes = (PathItem)paths.get((Object)"/processes");
        Assert.assertNotNull((Object)processes);
        MatcherAssert.assertThat((Object)processes.getGet().getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"getProcesses"));
        PathItem process = (PathItem)paths.get((Object)"/processes/{processID}");
        Assert.assertNotNull((Object)process);
        MatcherAssert.assertThat((Object)process.getGet().getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"getProcessDescription"));
        PathItem execution = (PathItem)paths.get((Object)"/processes/{processID}/execution");
        Assert.assertNotNull((Object)execution);
        Operation executePost = execution.getPost();
        MatcherAssert.assertThat((Object)executePost.getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"execute"));
        PathItem jobs = (PathItem)paths.get((Object)"/jobs");
        Assert.assertNotNull((Object)jobs);
        MatcherAssert.assertThat((Object)jobs.getGet().getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"getJobs"));
        PathItem job = (PathItem)paths.get((Object)"/jobs/{jobId}");
        Assert.assertNotNull((Object)job);
        MatcherAssert.assertThat((Object)job.getGet().getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"getStatus"));
        MatcherAssert.assertThat((Object)job.getDelete().getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"dismiss"));
        PathItem results = (PathItem)paths.get((Object)"/jobs/{jobId}/results");
        Assert.assertNotNull((Object)results);
        MatcherAssert.assertThat((Object)results.getGet().getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"getResult"));
    }
}

