/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.processes;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ogcapi.OGCApiTestSupport;
import org.geoserver.wps.MonkeyProcess;
import org.geoserver.wps.MultiRawProcess;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.DataUtilities;
import org.geotools.data.geojson.GeoJSONReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.process.ProcessFactory;
import org.geotools.process.Processors;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.springframework.mock.web.MockHttpServletResponse;

public class AbstractExecutionTest
extends OGCApiTestSupport {
    public static final String JOBS_BASE = "http://localhost:8080/geoserver/ogc/processes/v1/jobs/";

    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        testData.setUpDefaultRasterLayers();
    }

    protected void checkBufferCollectionJSON(MockHttpServletResponse response) throws IOException {
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        try (GeoJSONReader reader = new GeoJSONReader(response.getContentAsString());){
            SimpleFeatureCollection fc = reader.getFeatures();
            Assert.assertEquals(MultiPolygon.class, (Object)fc.getSchema().getGeometryDescriptor().getType().getBinding());
            Assert.assertEquals((long)2L, (long)fc.size());
        }
    }

    protected void checkDEMContours(MockHttpServletResponse response) throws IOException {
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        try (GeoJSONReader reader = new GeoJSONReader(response.getContentAsString());){
            SimpleFeatureCollection fc = reader.getFeatures();
            Assert.assertEquals(LineString.class, (Object)((SimpleFeatureType)fc.getSchema()).getGeometryDescriptor().getType().getBinding());
            MatcherAssert.assertThat((Object)fc.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(100)));
            ReferencedEnvelope envelope = new ReferencedEnvelope(145.0, 146.0, -41.0, -43.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            Set<Double> levels = Set.of(Double.valueOf(100.0), Double.valueOf(200.0), Double.valueOf(300.0));
            try (SimpleFeatureIterator fi = fc.features();){
                while (fi.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)fi.next();
                    LineString sf = (LineString)feature.getDefaultGeometry();
                    Assert.assertTrue((String)"Contour line is not inside the data envelope", (boolean)envelope.contains(sf.getEnvelopeInternal()));
                    Assert.assertTrue((boolean)levels.contains(feature.getAttribute("value")));
                }
            }
        }
    }

    protected void checkRectangleClip(MockHttpServletResponse response) throws Exception {
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        try (GeoJSONReader reader = new GeoJSONReader(response.getContentAsString());){
            SimpleFeatureCollection fc = reader.getFeatures();
            Assert.assertEquals(MultiPolygon.class, (Object)((SimpleFeatureType)fc.getSchema()).getGeometryDescriptor().getType().getBinding());
            Assert.assertEquals((long)1L, (long)fc.size());
            SimpleFeature first = (SimpleFeature)DataUtilities.first((FeatureCollection)fc);
            Assert.assertEquals((Object)"Illinois", (Object)first.getAttribute("STATE_NAME"));
        }
    }

    protected String getBody(String fileName) throws IOException {
        String body;
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(fileName);){
            body = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
        }
        return body;
    }

    static {
        Processors.addProcessFactory((ProcessFactory)MonkeyProcess.getFactory());
        Processors.addProcessFactory((ProcessFactory)MultiRawProcess.getFactory());
    }
}

