/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.maps;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.config.GeoServer;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.AbstractServiceHTMLMessageConverter;
import org.geoserver.ogcapi.FreemarkerTemplateSupport;
import org.geoserver.ogcapi.v1.maps.HTMLMap;
import org.geoserver.ogcapi.v1.maps.MapsService;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSMapContent;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.ProjectedCRS;
import org.geotools.util.logging.Logging;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.stereotype.Component;

@Component
public class HTMLMapMessageConverter
extends AbstractServiceHTMLMessageConverter<HTMLMap> {
    static final Logger LOGGER = Logging.getLogger(HTMLMapMessageConverter.class);
    private static final Set<String> IGNORED_PARAMETERS = new HashSet<String>(Arrays.asList("REQUEST", "TILED", "BBOX", "SERVICE", "VERSION", "FORMAT", "WIDTH", "HEIGHT", "SRS"));

    public HTMLMapMessageConverter(FreemarkerTemplateSupport templateSupport, GeoServer geoServer) {
        super(HTMLMap.class, WMSInfo.class, templateSupport, geoServer);
    }

    protected void writeInternal(HTMLMap htmlMap, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        GetMapRequest getMapRequest = htmlMap.getMapContent().getRequest();
        HashMap model = this.setupModel(getMapRequest);
        model.put("units", this.getUnits(htmlMap.getMapContent()));
        APIRequestInfo ri = APIRequestInfo.get();
        HttpServletRequest httpRequest = ri.getRequest();
        model.put("url", httpRequest.getRequestURL());
        model.put("parameters", this.getLayerParameter(getMapRequest.getRawKvp()));
        Charset defaultCharset = this.getDefaultCharset();
        if (outputMessage != null && outputMessage.getBody() != null && defaultCharset != null) {
            this.templateSupport.processTemplate(null, "htmlmap.ftl", MapsService.class, (Map)model, (Writer)new OutputStreamWriter(outputMessage.getBody(), defaultCharset), defaultCharset);
        } else {
            LOGGER.warning("Either the default character set, output message or body was null, so the htmlmap.ftl template could not be processed.");
        }
    }

    protected String getUnits(WMSMapContent mapContent) {
        CoordinateReferenceSystem crs = mapContent.getRequest().getCrs();
        String result = crs instanceof ProjectedCRS ? "m" : "degrees";
        try {
            String unit = crs.getCoordinateSystem().getAxis(0).getUnit().toString();
            String degreeSign = "\u00b0";
            if (null != unit) {
                switch (unit) {
                    case "\u00b0": 
                    case "degrees": 
                    case "dd": {
                        result = "degrees";
                        break;
                    }
                    case "m": 
                    case "meters": {
                        result = "m";
                        break;
                    }
                    case "km": 
                    case "kilometers": {
                        result = "mi";
                        break;
                    }
                    case "in": 
                    case "inches": {
                        result = "inches";
                        break;
                    }
                    case "ft": 
                    case "feets": {
                        result = "ft";
                        break;
                    }
                    case "mi": 
                    case "miles": {
                        result = "mi";
                        break;
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.log(Level.WARNING, "Error trying to determine unit of measure", e);
        }
        return result;
    }

    private List<Map<String, String>> getLayerParameter(Map<String, String> rawKvp) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(rawKvp.size());
        for (Map.Entry<String, String> en : rawKvp.entrySet()) {
            String paramName = en.getKey();
            if (IGNORED_PARAMETERS.contains(paramName.toUpperCase())) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", paramName);
            map.put("value", en.getValue());
            result.add(map);
        }
        return result;
    }
}

