/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.maps;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.ogcapi.AbstractDocument;
import org.geoserver.ogcapi.Link;
import org.geoserver.ogcapi.v1.maps.CollectionDocument;
import org.geoserver.platform.ServiceException;
import org.geotools.api.filter.Filter;
import org.geotools.util.logging.Logging;

@JsonPropertyOrder(value={"links", "collections"})
public class CollectionsDocument
extends AbstractDocument {
    static final Logger LOGGER = Logging.getLogger(CollectionsDocument.class);
    private final GeoServer geoServer;
    private final List<Consumer<CollectionDocument>> collectionDecorators = new ArrayList<Consumer<CollectionDocument>>();
    private final boolean skipInvalid;

    public CollectionsDocument(GeoServer geoServer) {
        this.geoServer = geoServer;
        String path = "ogc/maps/v1/collections/";
        this.addSelfLinks(path);
        this.skipInvalid = geoServer.getGlobal().getResourceErrorHandling() == ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS;
    }

    @JacksonXmlProperty(localName="Links")
    public List<Link> getLinks() {
        return this.links;
    }

    @JacksonXmlProperty(localName="Collection")
    public Iterator<CollectionDocument> getCollections() {
        final CloseableIterator publisheds = this.geoServer.getCatalog().list(PublishedInfo.class, (Filter)Filter.INCLUDE);
        return new Iterator<CollectionDocument>(){
            CollectionDocument next;

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                while (publisheds.hasNext()) {
                    PublishedInfo published = (PublishedInfo)publisheds.next();
                    try {
                        this.next = CollectionsDocument.this.getCollectionDocument(published, (CloseableIterator<PublishedInfo>)publisheds);
                        return true;
                    }
                    catch (Exception e) {
                        if (CollectionsDocument.this.skipInvalid) {
                            LOGGER.log(Level.WARNING, "Skipping map type " + published.prefixedName());
                            continue;
                        }
                        publisheds.close();
                        throw new ServiceException("Failed to iterate over the map types in the catalog", (Throwable)e);
                    }
                }
                return this.next != null;
            }

            @Override
            public CollectionDocument next() {
                CollectionDocument result = this.next;
                this.next = null;
                return result;
            }
        };
    }

    private CollectionDocument getCollectionDocument(PublishedInfo published, CloseableIterator<PublishedInfo> publisheds) throws IOException {
        CollectionDocument collection = new CollectionDocument(this.geoServer, published);
        for (Consumer<CollectionDocument> collectionDecorator : this.collectionDecorators) {
            collectionDecorator.accept(collection);
        }
        return collection;
    }

    public void addCollectionDecorator(Consumer<CollectionDocument> decorator) {
        this.collectionDecorators.add(decorator);
    }
}

