/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.maps;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import org.geoserver.ogcapi.v1.maps.MapsTestSupport;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.junit.Test;

public class ConformanceTest
extends MapsTestSupport {
    @Test
    public void testConformanceJson() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/maps/v1/conformance", 200);
        this.checkConformance(json);
    }

    private void checkConformance(DocumentContext json) {
        Assert.assertEquals((long)2L, (long)((Integer)json.read("$.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)6L, (long)((Integer)json.read("$.conformsTo.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((Object)"http://www.opengis.net/spec/ogcapi-common-1/1.0/conf/core", (Object)json.read("$.conformsTo[0]", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"http://www.opengis.net/spec/ogcapi-common-2/1.0/conf/collections", (Object)json.read("$.conformsTo[1]", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"http://www.opengis.net/spec/ogcapi-maps-1/1.0/conf/core", (Object)json.read("$.conformsTo[2]", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"http://www.opengis.net/spec/ogcapi-maps-1/1.0/conf/geodata", (Object)json.read("$.conformsTo[3]", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"http://www.opengis.net/spec/ogcapi-maps-2/1.0/conf/bbox", (Object)json.read("$.conformsTo[4]", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"http://www.opengis.net/spec/ogcapi-maps-2/1.0/conf/crs", (Object)json.read("$.conformsTo[5]", String.class, new Predicate[0]));
    }

    @Test
    public void testCollectionsYaml() throws Exception {
        String yaml = this.getAsString("ogc/maps/v1/conformance/?f=application/yaml");
        this.checkConformance((DocumentContext)this.convertYamlToJsonPath(yaml));
    }

    @Test
    public void testConformanceHTML() throws Exception {
        Document document = this.getAsJSoup("ogc/maps/v1/conformance?f=text/html");
        Assert.assertEquals((Object)"GeoServer OGC API Maps Conformance", (Object)document.select("#title").text());
        Assert.assertEquals((Object)"http://www.opengis.net/spec/ogcapi-common-1/1.0/conf/core", (Object)document.select("#content li:eq(0)").text());
        Assert.assertEquals((Object)"http://www.opengis.net/spec/ogcapi-common-2/1.0/conf/collections", (Object)document.select("#content li:eq(1)").text());
        Assert.assertEquals((Object)"http://www.opengis.net/spec/ogcapi-maps-1/1.0/conf/core", (Object)document.select("#content li:eq(2)").text());
        Assert.assertEquals((Object)"http://www.opengis.net/spec/ogcapi-maps-1/1.0/conf/geodata", (Object)document.select("#content li:eq(3)").text());
        Assert.assertEquals((Object)"http://www.opengis.net/spec/ogcapi-maps-2/1.0/conf/bbox", (Object)document.select("#content li:eq(4)").text());
        Assert.assertEquals((Object)"http://www.opengis.net/spec/ogcapi-maps-2/1.0/conf/crs", (Object)document.select("#content li:eq(5)").text());
    }
}

