/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.maps;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ogcapi.v1.maps.MapsTestSupport;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.junit.Test;

public class CollectionTest
extends MapsTestSupport {
    private static final String NATURE_GROUP = "NATURE";
    private static final String NATURE_TITLE = "I love nature";

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo lakesType = catalog.getFeatureTypeByName(this.getLayerId(MockData.LAKES));
        CatalogBuilder cb = new CatalogBuilder(catalog);
        cb.setupBounds((ResourceInfo)lakesType);
        catalog.save((ResourceInfo)lakesType);
        LayerGroupInfo group = catalog.getFactory().createLayerGroup();
        LayerInfo lakes = catalog.getLayerByName(this.getLayerId(MockData.LAKES));
        LayerInfo forests = catalog.getLayerByName(this.getLayerId(MockData.FORESTS));
        if (lakes != null && forests != null) {
            group.setName(NATURE_GROUP);
            group.setTitle(NATURE_TITLE);
            group.getLayers().add(lakes);
            group.getLayers().add(forests);
            group.getStyles().add(null);
            group.getStyles().add(null);
            cb.calculateLayerGroupBounds(group);
            catalog.add(group);
        }
    }

    @Test
    public void testLayerJson() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/maps/v1/collections/" + this.getLayerId(MockData.LAKES), 200);
        this.testLakesJson(json);
    }

    private void testLakesJson(DocumentContext json) {
        Assert.assertEquals((Object)"cite:Lakes", (Object)json.read("id", new Predicate[0]));
        Assert.assertEquals((Object)"Lakes", (Object)json.read("title", new Predicate[0]));
        DocumentContext spatial = this.readSingleContext(json, "$.extent.spatial.bbox");
        Assert.assertEquals((double)6.0E-4, (double)((Double)spatial.read("$[0]", new Predicate[0])), (double)0.0);
        Assert.assertEquals((double)-0.0018, (double)((Double)spatial.read("$[1]", new Predicate[0])), (double)0.0);
        Assert.assertEquals((double)0.0031, (double)((Double)spatial.read("$[2]", new Predicate[0])), (double)0.0);
        Assert.assertEquals((double)-1.0E-4, (double)((Double)spatial.read("$[3]", new Predicate[0])), (double)0.0);
    }

    @Test
    public void testLayerGroupJson() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/maps/v1/collections/NATURE", 200);
        this.testNatureJson(json);
    }

    private void testNatureJson(DocumentContext json) {
        Assert.assertEquals((Object)NATURE_GROUP, (Object)json.read("id", new Predicate[0]));
        Assert.assertEquals((Object)NATURE_TITLE, (Object)json.read("title", new Predicate[0]));
        DocumentContext spatial = this.readSingleContext(json, "$.extent.spatial.bbox");
        Assert.assertEquals((double)-180.0, (double)((Double)spatial.read("$[0]", new Predicate[0])), (double)0.0);
        Assert.assertEquals((double)-90.0, (double)((Double)spatial.read("$[1]", new Predicate[0])), (double)0.0);
        Assert.assertEquals((double)180.0, (double)((Double)spatial.read("$[2]", new Predicate[0])), (double)0.0);
        Assert.assertEquals((double)90.0, (double)((Double)spatial.read("$[3]", new Predicate[0])), (double)0.0);
    }

    @Test
    public void testTemporalCollectionHTML() throws Exception {
        this.setupRasterDimension(TIMESERIES, "time", DimensionPresentation.LIST, null, null, null);
        Document document = this.getAsJSoup("ogc/maps/v1/collections/sf:timeseries?f=html");
        String id = this.getLayerId(TIMESERIES).replace(":", "__");
        Assert.assertEquals((Object)"Temporal extent: 2014-01-01T00:00:00Z/2019-01-01T00:00:00Z", (Object)document.select("#" + id + "_temporal").text());
    }

    @Test
    public void testTemporalSqlDateHTML() throws Exception {
        this.setupStartEndTimeDimension(TIME_WITH_START_END_DATE, "time", "startTime", "endTime");
        Document document = this.getAsJSoup("ogc/maps/v1/collections/sf:TimeWithStartEndDate?f=html");
        String id = this.getLayerId(TIME_WITH_START_END_DATE).replace(":", "__");
        Assert.assertEquals((Object)"Temporal extent: 2012-02-11/2012-02-14", (Object)document.select("#" + id + "_temporal").text());
    }

    @Test
    public void testTemporalSqlDateJSON() throws Exception {
        this.setupStartEndTimeDimension(TIME_WITH_START_END_DATE, "time", "startTime", "endTime");
        DocumentContext json = this.getAsJSONPath("ogc/maps/v1/collections/sf:TimeWithStartEndDate", 200);
        Assert.assertEquals((Object)"2012-02-11T00:00:00Z", (Object)json.read("$.extent.temporal.interval[0][0]", new Predicate[0]));
        Assert.assertEquals((Object)"2012-02-14T00:00:00Z", (Object)json.read("$.extent.temporal.interval[0][1]", new Predicate[0]));
    }

    @Test
    public void testCollectionJson() throws Exception {
        this.setupRasterDimension(TIMESERIES, "time", DimensionPresentation.LIST, null, null, null);
        DocumentContext json = this.getAsJSONPath("ogc/maps/v1/collections/sf:timeseries", 200);
        Assert.assertEquals((Object)"2014-01-01T00:00:00Z", (Object)json.read("$.extent.temporal.interval[0][0]", new Predicate[0]));
        Assert.assertEquals((Object)"2019-01-01T00:00:00Z", (Object)json.read("$.extent.temporal.interval[0][1]", new Predicate[0]));
    }
}

