/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.maps;

import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geoserver.ogcapi.v1.maps.FeatureInfoResponse;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSExtensions;
import org.geoserver.wms.featureinfo.GetFeatureInfoOutputFormat;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.stereotype.Component;

@Component
public class FeatureInfoResponseMessageConverter
implements HttpMessageConverter<FeatureInfoResponse>,
ApplicationContextAware {
    static final Logger LOGGER = Logging.getLogger(FeatureInfoResponseMessageConverter.class);
    private final WMS wms;
    private List<GetFeatureInfoOutputFormat> outputFormats;

    public FeatureInfoResponseMessageConverter(WMS wms) {
        this.wms = wms;
    }

    public boolean canRead(Class<?> aClass, MediaType mediaType) {
        return false;
    }

    public boolean canWrite(Class<?> aClass, MediaType mediaType) {
        return FeatureInfoResponse.class.isAssignableFrom(aClass) && (mediaType == null || this.getSupportedMediaTypes().stream().anyMatch(mt -> mt.isCompatibleWith(mediaType)));
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.outputFormats.stream().map(of -> {
            try {
                return MediaType.parseMediaType((String)of.getContentType());
            }
            catch (InvalidMediaTypeException e) {
                return null;
            }
        }).filter(mt -> mt != null).collect(Collectors.toList());
    }

    public FeatureInfoResponse read(Class<? extends FeatureInfoResponse> aClass, HttpInputMessage httpInputMessage) throws IOException, HttpMessageNotReadableException {
        throw new UnsupportedOperationException();
    }

    public void write(FeatureInfoResponse response, MediaType mediaType, HttpOutputMessage httpOutputMessage) throws IOException, HttpMessageNotWritableException {
        GetFeatureInfoOutputFormat of = this.wms.getFeatureInfoOutputFormat(response.getRequest().getInfoFormat());
        of.write(response.getResult(), response.getRequest(), httpOutputMessage.getBody());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.outputFormats = WMSExtensions.findFeatureInfoFormats((ApplicationContext)applicationContext);
    }
}

