/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.maps;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.IOException;
import java.util.logging.Logger;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ogcapi.APIException;
import org.geoserver.ogcapi.AbstractCollectionDocument;
import org.geoserver.ogcapi.AbstractDocument;
import org.geoserver.ogcapi.CollectionExtents;
import org.geoserver.ogcapi.LinkInfoConverter;
import org.geoserver.ogcapi.LinksBuilder;
import org.geoserver.ogcapi.TimeExtentCalculator;
import org.geoserver.ogcapi.v1.maps.MapsService;
import org.geoserver.ogcapi.v1.maps.StylesDocument;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.DateRange;
import org.geotools.util.logging.Logging;
import org.springframework.http.HttpStatus;

@JsonPropertyOrder(value={"id", "title", "description", "extent", "links"})
public class CollectionDocument
extends AbstractCollectionDocument<PublishedInfo> {
    static final Logger LOGGER = Logging.getLogger(CollectionDocument.class);
    PublishedInfo published;

    public CollectionDocument(GeoServer geoServer, PublishedInfo published) throws IOException {
        super((Object)published);
        String collectionId;
        LinkInfoConverter.addLinksToDocument((AbstractDocument)this, (PublishedInfo)published, MapsService.class);
        this.id = collectionId = published.prefixedName();
        this.title = published.getTitle();
        this.description = published.getAbstract();
        ReferencedEnvelope bbox = this.getSpatialExtents(published);
        DateRange timeExtent = this.getTimeExtent(published);
        this.setExtent(new CollectionExtents(bbox, timeExtent));
        this.published = published;
        this.addSelfLinks("ogc/maps/v1/collections/" + this.id);
        new LinksBuilder(StylesDocument.class, "ogc/maps/v1/collections/").segment(published.prefixedName(), true).segment("styles").title("Styles as ").rel("styles").add((AbstractDocument)this);
    }

    private ReferencedEnvelope getSpatialExtents(PublishedInfo published) {
        try {
            if (published instanceof LayerInfo) {
                if (((LayerInfo)published).getResource().getLatLonBoundingBox() == null) {
                    throw new RuntimeException("Layer has no bounding box: " + published);
                }
                return ((LayerInfo)published).getResource().getLatLonBoundingBox();
            }
            if (published instanceof LayerGroupInfo) {
                ReferencedEnvelope bounds = ((LayerGroupInfo)published).getBounds();
                return bounds.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
            }
            throw new RuntimeException("Unexpected, don't know how to handle: " + published);
        }
        catch (FactoryException | TransformException e) {
            throw new APIException("NoApplicableCode", "Failed to transform bounding box to WGS84", HttpStatus.INTERNAL_SERVER_ERROR, e);
        }
    }

    private DateRange getTimeExtent(PublishedInfo published) throws IOException {
        if (published instanceof LayerInfo) {
            return TimeExtentCalculator.getTimeExtent((ResourceInfo)((LayerInfo)published).getResource());
        }
        if (!(published instanceof LayerGroupInfo)) {
            throw new RuntimeException("Unexpected, don't know how to handle: " + published);
        }
        LOGGER.fine("Time extent not supported for Layer Groups");
        return null;
    }
}

