/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.maps;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.JsonContext;
import java.util.List;
import java.util.Map;
import org.geoserver.ogcapi.APIDispatcher;
import org.geoserver.ogcapi.v1.maps.CollectionsDocument;
import org.geoserver.ogcapi.v1.maps.MapsTestSupport;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.http.MediaType;

public class StylesTest
extends MapsTestSupport {
    @Test
    public void testCollectionsJsonDefault() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/maps/v1/collections/BlueMarble/styles", 200);
        this.testStylesJson(json, MediaType.APPLICATION_JSON);
    }

    @Test
    public void testCollectionsJson() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/maps/v1/collections/BlueMarble/styles?f=json", 200);
        this.testStylesJson(json, MediaType.APPLICATION_JSON);
    }

    @Test
    public void testCollectionsJsonSlash() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/maps/v1/collections/BlueMarble/styles/?f=json", 200);
        this.testStylesJson(json, MediaType.APPLICATION_JSON);
    }

    @Test
    public void testCollectionsYaml() throws Exception {
        String yaml = this.getAsString("ogc/maps/v1/collections/BlueMarble/styles?f=application/yaml");
        JsonContext json = this.convertYamlToJsonPath(yaml);
        this.testStylesJson((DocumentContext)json, MediaType.parseMediaType((String)"application/yaml"));
    }

    private void testStylesJson(DocumentContext json, MediaType defaultFormat) {
        Assert.assertEquals((long)1L, (long)((Integer)json.read("styles.length()", Integer.class, new Predicate[0])).intValue());
        List formats = ((APIDispatcher)GeoServerExtensions.bean(APIDispatcher.class, (ApplicationContext)GeoServerSystemTestSupport.applicationContext)).getProducibleMediaTypes(CollectionsDocument.class, true);
        formats.forEach(format -> {
            List items = (List)json.read("links[?(@.type=='" + format + "')]", List.class, new Predicate[0]);
            Map item = (Map)items.get(0);
            if (defaultFormat.equals(format)) {
                Assert.assertEquals((Object)"self", item.get("rel"));
            } else {
                Assert.assertEquals((Object)"alternate", item.get("rel"));
            }
        });
    }
}

