/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.images;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.geoserver.config.GeoServer;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.v1.images.AssetHasher;
import org.geoserver.ogcapi.v1.images.ImagesCollectionsDocument;
import org.geoserver.ogcapi.v1.images.ImagesResponse;
import org.geoserver.ogcapi.v1.images.ImagesService;
import org.geoserver.ogcapi.v1.images.MimeTypeSupport;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.json.GeoJSONBuilder;
import org.geoserver.wfs.json.GeoJSONGetFeatureResponse;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geotools.api.data.FileGroupProvider;
import org.geotools.api.feature.Feature;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;

@Component
public class STACItemFeaturesResponse
extends GeoJSONGetFeatureResponse {
    public static final String MIME = "application/stac+json";
    private final AssetHasher assetHasher;

    public STACItemFeaturesResponse(GeoServer gs, AssetHasher assetLinkHandler) {
        super(gs, MIME);
        this.assetHasher = assetLinkHandler;
    }

    protected boolean canHandleInternal(Operation operation) {
        return true;
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return MIME;
    }

    public void write(Object value, OutputStream output, Operation operation) throws IOException {
        if (this.getImageId() != null) {
            this.writeSingleItem((FeatureCollectionResponse)value, output, operation);
        } else {
            super.write(value, output, operation);
        }
    }

    private String getImageId() {
        return Optional.ofNullable(RequestContextHolder.getRequestAttributes()).map(att -> (String)att.getAttribute(ImagesService.IMAGE_ID, 0)).orElse(null);
    }

    private void writeSingleItem(FeatureCollectionResponse value, OutputStream output, Operation operation) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(output, this.gs.getGlobal().getSettings().getCharset());
        try (BufferedWriter outWriter = new BufferedWriter(osw);){
            FeatureCollectionResponse featureCollection = value;
            boolean isComplex = STACItemFeaturesResponse.isComplexFeature((FeatureCollectionResponse)featureCollection);
            GeoJSONBuilder jsonWriter = this.getGeoJSONBuilder(featureCollection, outWriter);
            this.writeFeatures(featureCollection.getFeatures(), operation, isComplex, jsonWriter);
            outWriter.flush();
        }
    }

    protected void writeExtraFeatureProperties(Feature feature, Operation operation, GeoJSONBuilder jw) {
        jw.key("stac_version").value((Object)"0.8.0");
        jw.key("collection").value((Object)this.getParentCollectionId());
        this.writeAssets(feature, jw);
        this.writeLinks(null, operation, jw, feature.getIdentifier().getID());
    }

    private void writeAssets(Feature feature, GeoJSONBuilder jw) {
        Object filesCandidate = feature.getUserData().get("GranuleFiles");
        if (!(filesCandidate instanceof FileGroupProvider.FileGroup)) {
            return;
        }
        FileGroupProvider.FileGroup files = (FileGroupProvider.FileGroup)filesCandidate;
        jw.key("assets").array();
        String featureId = feature.getIdentifier().getID();
        this.writeAssetLink(featureId, files.getMainFile(), jw);
        if (files.getSupportFiles() != null) {
            for (File supportFile : files.getSupportFiles()) {
                this.writeAssetLink(featureId, supportFile, jw);
            }
        }
        jw.endArray();
    }

    private void writeAssetLink(String featureId, File file, GeoJSONBuilder jw) {
        try {
            jw.object();
            String href = this.getFileDownloadURL(this.getParentCollectionId(), featureId, file);
            jw.key("href").value((Object)href);
            jw.key("title").value((Object)file.getName());
            jw.key("type").value((Object)MimeTypeSupport.guessMimeType(file.getName()));
            jw.endObject();
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IO error while writing assets", e);
        }
    }

    private String getFileDownloadURL(String collectionId, String imageId, File file) throws IOException {
        String fileNameHash = this.assetHasher.hashFile(file);
        return ResponseUtils.buildURL((String)APIRequestInfo.get().getBaseURL(), (String)("ogc/images/v1/collections/" + ResponseUtils.urlEncode((String)collectionId, (char[])new char[0]) + "/images/" + ResponseUtils.urlEncode((String)imageId, (char[])new char[0]) + "/assets/" + ResponseUtils.urlEncode((String)fileNameHash, (char[])new char[0])), null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
    }

    protected void writePagingLinks(FeatureCollectionResponse response, Operation operation, GeoJSONBuilder jw) {
        this.writeLinks(response, operation, jw, null);
    }

    private void writeLinks(FeatureCollectionResponse response, Operation operation, GeoJSONBuilder jw, String featureId) {
        String linkType;
        String href;
        APIRequestInfo requestInfo = APIRequestInfo.get();
        String baseUrl = requestInfo.getBaseURL();
        String basePath = "ogc/images/v1/collections/" + ResponseUtils.urlEncode((String)this.getParentCollectionId(), (char[])new char[0]);
        jw.key("links");
        jw.array();
        if (response != null && this.getImageId() == null && featureId == null) {
            if (response.getPrevious() != null) {
                this.writeLink(jw, "Previous page", MIME, "prev", response.getPrevious());
            }
            if (response.getNext() != null) {
                this.writeLink(jw, "Next page", MIME, "next", response.getNext());
            }
            FeatureCollection fc = (FeatureCollection)response.getFeatures().get(0);
            try (FeatureIterator fi = fc.features();){
                while (fi.hasNext()) {
                    Feature next = fi.next();
                    href = ResponseUtils.buildURL((String)baseUrl, (String)(basePath + "/images/" + ResponseUtils.urlEncode((String)next.getIdentifier().getID(), (char[])new char[0])), Collections.singletonMap("f", MIME), (URLMangler.URLType)URLMangler.URLType.SERVICE);
                    linkType = "item";
                    this.writeLink(jw, null, MIME, linkType, href);
                }
            }
        }
        Collection formats = requestInfo.getProducibleMediaTypes(ImagesResponse.class, true);
        for (MediaType format : formats) {
            String path = basePath + "/images";
            if (featureId != null) {
                path = path + "/" + ResponseUtils.urlEncode((String)featureId, (char[])new char[0]);
            }
            String href2 = ResponseUtils.buildURL((String)baseUrl, (String)path, Collections.singletonMap("f", format.toString()), (URLMangler.URLType)URLMangler.URLType.SERVICE);
            String linkType2 = "alternate";
            Object linkTitle = "This document as " + format;
            if (format.toString().equals(MIME)) {
                linkType2 = "self";
                linkTitle = "This document";
            }
            this.writeLink(jw, (String)linkTitle, format.toString(), linkType2, href2);
        }
        if (featureId == null || this.getImageId() != null) {
            for (MediaType format : requestInfo.getProducibleMediaTypes(ImagesCollectionsDocument.class, true)) {
                href = ResponseUtils.buildURL((String)baseUrl, (String)basePath, Collections.singletonMap("f", format.toString()), (URLMangler.URLType)URLMangler.URLType.SERVICE);
                linkType = "collection";
                String linkTitle = "The collection description as " + format;
                this.writeLink(jw, linkTitle, format.toString(), linkType, href);
            }
        }
        jw.endArray();
    }

    private String getParentCollectionId() {
        return Optional.ofNullable(RequestContextHolder.getRequestAttributes()).map(a -> a.getAttribute(ImagesService.COLLECTION_ID, 0)).map(String::valueOf).orElse(null);
    }

    protected void writeCollectionCRS(GeoJSONBuilder jsonWriter, CoordinateReferenceSystem crs) throws IOException {
        if (!CRS.equalsIgnoreMetadata((Object)DefaultGeographicCRS.WGS84, (Object)crs)) {
            super.writeCollectionCRS(jsonWriter, crs);
        }
    }

    protected void writeCollectionCounts(BigInteger featureCount, long numberReturned, GeoJSONBuilder jsonWriter) {
        if (featureCount != null) {
            jsonWriter.key("numberMatched").value((Object)featureCount);
        }
        jsonWriter.key("numberReturned").value(numberReturned);
    }

    protected void writeCollectionBounds(boolean featureBounding, GeoJSONBuilder jsonWriter, List<FeatureCollection> resultsList, boolean hasGeom) {
    }

    public String getCapabilitiesElementName() {
        return null;
    }

    public boolean canHandle(Operation operation) {
        if ("GetImages".equalsIgnoreCase(operation.getId()) || "GetImage".equalsIgnoreCase(operation.getId())) {
            return this.canHandleInternal(operation);
        }
        return false;
    }
}

