/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.images;

import java.net.URLConnection;
import org.apache.commons.io.FilenameUtils;

class MimeTypeSupport {
    MimeTypeSupport() {
    }

    public static String guessMimeType(String fileName) {
        String extension = FilenameUtils.getExtension((String)fileName).toLowerCase();
        if (extension.equals("tif") || extension.equals(".tiff")) {
            return "image/tiff";
        }
        if (extension.equals("jp2")) {
            return "image/jp2";
        }
        if (extension.equals("nc")) {
            return "application/x-netcdf";
        }
        String mimeType = URLConnection.guessContentTypeFromName(fileName);
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        return mimeType;
    }

    public static String guessFileExtension(String mimeType) {
        if (mimeType != null) {
            if (mimeType.startsWith("image")) {
                if (mimeType.endsWith("tiff")) {
                    return "tif";
                }
                int idx = Math.max(mimeType.lastIndexOf("/"), mimeType.lastIndexOf("+"));
                if (idx > 0 && idx < mimeType.length() - 1) {
                    return mimeType.substring(idx + 1);
                }
            } else if (mimeType.contains("netcdf")) {
                return "nc";
            }
        }
        return "bin";
    }
}

