/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.images;

import io.swagger.v3.oas.models.OpenAPI;
import java.awt.RenderingHints;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.opengis.wfs20.Wfs20Factory;
import org.apache.commons.io.IOUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.data.DimensionFilterBuilder;
import org.geoserver.ogcapi.APIException;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.APIService;
import org.geoserver.ogcapi.ConformanceDocument;
import org.geoserver.ogcapi.HTMLResponseBody;
import org.geoserver.ogcapi.ResourceNotFoundException;
import org.geoserver.ogcapi.v1.images.AssetHasher;
import org.geoserver.ogcapi.v1.images.ImageListener;
import org.geoserver.ogcapi.v1.images.ImageListenerSupport;
import org.geoserver.ogcapi.v1.images.ImagesAPIBuilder;
import org.geoserver.ogcapi.v1.images.ImagesBBoxKvpParser;
import org.geoserver.ogcapi.v1.images.ImagesCollectionDocument;
import org.geoserver.ogcapi.v1.images.ImagesCollectionsDocument;
import org.geoserver.ogcapi.v1.images.ImagesLandingPage;
import org.geoserver.ogcapi.v1.images.ImagesResponse;
import org.geoserver.ogcapi.v1.images.ImagesServiceInfo;
import org.geoserver.ogcapi.v1.images.MimeTypeSupport;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.kvp.TimeParser;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.rest.util.RESTUtils;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geotools.api.data.FileGroupProvider;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.grid.io.DimensionDescriptor;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.coverage.grid.io.GranuleStore;
import org.geotools.coverage.grid.io.HarvestedSource;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.transform.Definition;
import org.geotools.data.transform.TransformFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@APIService(service="Images", version="1.0.1", landingPage="ogc/images/v1", serviceClass=ImagesServiceInfo.class)
@RequestMapping(path={"ogc/images/v1"})
public class ImagesService
implements ApplicationContextAware {
    static final Logger LOGGER = Logging.getLogger(ImagesService.class);
    static final String IMAGES_CORE = "http://www.opengis.net/spec/ogcapi-images-1/1.0/req/core";
    static final String IMAGES_TRANSACTIONAL = "http://www.opengis.net/spec/ogcapi-images-1/1.0/req/transactional";
    public static String IMAGE_ID = "OGCImages:ImageId";
    public static String COLLECTION_ID = "OGCImages:CollectionId";
    private static final String DISPLAY_NAME = "OGC API Images";
    private final GeoServer geoServer;
    private final AssetHasher assetHasher;
    private final ImagesBBoxKvpParser bboxParser = new ImagesBBoxKvpParser();
    private final TimeParser timeParser = new TimeParser();
    private ImageListenerSupport imageListeners;

    public ImagesService(GeoServer geoServer, AssetHasher assetHasher) {
        this.geoServer = geoServer;
        this.assetHasher = assetHasher;
    }

    @GetMapping(name="getLandingPage")
    @ResponseBody
    @HTMLResponseBody(templateName="landingPage.ftl", fileName="landingPage.html")
    public ImagesLandingPage getLandingPage() {
        ImagesServiceInfo service = this.getService();
        return new ImagesLandingPage(service.getTitle() == null ? "Images server" : service.getTitle(), service.getAbstract() == null ? "" : service.getAbstract());
    }

    public ImagesServiceInfo getService() {
        return (ImagesServiceInfo)this.geoServer.getService(ImagesServiceInfo.class);
    }

    public ImagesServiceInfo getServiceInfo() {
        return this.getService();
    }

    @GetMapping(path={"conformance"}, name="getConformanceDeclaration")
    @ResponseBody
    @HTMLResponseBody(templateName="conformance.ftl", fileName="conformance.html")
    public ConformanceDocument conformance() {
        List<String> classes = Arrays.asList("http://www.opengis.net/spec/ogcapi-common-1/1.0/conf/core", "http://www.opengis.net/spec/ogcapi-common-2/1.0/conf/collections", IMAGES_CORE, IMAGES_TRANSACTIONAL);
        return new ConformanceDocument(DISPLAY_NAME, classes);
    }

    @GetMapping(path={"openapi", "openapi.json", "openapi.yaml"}, name="getApi", produces={"application/vnd.oai.openapi+json;version=3.0", "application/yaml", "text/xml"})
    @ResponseBody
    @HTMLResponseBody(templateName="api.ftl", fileName="api.html")
    public OpenAPI api() throws IOException {
        return new ImagesAPIBuilder(this.geoServer).build(this.getService());
    }

    @GetMapping(path={"collections"}, name="getCollections")
    @ResponseBody
    @HTMLResponseBody(templateName="collections.ftl", fileName="collections.html")
    public ImagesCollectionsDocument getCollections() {
        return new ImagesCollectionsDocument(this.geoServer);
    }

    @GetMapping(path={"collections/{collectionId}"}, name="describeCollection")
    @ResponseBody
    @HTMLResponseBody(templateName="collection.ftl", fileName="collection.html")
    public ImagesCollectionDocument collection(@PathVariable(name="collectionId") String collectionId) throws FactoryException, TransformException, IOException {
        CoverageInfo coverage = this.getStructuredCoverageInfo(collectionId);
        ImagesCollectionDocument collection = new ImagesCollectionDocument(coverage, false);
        return collection;
    }

    private CoverageInfo getStructuredCoverageInfo(String collectionId) throws IOException {
        CoverageInfo coverageInfo = this.geoServer.getCatalog().getCoverageByName(collectionId);
        if (coverageInfo != null && coverageInfo.getGridCoverageReader(null, null) instanceof StructuredGridCoverage2DReader) {
            return coverageInfo;
        }
        throw new ResourceNotFoundException("Could not locate " + collectionId);
    }

    @GetMapping(path={"collections/{collectionId}/images"}, name="getImages")
    @ResponseBody
    @HTMLResponseBody(templateName="images.ftl", fileName="images.html")
    public ImagesResponse images(@PathVariable(name="collectionId") String collectionId, @RequestParam(name="startIndex", required=false, defaultValue="0") int startIndex, @RequestParam(name="limit", required=false) Integer limit, @RequestParam(name="bbox", required=false) String bbox, @RequestParam(name="time", required=false) String time, String imageId) throws Exception {
        CoverageInfo coverage = this.getStructuredCoverageInfo(collectionId);
        StructuredGridCoverage2DReader reader = (StructuredGridCoverage2DReader)coverage.getGridCoverageReader(null, null);
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (bbox != null) {
            filters.add(this.buildBBOXFilter(bbox));
        }
        String nativeName = coverage.getNativeCoverageName();
        if (time != null) {
            List descriptors = reader.getDimensionDescriptors(nativeName);
            Optional<DimensionDescriptor> timeDescriptor = descriptors.stream().filter(dd -> "time".equalsIgnoreCase(dd.getName())).findFirst();
            if (!timeDescriptor.isPresent()) {
                throw new APIException("InvalidParameter", "Time not supported for this image collection", HttpStatus.BAD_REQUEST);
            }
            filters.add(this.buildTimeFilter(timeDescriptor.get(), time));
        }
        if (imageId != null) {
            filters.add((Filter)Utils.FF.id(new FeatureId[]{Utils.FF.featureId(imageId)}));
        }
        Filter filter = this.mergeFiltersAnd(filters);
        GranuleSource granuleSource = reader.getGranules(nativeName, true);
        Query gtQuery = new Query(nativeName, filter);
        gtQuery.setStartIndex(Integer.valueOf(startIndex));
        if (limit == null) {
            limit = this.getService().getMaxImages();
        }
        int maxFeatures = limit;
        gtQuery.setMaxFeatures(maxFeatures);
        gtQuery.setHints(new Hints((RenderingHints.Key)GranuleSource.FILE_VIEW, (Object)true));
        SimpleFeatureCollection granules = granuleSource.getGranules(gtQuery);
        if (imageId != null && granules.isEmpty()) {
            throw new ResourceNotFoundException("Image with id " + imageId + " could not be found in collection " + collectionId);
        }
        SimpleFeatureCollection remapped = this.remapGranules(granules, reader.getDimensionDescriptors(nativeName));
        return this.wrapInImageResponse(coverage, filter, startIndex, limit, bbox, time, imageId, remapped);
    }

    @GetMapping(path={"collections/{collectionId}/images/{imageId:.+}"}, name="getImage")
    @ResponseBody
    @HTMLResponseBody(templateName="image.ftl", fileName="image.html")
    public ImagesResponse image(@PathVariable(name="collectionId") String collectionId, @PathVariable(name="imageId") String imageId) throws Exception {
        return this.images(collectionId, 0, null, null, null, imageId);
    }

    @GetMapping(path={"collections/{collectionId}/images/{imageId:.+}/assets/{assetId:.+}"}, name="getAsset")
    public void asset(@PathVariable(name="collectionId") String collectionId, @PathVariable(name="imageId") String imageId, @PathVariable(name="assetId") String assetId, HttpServletResponse response) throws Exception {
        SimpleFeature granule = this.getFeatureForImageId(collectionId, imageId);
        Object fileGroupCandidate = granule.getUserData().get("GranuleFiles");
        if (!(fileGroupCandidate instanceof FileGroupProvider.FileGroup)) {
            throw new ResourceNotFoundException("Could not find assets for image " + imageId + " in collection " + collectionId);
        }
        FileGroupProvider.FileGroup files = (FileGroupProvider.FileGroup)fileGroupCandidate;
        Optional<Object> asset = Optional.empty();
        asset = this.assetHasher.matches(files.getMainFile(), assetId) ? Optional.of(files.getMainFile()) : files.getSupportFiles().stream().filter(f -> this.assetHasher.matches((File)f, assetId)).findFirst();
        if (!asset.isPresent()) {
            throw new APIException("NotFound", "Cannot find asset with id " + assetId + " in image  " + imageId + " in collection " + collectionId, HttpStatus.NOT_FOUND);
        }
        response.setHeader("Content-Type", MimeTypeSupport.guessMimeType(((File)asset.get()).getName()));
        response.setStatus(HttpStatus.OK.value());
        try (FileInputStream fis = new FileInputStream((File)asset.get());){
            IOUtils.copy((InputStream)fis, (OutputStream)response.getOutputStream());
        }
    }

    private SimpleFeature getFeatureForImageId(@PathVariable(name="collectionId") String collectionId, @PathVariable(name="imageId") String imageId) throws Exception {
        ImagesResponse ir = this.images(collectionId, 0, null, null, null, imageId);
        SimpleFeatureCollection granules = (SimpleFeatureCollection)ir.getResponse().getFeatures().get(0);
        return (SimpleFeature)DataUtilities.first((FeatureCollection)granules);
    }

    private SimpleFeatureCollection remapGranules(SimpleFeatureCollection granules, List<DimensionDescriptor> dimensionDescriptors) throws IOException {
        Optional<DimensionDescriptor> maybeDescriptor = dimensionDescriptors.stream().filter(dd -> "time".equalsIgnoreCase(dd.getName())).findFirst();
        if (maybeDescriptor.isPresent() && "datetime".equals(maybeDescriptor.get().getStartAttribute())) {
            return granules;
        }
        List definitions = ((SimpleFeatureType)granules.getSchema()).getAttributeDescriptors().stream().map(d -> {
            String outputName = d.getLocalName();
            if (maybeDescriptor.isPresent() && ((DimensionDescriptor)maybeDescriptor.get()).getStartAttribute().equals(d.getLocalName())) {
                outputName = "datetime";
            }
            return new Definition(outputName, (Expression)Utils.FF.property(d.getLocalName()), d.getType().getBinding());
        }).collect(Collectors.toList());
        if (!maybeDescriptor.isPresent()) {
            definitions.add(new Definition("datetime", (Expression)Utils.FF.literal((Object)new Timestamp(0L))));
        }
        SimpleFeatureSource granulesSource = DataUtilities.source((FeatureCollection)granules);
        TransformFeatureSource remappedSource = new TransformFeatureSource(granulesSource, ((SimpleFeatureType)granules.getSchema()).getName(), definitions);
        return remappedSource.getFeatures(Query.ALL);
    }

    public ImagesResponse wrapInImageResponse(CoverageInfo coverage, Filter filter, int startIndex, int maxFeatures, String bbox, String time, String imageId, SimpleFeatureCollection granules) {
        GetFeatureRequest request = GetFeatureRequest.adapt((Object)Wfs20Factory.eINSTANCE.createGetFeatureType());
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            requestAttributes.setAttribute(IMAGE_ID, (Object)imageId, 0);
            requestAttributes.setAttribute(COLLECTION_ID, (Object)coverage.prefixedName(), 0);
        }
        FeatureCollectionResponse result = request.createResponse();
        int count = granules.size();
        result.setNumberOfFeatures(BigInteger.valueOf(count));
        result.setTimeStamp(Calendar.getInstance());
        result.getFeature().add(granules);
        result.setGetFeatureById(imageId != null);
        String imagesPath = "ogc/images/v1/collections/" + ResponseUtils.urlEncode((String)coverage.prefixedName(), (char[])new char[0]) + "/images";
        Map<String, String> kvp = APIRequestInfo.get().getRequest().getParameterMap().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue() != null ? ((String[])e.getValue())[0] : null));
        kvp.remove("startIndex");
        kvp.remove("limit");
        if (startIndex > 0) {
            int prevOffset = Math.max(startIndex - maxFeatures, 0);
            kvp.put("startIndex", String.valueOf(prevOffset));
            kvp.put("limit", String.valueOf(startIndex - prevOffset));
            result.setPrevious(this.buildURL(imagesPath, kvp));
        }
        if (count > 0 && maxFeatures > -1 && maxFeatures <= count) {
            kvp.put("startIndex", String.valueOf(maxFeatures > 0 ? maxFeatures + count : count));
            kvp.put("limit", String.valueOf(maxFeatures));
            result.setNext(this.buildURL(imagesPath, kvp));
        }
        return new ImagesResponse(request.getAdaptee(), result);
    }

    private String buildURL(String itemsPath, Map<String, String> kvp) {
        return ResponseUtils.buildURL((String)APIRequestInfo.get().getBaseURL(), (String)itemsPath, kvp, (URLMangler.URLType)URLMangler.URLType.SERVICE);
    }

    private Filter buildTimeFilter(DimensionDescriptor descriptor, String time) throws ParseException {
        ArrayList times = new ArrayList(this.timeParser.parse(time));
        if (times.isEmpty() || times.size() > 1) {
            throw new ServiceException("Invalid time specification, must be a single time, or a time range", "InvalidParameterValue", "time");
        }
        DimensionFilterBuilder filterBuilder = new DimensionFilterBuilder(Utils.FF);
        filterBuilder.appendFilters(descriptor.getStartAttribute(), descriptor.getEndAttribute(), times);
        return filterBuilder.getFilter();
    }

    private Filter mergeFiltersAnd(List<Filter> filters) {
        if (filters.isEmpty()) {
            return Filter.INCLUDE;
        }
        if (filters.size() == 1) {
            return filters.get(0);
        }
        return Utils.FF.and(filters);
    }

    public Filter buildBBOXFilter(@RequestParam(name="bbox", required=false) String bbox) throws Exception {
        Object parsed = this.bboxParser.parse(bbox);
        if (parsed instanceof ReferencedEnvelope) {
            return Utils.FF.bbox((Expression)Utils.FF.property(""), (BoundingBox)((ReferencedEnvelope)parsed));
        }
        if (parsed instanceof ReferencedEnvelope[]) {
            List filters = Stream.of((ReferencedEnvelope[])parsed).map(e -> Utils.FF.bbox((Expression)Utils.FF.property(""), (BoundingBox)e)).collect(Collectors.toList());
            return Utils.FF.or(filters);
        }
        throw new IllegalArgumentException("Could not understand parsed bbox " + parsed);
    }

    @PostMapping(path={"collections/{collectionId}/images"}, name="addImage")
    @ResponseBody
    public ResponseEntity addImage(@PathVariable(name="collectionId") String collectionId, @RequestParam(name="filename", required=false) String filename, HttpServletRequest request) throws Exception {
        CoverageInfo coverageInfo = this.getStructuredCoverageInfo(collectionId);
        CoverageStoreInfo store = coverageInfo.getStore();
        String workspace = store.getWorkspace().getName();
        String storeName = store.getName();
        if (filename == null) {
            filename = UUID.randomUUID().toString() + "." + MimeTypeSupport.guessFileExtension(request.getContentType());
        }
        Resource uploadRoot = RESTUtils.createUploadRoot((Catalog)this.geoServer.getCatalog(), (String)workspace, (String)storeName, (boolean)true);
        Resource uploadedResource = RESTUtils.handleBinUpload((String)filename, (Resource)uploadRoot, (boolean)false, (HttpServletRequest)request, (String)workspace);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (this.isZipFile(request)) {
            RESTUtils.unzipFile((Resource)uploadedResource, (Resource)uploadRoot, (String)workspace, (String)storeName, resources, (boolean)false);
            uploadedResource.delete();
        } else {
            resources.add(uploadedResource);
        }
        List uploadedFiles = resources.stream().map(r -> Resources.find((Resource)r)).collect(Collectors.toList());
        StructuredGridCoverage2DReader sr = (StructuredGridCoverage2DReader)coverageInfo.getGridCoverageReader(null, null);
        List harvested = sr.harvest(null, uploadedFiles, GeoTools.getDefaultHints());
        if (harvested == null || harvested.isEmpty() || !((HarvestedSource)harvested.get(0)).success()) {
            throw new APIException("NoApplicableCode", "Resources could not be harvested (is the image posted in a format that GeoServer can understand?)", HttpStatus.INTERNAL_SERVER_ERROR);
        }
        HttpHeaders headers = new HttpHeaders();
        String featureId = this.getFeatureIdFor((HarvestedSource)harvested.get(0), sr.getGranules(coverageInfo.getNativeCoverageName(), true));
        if (featureId != null) {
            String href = ResponseUtils.buildURL((String)APIRequestInfo.get().getBaseURL(), (String)("ogc/images/v1/collections/" + ResponseUtils.urlEncode((String)collectionId, (char[])new char[0]) + "/images/" + ResponseUtils.urlEncode((String)featureId, (char[])new char[0])), null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
            headers.add("Location", href);
        }
        this.imageListeners.imageAdded(coverageInfo, sr.getGranules(coverageInfo.getNativeCoverageName(), true), featureId);
        return new ResponseEntity((Object)"", (MultiValueMap)headers, HttpStatus.CREATED);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getFeatureIdFor(HarvestedSource harvestedSource, GranuleSource source) {
        try {
            if (!(harvestedSource.getSource() instanceof File)) {
                return null;
            }
            File reference = ((File)harvestedSource.getSource()).getCanonicalFile();
            IncludeFilter filter = Filter.INCLUDE;
            if (source.getSchema().getDescriptor("location") != null) {
                filter = Utils.FF.like((Expression)Utils.FF.property("location"), "*" + reference.getName());
            }
            Query q = new Query();
            q.setFilter((Filter)filter);
            q.setHints(new Hints((RenderingHints.Key)GranuleSource.FILE_VIEW, (Object)true));
            SimpleFeatureCollection granules = source.getGranules(q);
            try (SimpleFeatureIterator it = granules.features();){
                SimpleFeature f;
                FileGroupProvider.FileGroup files;
                do {
                    if (!it.hasNext()) return null;
                } while (!(files = (FileGroupProvider.FileGroup)(f = (SimpleFeature)it.next()).getUserData().get("GranuleFiles")).getMainFile().getCanonicalFile().equals(reference));
                String string = f.getID();
                return string;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to locate harvested source", e);
        }
        return null;
    }

    private boolean isZipFile(HttpServletRequest request) {
        return request.getContentType().startsWith("application/vnd.ogc.multipart;container=application/x-zip-compressed") || RESTUtils.isZipMediaType((HttpServletRequest)request);
    }

    @PutMapping(path={"collections/{collectionId}/images/{imageId:.+}"}, name="updateImage")
    public void putImage(@PathVariable(name="collectionId") String collectionId, @PathVariable(name="imageId") String imageId) throws Exception {
        throw new APIException("NotImplemented", "PUT on single images is not supported yet", HttpStatus.NOT_IMPLEMENTED);
    }

    @DeleteMapping(path={"collections/{collectionId}/images/{imageId:.+}"}, name="deleteImage")
    @ResponseBody
    public ResponseEntity deleteImage(@PathVariable(name="collectionId") String collectionId, @PathVariable(name="imageId") String imageId) throws Exception {
        CoverageInfo info = this.getStructuredCoverageInfo(collectionId);
        StructuredGridCoverage2DReader reader = (StructuredGridCoverage2DReader)info.getGridCoverageReader(null, null);
        GranuleSource source = reader.getGranules(info.getNativeCoverageName(), false);
        if (!(source instanceof GranuleStore)) {
            throw new APIException("NotImplemented", "Write not supported on this reader", HttpStatus.NOT_IMPLEMENTED);
        }
        SimpleFeature feature = this.getFeatureForImageId(collectionId, imageId);
        ((GranuleStore)source).removeGranules((Filter)Utils.FF.id(new FeatureId[]{Utils.FF.featureId(imageId)}));
        this.imageListeners.imageRemoved(info, feature);
        return new ResponseEntity(HttpStatus.OK);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.imageListeners = new ImageListenerSupport(GeoServerExtensions.extensions(ImageListener.class));
    }
}

