/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.images;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.ogcapi.APIException;
import org.geoserver.ogcapi.AbstractDocument;
import org.geoserver.ogcapi.v1.images.ImagesCollectionDocument;
import org.geotools.api.filter.Filter;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.util.logging.Logging;
import org.springframework.http.HttpStatus;

@JsonPropertyOrder(value={"links", "collections"})
public class ImagesCollectionsDocument
extends AbstractDocument {
    static final Logger LOGGER = Logging.getLogger(ImagesCollectionsDocument.class);
    private final GeoServer gs;

    public ImagesCollectionsDocument(GeoServer gs) {
        this.gs = gs;
        this.addSelfLinks("ogc/images/v1/collections/");
    }

    public Iterator<ImagesCollectionDocument> getCollections() {
        final CloseableIterator coverages = this.gs.getCatalog().list(CoverageInfo.class, (Filter)Filter.INCLUDE);
        final boolean skipInvalid = this.gs.getGlobal().getResourceErrorHandling() == ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS;
        return new Iterator<ImagesCollectionDocument>(){
            ImagesCollectionDocument next;

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                while (coverages.hasNext()) {
                    CoverageInfo coverage = (CoverageInfo)coverages.next();
                    try {
                        ImagesCollectionDocument collection;
                        if (!(coverage.getGridCoverageReader(null, null) instanceof StructuredGridCoverage2DReader)) continue;
                        this.next = collection = new ImagesCollectionDocument(coverage, true);
                        return true;
                    }
                    catch (Exception e) {
                        if (skipInvalid) {
                            LOGGER.log(Level.WARNING, "Skipping coverage  " + coverage);
                            continue;
                        }
                        throw new APIException("InternalError", "Failed to iterate over the coverages in the catalog", HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
                    }
                }
                return this.next != null;
            }

            @Override
            public ImagesCollectionDocument next() {
                ImagesCollectionDocument result = this.next;
                this.next = null;
                return result;
            }
        };
    }
}

