/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.images;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.AbstractCollectionDocument;
import org.geoserver.ogcapi.CollectionExtents;
import org.geoserver.ogcapi.Link;
import org.geoserver.ogcapi.v1.images.ImagesResponse;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.util.logging.Logging;
import org.springframework.http.MediaType;

@JsonPropertyOrder(value={"id", "title", "description", "extent", "links"})
public class ImagesCollectionDocument
extends AbstractCollectionDocument<CoverageInfo> {
    static final Logger LOGGER = Logging.getLogger(ImagesCollectionDocument.class);
    StructuredGridCoverage2DReader reader;

    public ImagesCollectionDocument(CoverageInfo coverage, boolean summary) throws FactoryException, TransformException, IOException {
        super((Object)coverage);
        this.id = coverage.prefixedName();
        this.title = coverage.getTitle();
        this.description = coverage.getAbstract();
        String baseURL = APIRequestInfo.get().getBaseURL();
        this.extent = new CollectionExtents(coverage.getLatLonBoundingBox());
        this.addSelfLinks("ogc/images/v1/collections/" + this.id);
        Collection imagesFormats = APIRequestInfo.get().getProducibleMediaTypes(ImagesResponse.class, true);
        for (MediaType format : imagesFormats) {
            String metadataURL = ResponseUtils.buildURL((String)baseURL, (String)("ogc/images/v1/collections/" + ResponseUtils.urlEncode((String)this.id, (char[])new char[0]) + "/images"), Collections.singletonMap("f", format.toString()), (URLMangler.URLType)URLMangler.URLType.SERVICE);
            Link link = new Link(metadataURL, "images", format.toString(), "The images metadata as " + format);
            this.addLink(link);
        }
    }
}

