/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.images;

import org.geoserver.wfs.kvp.BBoxKvpParser;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;

class ImagesBBoxKvpParser
extends BBoxKvpParser {
    ImagesBBoxKvpParser() {
    }

    protected Object buildEnvelope(int countco, double minx, double miny, double minz, double maxx, double maxy, double maxz, String srs) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem crs;
        if (countco > 4) {
            throw new IllegalArgumentException("Too many coordinates, openSearch cannot handle non flat envelopes yet");
        }
        CoordinateReferenceSystem coordinateReferenceSystem = crs = srs == null ? null : CRS.decode((String)srs, (boolean)true);
        if (crs == null) {
            crs = DefaultGeographicCRS.WGS84;
        }
        if ((minx = ImagesBBoxKvpParser.rollLongitude(minx)) > (maxx = ImagesBBoxKvpParser.rollLongitude(maxx))) {
            return new ReferencedEnvelope[]{new ReferencedEnvelope(minx, 180.0, miny, maxy, crs), new ReferencedEnvelope(-180.0, maxx, miny, maxy, crs)};
        }
        return new ReferencedEnvelope(minx, maxx, miny, maxy, crs);
    }

    protected static double rollLongitude(double x) {
        double mod = (x + 180.0) % 360.0;
        if (mod == 0.0) {
            return x > 0.0 ? 180.0 : -180.0;
        }
        return mod - 180.0;
    }
}

