/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.images;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.geoserver.ogcapi.MessageConverterResponseAdapter;
import org.geoserver.ogcapi.v1.images.ImagesResponse;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.platform.Operation;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geotools.util.Version;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;

@Component
public class ImageResponseMessageConverter
extends MessageConverterResponseAdapter<ImagesResponse> {
    private static final Version V2 = new Version("2.0");

    public ImageResponseMessageConverter() {
        super(ImagesResponse.class, FeatureCollectionResponse.class);
    }

    public List<MediaType> getSupportedMediaTypes() {
        return Arrays.asList(MediaType.parseMediaType((String)"application/stac+json"));
    }

    protected void writeResponse(ImagesResponse value, HttpOutputMessage httpOutputMessage, Operation operation, Response response) throws IOException {
        response.write((Object)value.getResponse(), httpOutputMessage.getBody(), operation);
    }

    protected Operation getOperation(ImagesResponse result, Request dr, MediaType mediaType) {
        return new Operation(dr.getOperation().getId(), dr.getOperation().getService(), dr.getOperation().getMethod(), new Object[]{result.getRequest()});
    }

    protected Predicate<Response> getResponseFilterPredicate() {
        return r -> r instanceof WFSGetFeatureOutputFormat && ((WFSGetFeatureOutputFormat)r).canHandle(V2);
    }
}

