/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.images;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.JsonContext;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ogcapi.v1.images.ImagesService;
import org.geoserver.ogcapi.v1.images.ImagesServiceInfo;
import org.geoserver.ogcapi.v1.images.ImagesTestSupport;
import org.geoserver.platform.Service;
import org.geotools.util.Version;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class LandingPageTest
extends ImagesTestSupport {
    @Test
    public void testServiceDescriptor() {
        Service service = this.getService("Images", new Version("1.0.1"));
        Assert.assertNotNull((Object)service);
        Assert.assertEquals((Object)"Images", (Object)service.getId());
        Assert.assertEquals((Object)new Version("1.0.1"), (Object)service.getVersion());
        MatcherAssert.assertThat((Object)service.getService(), (Matcher)CoreMatchers.instanceOf(ImagesService.class));
        MatcherAssert.assertThat((Object)service.getOperations(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"getApi", "describeCollection", "getCollections", "getLandingPage", "getConformanceDeclaration", "getImages", "getImage", "getAsset", "addImage", "deleteImage", "updateImage"}));
    }

    @Test
    public void testLandingPageNoSlash() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/images/v1", 200);
        this.checkJSONLandingPage(json);
    }

    @Test
    public void testLandingPageSlash() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/images/v1", 200);
        this.checkJSONLandingPage(json);
    }

    @Test
    public void testLandingPageJSON() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/images/v1?f=json", 200);
        this.checkJSONLandingPage(json);
    }

    @Test
    public void testLandingPageWorkspaceSpecific() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/images/v1", 200);
        this.checkJSONLandingPage(json);
    }

    @Test
    public void testLandingPageYaml() throws Exception {
        String yaml = this.getAsString("ogc/images/v1?f=application/yaml");
        JsonContext json = this.convertYamlToJsonPath(yaml);
        this.assertJSONList((DocumentContext)json, "links[?(@.type == 'application/yaml' && @.href =~ /.*ogc\\/images\\/v1\\/\\?.*/)].rel", new String[]{"self"});
        this.assertJSONList((DocumentContext)json, "links[?(@.type != 'application/yaml' && @.href =~ /.*ogc\\/images\\/v1\\/\\?.*/)].rel", new String[]{"alternate", "alternate"});
        this.checkJSONLandingPageShared((DocumentContext)json);
    }

    @Test
    public void testLandingPageHTML() throws Exception {
        Document document = this.getAsJSoup("ogc/images/v1?f=html");
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/images/v1/collections?f=text%2Fhtml", (Object)document.select("#htmlCollectionsLink").attr("href"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/images/v1/openapi?f=text%2Fhtml", (Object)document.select("#htmlApiLink").attr("href"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/images/v1/conformance?f=text%2Fhtml", (Object)document.select("#htmlConformanceLink").attr("href"));
    }

    @Test
    public void testLandingPageInWrkspace() throws Exception {
        DocumentContext json = this.getAsJSONPath("gs/ogc/images/v1?f=json", 200);
        MatcherAssert.assertThat((Object)((String)this.readSingle(json, "links[?(@.rel=='http://www.opengis.net/def/rel/ogc/1.0/data' && @.type=='application/json')].href")), (Matcher)CoreMatchers.equalTo((Object)"http://localhost:8080/geoserver/gs/ogc/images/v1/collections?f=application%2Fjson"));
    }

    void checkJSONLandingPage(DocumentContext json) {
        Assert.assertEquals((long)12L, (long)((Integer)json.read("links.length()", Integer.class, new Predicate[0])).intValue());
        this.assertJSONList(json, "links[?(@.type == 'application/json' && @.href =~ /.*ogc\\/images\\/v1\\/\\?.*/)].rel", new String[]{"self"});
        this.assertJSONList(json, "links[?(@.type != 'application/json' && @.href =~ /.*ogc\\/images\\/v1\\/\\?.*/)].rel", new String[]{"alternate", "alternate"});
        this.checkJSONLandingPageShared(json);
    }

    void checkJSONLandingPageShared(DocumentContext json) {
        this.assertJSONList(json, "links[?(@.href =~ /.*ogc\\/images\\/v1\\/openapi.*/)].rel", new String[]{"service-desc", "service-desc", "service-doc"});
        this.assertJSONList(json, "links[?(@.href =~ /.*ogc\\/images\\/v1\\/conformance.*/)].rel", new String[]{"http://www.opengis.net/def/rel/ogc/1.0/conformance", "http://www.opengis.net/def/rel/ogc/1.0/conformance", "http://www.opengis.net/def/rel/ogc/1.0/conformance"});
        this.assertJSONList(json, "links[?(@.href =~ /.*ogc\\/images\\/v1\\/collections.*/)].rel", new String[]{"http://www.opengis.net/def/rel/ogc/1.0/data", "http://www.opengis.net/def/rel/ogc/1.0/data", "http://www.opengis.net/def/rel/ogc/1.0/data"});
        Assert.assertEquals((Object)"Testbed Experiments", (Object)json.read("title", new Predicate[0]));
        Assert.assertTrue((boolean)((String)json.read("description", new Predicate[0])).contains("OGCAPI Testbed"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisabledService() throws Exception {
        GeoServer gs = this.getGeoServer();
        ImagesServiceInfo service = (ImagesServiceInfo)gs.getService(ImagesServiceInfo.class);
        service.setEnabled(false);
        gs.save((ServiceInfo)service);
        try {
            MockHttpServletResponse httpServletResponse = this.getAsMockHttpServletResponse("ogc/images/v1", 404);
            Assert.assertEquals((Object)"Service Images is disabled", (Object)httpServletResponse.getErrorMessage());
        }
        finally {
            service.setEnabled(true);
            gs.save((ServiceInfo)service);
        }
    }
}

