/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.images;

import com.google.common.collect.Streams;
import java.io.IOException;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ogcapi.OGCApiTestSupport;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;

public class ImagesTestSupport
extends OGCApiTestSupport {
    protected static QName WATER_TEMP = new QName(MockData.SF_URI, "watertemp", MockData.SF_PREFIX);
    protected static QName WATER_TEMP_DEFAULT = new QName(MockData.DEFAULT_URI, "watertemp", MockData.DEFAULT_PREFIX);
    public static final String WATER_TEMP_TITLE = "Water temperature";
    public static final String WATER_TEMP_DESCRIPTION = "I love my water warm and cosy!";

    protected void setUpTestData(SystemTestData testData) throws Exception {
        testData.setUpDefaultRasterLayers();
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        Catalog catalog = this.getCatalog();
        testData.addRasterLayer(WATER_TEMP, "watertemp.zip", null, null, SystemTestData.class, catalog);
        testData.addRasterLayer(WATER_TEMP_DEFAULT, "watertemp.zip", null, null, SystemTestData.class, catalog);
        CoverageInfo waterTemp = this.getCatalog().getCoverageByName(this.getLayerId(WATER_TEMP));
        waterTemp.setTitle(WATER_TEMP_TITLE);
        waterTemp.setAbstract(WATER_TEMP_DESCRIPTION);
        this.getCatalog().save((ResourceInfo)waterTemp);
    }

    protected Stream<CoverageInfo> getStructuredCoverages() {
        return Streams.stream(this.getCatalog().getCoverages().iterator()).filter(c -> {
            try {
                return c.getGridCoverageReader(null, null) instanceof StructuredGridCoverage2DReader;
            }
            catch (IOException e) {
                return false;
            }
        });
    }
}

