/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.images;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.geoserver.ogcapi.v1.images.ImagesTestSupport;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.resource.Resource;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class ImageTest
extends ImagesTestSupport {
    @Test
    public void testWaterTempImages() throws Exception {
        String waterTemp = this.getLayerId(WATER_TEMP);
        DocumentContext json = this.getAsJSONPath("ogc/images/v1/collections/" + waterTemp + "/images?f=" + ResponseUtils.urlEncode((String)"application/stac+json", (char[])new char[0]), 200);
        String featureId = (String)this.readSingle(json, "features[?(@.properties.datetime == '2008-11-01T00:00:00Z' && @.properties.elevation == 100)].id");
        MatcherAssert.assertThat((Object)featureId, (Matcher)Matchers.startsWith((String)"watertemp."));
        String basePath = "features[?(@.id == '" + featureId + "')]";
        this.checkWaterTemp(json, basePath, featureId);
        MatcherAssert.assertThat((Object)((Iterable)json.read("links[?(@.rel=='item')].href", new Predicate[0])), (Matcher)Matchers.hasItems((Object[])new String[]{"http://localhost:8080/geoserver/ogc/images/v1/collections/sf%3Awatertemp/images/watertemp.1?f=application%2Fstac%2Bjson", "http://localhost:8080/geoserver/ogc/images/v1/collections/sf%3Awatertemp/images/watertemp.2?f=application%2Fstac%2Bjson", "http://localhost:8080/geoserver/ogc/images/v1/collections/sf%3Awatertemp/images/watertemp.3?f=application%2Fstac%2Bjson", "http://localhost:8080/geoserver/ogc/images/v1/collections/sf%3Awatertemp/images/watertemp.4?f=application%2Fstac%2Bjson"}));
    }

    public void checkWaterTemp(DocumentContext json, String basePath, String featureId) {
        MatcherAssert.assertThat((Object)((Integer)this.readSingle(json, basePath + ".properties.size()")), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)((String)this.readSingle(json, basePath + ".stac_version")), (Matcher)Matchers.equalTo((Object)"0.8.0"));
        MatcherAssert.assertThat((Object)((String)this.readSingle(json, basePath + ".collection")), (Matcher)Matchers.equalTo((Object)"sf:watertemp"));
        MatcherAssert.assertThat((Object)((Iterable)this.readSingle(json, basePath + ".bbox")), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.closeTo((double)0.23722069, (double)1.0E-6), Matchers.closeTo((double)40.56208, (double)1.0E-6), Matchers.closeTo((double)14.592757, (double)1.0E-6), Matchers.closeTo((double)44.558083, (double)1.0E-6)}));
        MatcherAssert.assertThat((Object)((String)this.readSingle(json, basePath + ".links[?(@.rel=='self')].href")), (Matcher)Matchers.equalTo((Object)("http://localhost:8080/geoserver/ogc/images/v1/collections/sf%3Awatertemp/images/" + featureId + "?f=application%2Fstac%2Bjson")));
        MatcherAssert.assertThat((Object)((String)this.readSingle(json, basePath + ".links[?(@.rel=='alternate' && @.type =='text/html')].href")), (Matcher)Matchers.equalTo((Object)("http://localhost:8080/geoserver/ogc/images/v1/collections/sf%3Awatertemp/images/" + featureId + "?f=text%2Fhtml")));
        MatcherAssert.assertThat((Object)((String)this.readSingle(json, basePath + ".assets[?(@.type=='image/tiff')].title")), (Matcher)Matchers.equalTo((Object)"NCOM_wattemp_100_20081101T0000000_12.tiff"));
        MatcherAssert.assertThat((Object)((String)this.readSingle(json, basePath + ".assets[?(@.type=='image/tiff')].href")), (Matcher)Matchers.allOf((Matcher)Matchers.startsWith((String)("http://localhost:8080/geoserver/ogc/images/v1/collections/sf%3Awatertemp/images/" + featureId + "/assets/")), (Matcher)Matchers.endsWith((String)"-NCOM_wattemp_100_20081101T0000000_12.tiff")));
    }

    @Test
    public void testImageNotFound() throws Exception {
        String waterTemp = this.getLayerId(WATER_TEMP);
        MockHttpServletResponse response = this.getAsServletResponse("ogc/images/v1/collections/" + waterTemp + "/images/floopaloo?f=" + ResponseUtils.urlEncode((String)"application/stac+json", (char[])new char[0]));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)404));
    }

    @Test
    public void testWaterTempSingleImage() throws Exception {
        String waterTemp = this.getLayerId(WATER_TEMP);
        DocumentContext collectionJson = this.getAsJSONPath("ogc/images/v1/collections/" + waterTemp + "/images?f=" + ResponseUtils.urlEncode((String)"application/stac+json", (char[])new char[0]), 200);
        String featureId = (String)this.readSingle(collectionJson, "features[?(@.properties.datetime == '2008-11-01T00:00:00Z' && @.properties.elevation == 100)].id");
        MatcherAssert.assertThat((Object)featureId, (Matcher)Matchers.startsWith((String)"watertemp."));
        this.getAsJSONPath("ogc/images/v1/collections/" + waterTemp + "/images/" + featureId + "?f=" + ResponseUtils.urlEncode((String)"application/stac+json", (char[])new char[0]), 200);
    }

    @Test
    public void testWaterTempGetAsset() throws Exception {
        String waterTemp = this.getLayerId(WATER_TEMP);
        DocumentContext json = this.getAsJSONPath("ogc/images/v1/collections/" + waterTemp + "/images?f=" + ResponseUtils.urlEncode((String)"application/stac+json", (char[])new char[0]), 200);
        String featureId = (String)this.readSingle(json, "features[?(@.properties.datetime == '2008-11-01T00:00:00Z' && @.properties.elevation == 100)].id");
        MatcherAssert.assertThat((Object)featureId, (Matcher)Matchers.startsWith((String)"watertemp."));
        String basePath = "features[?(@.id == '" + featureId + "')]";
        MatcherAssert.assertThat((Object)((String)this.readSingle(json, basePath + ".assets[?(@.type=='image/tiff')].title")), (Matcher)Matchers.equalTo((Object)"NCOM_wattemp_100_20081101T0000000_12.tiff"));
        String assetHRef = (String)this.readSingle(json, basePath + ".assets[?(@.type=='image/tiff')].href");
        String testAssetHRef = assetHRef.substring("http://localhost:8080/geoserver/".length());
        MockHttpServletResponse response = this.getAsServletResponse(testAssetHRef);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)response.getContentType(), (Matcher)Matchers.equalTo((Object)"image/tiff"));
        Resource mosaicDirectory = this.getDataDirectory().get(new String[]{"watertemp"});
        Resource referenceFile = mosaicDirectory.get("NCOM_wattemp_100_20081101T0000000_12.tiff");
        try (InputStream referenceIs = referenceFile.in();){
            IOUtils.contentEquals((InputStream)referenceIs, (InputStream)new ByteArrayInputStream(response.getContentAsByteArray()));
        }
    }
}

