/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.features;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.ogcapi.v1.features.FeaturesTestSupport;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class FeatureTest
extends FeaturesTestSupport {
    private static final String WEB_MERCATOR_URI = "http://www.opengis.net/def/crs/EPSG/0/3857";

    @Test
    public void testContentDisposition() throws Exception {
        String roadSegments = ResponseUtils.urlEncode((String)this.getLayerId(MockData.ROAD_SEGMENTS), (char[])new char[0]);
        MockHttpServletResponse response = this.getAsServletResponse("ogc/features/v1/collections/" + roadSegments + "/items");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"inline; filename=RoadSegments.json", (Object)response.getHeader("Content-Disposition"));
    }

    @Test
    public void testGetLayerAsGeoJson() throws Exception {
        String roadSegments = ResponseUtils.urlEncode((String)this.getLayerId(MockData.ROAD_SEGMENTS), (char[])new char[0]);
        MockHttpServletResponse response = this.getAsMockHttpServletResponse("ogc/features/v1/collections/" + roadSegments + "/items", 200);
        Assert.assertEquals((Object)"<http://www.opengis.net/def/crs/OGC/1.3/CRS84>", (Object)response.getHeader("Content-Crs"));
        DocumentContext json = this.getAsJSONPath(response);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)5L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        List selfRels = (List)json.read("links[?(@.type == 'application/geo+json')].rel", new Predicate[0]);
        Assert.assertEquals((long)1L, (long)selfRels.size());
        Assert.assertEquals((Object)"self", selfRels.get(0));
        List alternatefRels = (List)json.read("links[?(@.type == 'application/json')].rel", new Predicate[0]);
        Assert.assertEquals((long)2L, (long)alternatefRels.size());
        Assert.assertEquals((Object)"alternate", alternatefRels.get(0));
        Assert.assertEquals((Object)"collection", alternatefRels.get(1));
        List selfLink = (List)json.read("links[?(@.rel == 'collection')].href", new Predicate[0]);
        MatcherAssert.assertThat((Object)selfLink.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)((String)selfLink.get(0)), (Matcher)Matchers.startsWith((String)("http://localhost:8080/geoserver/ogc/features/v1/collections/" + roadSegments + "?")));
    }

    @Test
    public void testGetLayerAsGeoJsonReproject() throws Exception {
        String roadSegments = ResponseUtils.urlEncode((String)this.getLayerId(MockData.ROAD_SEGMENTS), (char[])new char[0]);
        MockHttpServletResponse response = this.getAsMockHttpServletResponse("ogc/features/v1/collections/" + roadSegments + "/items?crs=http://www.opengis.net/def/crs/EPSG/0/3857", 200);
        Assert.assertEquals((Object)"<http://www.opengis.net/def/crs/EPSG/0/3857>", (Object)response.getHeader("Content-Crs"));
        DocumentContext json = this.getAsJSONPath(response);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)5L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        List result = (List)this.readSingle(json, "features[?(@.id=='RoadSegments.1107532045091')].geometry.coordinates");
        List ordinate0 = (List)((List)result.get(0)).get(0);
        List ordinate1 = (List)((List)result.get(0)).get(1);
        MatcherAssert.assertThat((Object)ordinate0, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.closeTo((double)-156.0, (double)1.0), Matchers.closeTo((double)-267.0, (double)1.0)}));
        MatcherAssert.assertThat((Object)ordinate1, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.closeTo((double)-156.0, (double)1.0), Matchers.closeTo((double)22.0, (double)1.0)}));
    }

    @Test
    public void testWorkspaceQualified() throws Exception {
        String roadSegments = MockData.ROAD_SEGMENTS.getLocalPart();
        DocumentContext json = this.getAsJSONPath(MockData.ROAD_SEGMENTS.getPrefix() + "/ogc/features/v1/collections/" + roadSegments + "/items", 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)5L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        List selfRels = (List)json.read("links[?(@.type == 'application/geo+json')].rel", new Predicate[0]);
        Assert.assertEquals((long)1L, (long)selfRels.size());
        Assert.assertEquals((Object)"self", selfRels.get(0));
        List alternatefRels = (List)json.read("links[?(@.type == 'application/json')].rel", new Predicate[0]);
        Assert.assertEquals((long)2L, (long)alternatefRels.size());
        Assert.assertEquals((Object)"alternate", alternatefRels.get(0));
        Assert.assertEquals((Object)"collection", alternatefRels.get(1));
        List selfLink = (List)json.read("links[?(@.rel == 'collection')].href", new Predicate[0]);
        MatcherAssert.assertThat((Object)selfLink.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)((String)selfLink.get(0)), (Matcher)Matchers.startsWith((String)("http://localhost:8080/geoserver/cite/ogc/features/v1/collections/" + roadSegments + "?")));
    }

    @Test
    public void testBBoxFilter() throws Exception {
        String roadSegments = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/items?bbox=35,0,60,3", 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)2L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)1L, (long)((List)json.read("features[?(@.id == 'PrimitiveGeoFeature.f001')]", List.class, new Predicate[0])).size());
        Assert.assertEquals((long)1L, (long)((List)json.read("features[?(@.id == 'PrimitiveGeoFeature.f002')]", List.class, new Predicate[0])).size());
    }

    @Test
    public void testBBoxCRSFilter() throws Exception {
        String roadSegments = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        ReferencedEnvelope bbox = new ReferencedEnvelope(35.0, 60.0, 0.0, 3.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        ReferencedEnvelope wmBox = bbox.transform(CRS.decode((String)"EPSG:3857", (boolean)true), true);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/items?" + this.bboxCrsQueryParameters(wmBox), 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)2L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)1L, (long)((List)json.read("features[?(@.id == 'PrimitiveGeoFeature.f001')]", List.class, new Predicate[0])).size());
        Assert.assertEquals((long)1L, (long)((List)json.read("features[?(@.id == 'PrimitiveGeoFeature.f002')]", List.class, new Predicate[0])).size());
    }

    private String bboxCrsQueryParameters(ReferencedEnvelope re) throws FactoryException {
        String boxValue = this.bboxQueryParameter(re);
        String crsValue = this.crsQueryParameter(re);
        return "bbox=" + boxValue + "&bbox-crs=" + crsValue;
    }

    private String bboxQueryParameter(ReferencedEnvelope re) {
        return re.getMinX() + "," + re.getMinY() + "," + re.getMaxX() + "," + re.getMaxY();
    }

    private String crsQueryParameter(ReferencedEnvelope re) throws FactoryException {
        return CRS.equalsIgnoreMetadata((Object)re.getCoordinateReferenceSystem(), (Object)DefaultGeographicCRS.WGS84) ? "http://www.opengis.net/def/crs/OGC/1.3/CRS84" : "http://www.opengis.net/def/crs/EPSG/0/" + CRS.lookupEpsgCode((CoordinateReferenceSystem)re.getCoordinateReferenceSystem(), (boolean)true);
    }

    @Test
    public void testBBOXOGCAuthority() throws Exception {
        String roadSegments = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/items?bbox=35,0,60,3&bbox-crs=http://www.opengis.net/def/crs/OGC/1.3/CRS84", 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)2L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)1L, (long)((List)json.read("features[?(@.id == 'PrimitiveGeoFeature.f001')]", List.class, new Predicate[0])).size());
        Assert.assertEquals((long)1L, (long)((List)json.read("features[?(@.id == 'PrimitiveGeoFeature.f002')]", List.class, new Predicate[0])).size());
    }

    @Test
    public void testInvalidBBOXCRS() throws Exception {
        String roadSegments = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/items?bbox=35,0,60,3&bbox-crs=http://www.opengis.net/def/crs/OGC/1.3/INVALID", 400);
        Assert.assertEquals((Object)"InvalidParameterValue", (Object)json.read("code", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"Invalid CRS: http://www.opengis.net/def/crs/OGC/1.3/INVALID", (Object)json.read("description", new Predicate[0]));
    }

    @Test
    public void testBBoxDatelineCrossingFilter() throws Exception {
        String roadSegments = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/items?bbox=170,0,60,3", 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)2L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)1L, (long)((List)json.read("features[?(@.id == 'PrimitiveGeoFeature.f001')]", List.class, new Predicate[0])).size());
        Assert.assertEquals((long)1L, (long)((List)json.read("features[?(@.id == 'PrimitiveGeoFeature.f002')]", List.class, new Predicate[0])).size());
    }

    @Test
    public void testCqlFilter() throws Exception {
        String roadSegments = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/items?filter=name='name-f001'", 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)1L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)1L, (long)((List)json.read("features[?(@.id == 'PrimitiveGeoFeature.f001')]", List.class, new Predicate[0])).size());
    }

    @Test
    public void testCql2JsonFilter() throws Exception {
        String roadSegments = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/items?filter=%7B%22op%22%3A%22%3D%22%2C%22args%22%3A%5B%7B%22property%22%3A%22name%22%7D%2C%22name-f001%22%5D%7D&filter-lang=cql2-json", 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)1L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)1L, (long)((List)json.read("features[?(@.id == 'PrimitiveGeoFeature.f001')]", List.class, new Predicate[0])).size());
    }

    @Test
    public void testCqlSpatialFilter() throws Exception {
        String roadSegments = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/items?filter=BBOX(pointProperty,38,1,40,3)&filter-lang=cql-text", 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)1L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)1L, (long)((List)json.read("features[?(@.id == 'PrimitiveGeoFeature.f001')]", List.class, new Predicate[0])).size());
    }

    @Test
    public void testCql2JsonSpatialFilter() throws Exception {
        String roadSegments = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/items?filter=%7B%22op%22%3A%22s_intersects%22%2C%22args%22%3A%5B%7B%22property%22%3A%22pointProperty%22%7D%2C%7B%22bbox%22%3A%5B38%2C1%2C40%2C3%5D%7D%5D%7D&filter-lang=cql2-json", 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)1L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)1L, (long)((List)json.read("features[?(@.id == 'PrimitiveGeoFeature.f001')]", List.class, new Predicate[0])).size());
    }

    @Test
    public void testCqlSpatialFilterWithFilterCrs() throws Exception {
        String roadSegments = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        ReferencedEnvelope bbox = new ReferencedEnvelope(38.0, 40.0, 1.0, 3.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        ReferencedEnvelope wmBox = bbox.transform(CRS.decode((String)"EPSG:3857", (boolean)true), true);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/items?" + this.filterCrsQueryParameters(wmBox), 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)1L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)1L, (long)((List)json.read("features[?(@.id == 'PrimitiveGeoFeature.f001')]", List.class, new Predicate[0])).size());
    }

    private String filterCrsQueryParameters(ReferencedEnvelope re) throws FactoryException {
        String boxValue = "BBOX(pointProperty," + this.bboxQueryParameter(re) + ")";
        String crsValue = this.crsQueryParameter(re);
        return "filter=" + boxValue + "&filter-crs=" + crsValue + "&filter-lang=cql-text";
    }

    @Test
    public void testCqlFilterInvalidCrs() throws Exception {
        String roadSegments = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/items?filter=BBOX(pointProperty,38,1,40,3)&filter-crs=http://www.opengis.net/def/crs/EPSG/0/0", 400);
        Assert.assertEquals((Object)"InvalidParameterValue", (Object)json.read("code", String.class, new Predicate[0]));
        MatcherAssert.assertThat((Object)((String)json.read("description", String.class, new Predicate[0])), (Matcher)Matchers.containsString((String)"EPSG:0"));
    }

    @Test
    public void testCqlFilterInvalidLanguage() throws Exception {
        String roadSegments = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/items?filter=name='name-f001'&filter-lang=foo-bar", 400);
        Assert.assertEquals((Object)"InvalidParameterValue", (Object)json.read("code", String.class, new Predicate[0]));
        MatcherAssert.assertThat((Object)((String)json.read("description", String.class, new Predicate[0])), (Matcher)Matchers.containsString((String)"foo-bar"));
    }

    @Test
    public void testTimeFilter() throws Exception {
        String roadSegments = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/items?datetime=2006-10-25", 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)1L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)1L, (long)((List)json.read("features[?(@.id == 'PrimitiveGeoFeature.f001')]", List.class, new Predicate[0])).size());
    }

    @Test
    public void testTimeRangeFilter() throws Exception {
        String roadSegments = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/items?datetime=2006-09-01/2006-10-23", 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)2L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)1L, (long)((List)json.read("features[?(@.id == 'PrimitiveGeoFeature.f002')]", List.class, new Predicate[0])).size());
        Assert.assertEquals((long)1L, (long)((List)json.read("features[?(@.id == 'PrimitiveGeoFeature.f003')]", List.class, new Predicate[0])).size());
    }

    @Test
    public void testTimeDurationFilter() throws Exception {
        String roadSegments = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/items?datetime=2006-09-01/P1M23DT12H31M12S", 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)2L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)1L, (long)((List)json.read("features[?(@.id == 'PrimitiveGeoFeature.f002')]", List.class, new Predicate[0])).size());
        Assert.assertEquals((long)1L, (long)((List)json.read("features[?(@.id == 'PrimitiveGeoFeature.f003')]", List.class, new Predicate[0])).size());
    }

    @Test
    public void testCombinedSpaceTimeFilter() throws Exception {
        String roadSegments = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/items?datetime=2006-09-01/2006-10-23&bbox=35,0,60,3", 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)1L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)1L, (long)((List)json.read("features[?(@.id == 'PrimitiveGeoFeature.f002')]", List.class, new Predicate[0])).size());
    }

    @Test
    public void testSortByWithDefaultSortOrder() throws Exception {
        String roadSegments = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/items?sortby=name&limit=2", 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)2L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals(null, (Object)json.read("features[0].properties.name", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"name-f001", (Object)json.read("features[1].properties.name", String.class, new Predicate[0]));
    }

    @Test
    public void testSortByWithAscendingSortOrder() throws Exception {
        String roadSegments = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/items?sortby=%2Bname&limit=2", 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)2L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals(null, (Object)json.read("features[0].properties.name", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"name-f001", (Object)json.read("features[1].properties.name", String.class, new Predicate[0]));
    }

    @Test
    public void testSortByWithDescendingSortOrder() throws Exception {
        String roadSegments = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/items?sortby=-name&limit=2", 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)2L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((Object)"name-f008", (Object)json.read("features[0].properties.name", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"name-f003", (Object)json.read("features[1].properties.name", String.class, new Predicate[0]));
    }

    @Test
    public void testSortByMultipleProperties() throws Exception {
        String roadSegments = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/items?sortby=booleanProperty,-intProperty", 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)5L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals(null, (Object)json.read("features[0].properties.name", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"name-f002", (Object)json.read("features[1].properties.name", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"name-f008", (Object)json.read("features[2].properties.name", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"name-f003", (Object)json.read("features[3].properties.name", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"name-f001", (Object)json.read("features[4].properties.name", String.class, new Predicate[0]));
    }

    @Test
    public void testIdsFilter() throws Exception {
        String roadSegments = this.getLayerId(MockData.ROAD_SEGMENTS);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/items?ids=RoadSegments.1107532045088,RoadSegments.1107532045091", 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)2L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((Object)"RoadSegments.1107532045088", (Object)json.read("features[0].id", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"RoadSegments.1107532045091", (Object)json.read("features[1].id", String.class, new Predicate[0]));
    }

    @Test
    public void testSearchCql2JsonFilter() throws Exception {
        String roadSegments = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        String request = "{\n  \"filter\": {\"op\":\"=\",\"args\":[{\"property\":\"name\"},\"name-f001\"]},  \"filter-lang\": \"cql2-json\"\n}";
        DocumentContext json = this.postAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/search", request, 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)1L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)1L, (long)((List)json.read("features[?(@.id == 'PrimitiveGeoFeature.f001')]", List.class, new Predicate[0])).size());
    }

    @Test
    public void testSearchCql2TextFilter() throws Exception {
        String roadSegments = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        String request = "{\n  \"filter\": \"BBOX(pointProperty,38,1,40,3)\",\n  \"filter-lang\": \"cql-text\"\n}";
        DocumentContext json = this.postAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/search", request, 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)1L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)1L, (long)((List)json.read("features[?(@.id == 'PrimitiveGeoFeature.f001')]", List.class, new Predicate[0])).size());
    }

    @Test
    public void testSearchCql2TextFilterWithFilterCrs() throws Exception {
        String roadSegments = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        ReferencedEnvelope bbox = new ReferencedEnvelope(38.0, 40.0, 1.0, 3.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        ReferencedEnvelope wmBox = bbox.transform(CRS.decode((String)"EPSG:3857", (boolean)true), true);
        String crsValue = this.crsQueryParameter(wmBox);
        String request = "{\n  \"filter\": \"BBOX(pointProperty," + this.bboxQueryParameter(wmBox) + ")\",\n \"filter-lang\": \"cql-text\"\n, \"filter-crs\": \"" + crsValue + "\"\n}";
        DocumentContext json = this.postAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/search", request, 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)1L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)1L, (long)((List)json.read("features[?(@.id == 'PrimitiveGeoFeature.f001')]", List.class, new Predicate[0])).size());
    }

    @Test
    public void testSearchBBoxJsonFilter() throws Exception {
        String roadSegments = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        String request = "{\"bbox\":[35, 0, 60, 3]}";
        DocumentContext json = this.postAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/search", request, 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)2L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)1L, (long)((List)json.read("features[?(@.id == 'PrimitiveGeoFeature.f001')]", List.class, new Predicate[0])).size());
        Assert.assertEquals((long)1L, (long)((List)json.read("features[?(@.id == 'PrimitiveGeoFeature.f002')]", List.class, new Predicate[0])).size());
    }

    @Test
    public void testSearchBBoxTextFilter() throws Exception {
        String roadSegments = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        String request = "{\"bbox\":\"35,0,60,3\"}";
        DocumentContext json = this.postAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/search", request, 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)2L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)1L, (long)((List)json.read("features[?(@.id == 'PrimitiveGeoFeature.f001')]", List.class, new Predicate[0])).size());
        Assert.assertEquals((long)1L, (long)((List)json.read("features[?(@.id == 'PrimitiveGeoFeature.f002')]", List.class, new Predicate[0])).size());
    }

    @Test
    public void testSearchBBoxCRSFilter() throws Exception {
        String roadSegments = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        ReferencedEnvelope bbox = new ReferencedEnvelope(35.0, 60.0, 0.0, 3.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        ReferencedEnvelope wmBox = bbox.transform(CRS.decode((String)"EPSG:3857", (boolean)true), true);
        String boxValue = this.bboxQueryParameter(wmBox);
        String bboxCrsValue = this.crsQueryParameter(wmBox);
        String request = "{\"bbox\":\"" + boxValue + "\",\"bbox-crs\":\"" + bboxCrsValue + "\"}";
        DocumentContext json = this.postAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/search", request, 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)2L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)1L, (long)((List)json.read("features[?(@.id == 'PrimitiveGeoFeature.f001')]", List.class, new Predicate[0])).size());
        Assert.assertEquals((long)1L, (long)((List)json.read("features[?(@.id == 'PrimitiveGeoFeature.f002')]", List.class, new Predicate[0])).size());
    }

    @Test
    public void testSearchCRSFilter() throws Exception {
        String roadSegments = ResponseUtils.urlEncode((String)this.getLayerId(MockData.ROAD_SEGMENTS), (char[])new char[0]);
        String crs = WEB_MERCATOR_URI;
        String request = "{\"crs\":\"" + crs + "\"}";
        DocumentContext json = this.postAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/search", request, 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)5L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        List result = (List)this.readSingle(json, "features[?(@.id=='RoadSegments.1107532045091')].geometry.coordinates");
        List ordinate0 = (List)((List)result.get(0)).get(0);
        List ordinate1 = (List)((List)result.get(0)).get(1);
        MatcherAssert.assertThat((Object)ordinate0, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.closeTo((double)-156.0, (double)1.0), Matchers.closeTo((double)-267.0, (double)1.0)}));
        MatcherAssert.assertThat((Object)ordinate1, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.closeTo((double)-156.0, (double)1.0), Matchers.closeTo((double)22.0, (double)1.0)}));
    }

    @Test
    public void testSearchIdsJsonFilter() throws Exception {
        String roadSegments = this.getLayerId(MockData.ROAD_SEGMENTS);
        String request = "{\"ids\":[\"RoadSegments.1107532045088\",\"RoadSegments.1107532045091\"]}";
        DocumentContext json = this.postAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/search", request, 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)2L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((Object)"RoadSegments.1107532045088", (Object)json.read("features[0].id", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"RoadSegments.1107532045091", (Object)json.read("features[1].id", String.class, new Predicate[0]));
    }

    @Test
    public void testSearchIdsTextFilter() throws Exception {
        String roadSegments = this.getLayerId(MockData.ROAD_SEGMENTS);
        String request = "{\"ids\":\"RoadSegments.1107532045088,RoadSegments.1107532045091\"}";
        DocumentContext json = this.postAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/search", request, 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)2L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((Object)"RoadSegments.1107532045088", (Object)json.read("features[0].id", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"RoadSegments.1107532045091", (Object)json.read("features[1].id", String.class, new Predicate[0]));
    }

    @Test
    public void testSearchDatetimeFilter() throws Exception {
        String roadSegments = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        String request = "{\"datetime\":\"2006-10-25\"}";
        DocumentContext json = this.postAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/search", request, 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)1L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)1L, (long)((List)json.read("features[?(@.id == 'PrimitiveGeoFeature.f001')]", List.class, new Predicate[0])).size());
    }

    @Test
    public void testSearchSortByJson() throws Exception {
        String roadSegments = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        String request = "{\"sortby\":[\"name\"],\"limit\":2}";
        DocumentContext json = this.postAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/search", request, 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)2L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals(null, (Object)json.read("features[0].properties.name", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"name-f001", (Object)json.read("features[1].properties.name", String.class, new Predicate[0]));
    }

    @Test
    public void testSearchSortByText() throws Exception {
        String roadSegments = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        String request = "{\"sortby\":\"name\",\"limit\":2}";
        DocumentContext json = this.postAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/search", request, 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((long)2L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals(null, (Object)json.read("features[0].properties.name", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"name-f001", (Object)json.read("features[1].properties.name", String.class, new Predicate[0]));
    }

    @Test
    public void testSingleFeatureAsGeoJson() throws Exception {
        String roadSegments = this.getLayerId(MockData.ROAD_SEGMENTS);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/items/RoadSegments.1107532045088", 200);
        Assert.assertEquals((Object)"Feature", (Object)json.read("type", String.class, new Predicate[0]));
        String geoJsonLinkPath = "links[?(@.type == 'application/geo+json')]";
        List selfRels = (List)json.read(geoJsonLinkPath + ".rel", new Predicate[0]);
        Assert.assertEquals((long)1L, (long)selfRels.size());
        Assert.assertEquals((Object)"self", selfRels.get(0));
        String href = (String)((List)json.read(geoJsonLinkPath + "href", new Predicate[0])).get(0);
        String expected = "http://localhost:8080/geoserver/ogc/features/v1/collections/cite%3ARoadSegments/items/RoadSegments.1107532045088?f=application%2Fgeo%2Bjson";
        Assert.assertEquals((Object)expected, (Object)href);
        List alternatefRels = (List)json.read("links[?(@.type == 'application/json')].rel", new Predicate[0]);
        Assert.assertEquals((long)2L, (long)alternatefRels.size());
        Assert.assertEquals((Object)"alternate", alternatefRels.get(0));
        Assert.assertEquals((Object)"collection", alternatefRels.get(1));
    }

    @Test
    public void testFirstPage() throws Exception {
        String expectedNextURL = "http://localhost:8080/geoserver/ogc/features/v1/collections/cite%3ARoadSegments/items?limit=3&startIndex=3";
        String roadSegments = this.getLayerId(MockData.ROAD_SEGMENTS);
        MockHttpServletResponse response = this.getAsMockHttpServletResponse("ogc/features/v1/collections/" + roadSegments + "/items?limit=3", 200);
        List links = response.getHeaders("Link");
        MatcherAssert.assertThat((Object)links, (Matcher)Matchers.hasSize((int)1));
        Assert.assertEquals(links.get(0), (Object)("<" + expectedNextURL + ">; rel=\"next\"; type=\"application/geo+json\""));
        DocumentContext json = this.getAsJSONPath(response);
        Assert.assertEquals((long)3L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        MatcherAssert.assertThat((Object)((Collection)json.read("$.links[?(@.rel=='prev')].href", new Predicate[0])), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)((JSONArray)json.read("$.links[?(@.rel=='next')].href", JSONArray.class, new Predicate[0])).get(0), (Matcher)CoreMatchers.equalTo((Object)expectedNextURL));
    }

    @Test
    public void testMiddlePage() throws Exception {
        String expectedPrevURL = "http://localhost:8080/geoserver/ogc/features/v1/collections/cite%3ARoadSegments/items?startIndex=2&limit=1";
        String expectedNextURL = "http://localhost:8080/geoserver/ogc/features/v1/collections/cite%3ARoadSegments/items?startIndex=4&limit=1";
        String roadSegments = this.getLayerId(MockData.ROAD_SEGMENTS);
        MockHttpServletResponse response = this.getAsMockHttpServletResponse("ogc/features/v1/collections/" + roadSegments + "/items?startIndex=3&limit=1", 200);
        List links = response.getHeaders("Link");
        MatcherAssert.assertThat((Object)links, (Matcher)Matchers.hasSize((int)2));
        Assert.assertEquals((Object)("<" + expectedPrevURL + ">; rel=\"prev\"; type=\"application/geo+json\""), links.get(0));
        Assert.assertEquals((Object)("<" + expectedNextURL + ">; rel=\"next\"; type=\"application/geo+json\""), links.get(1));
        DocumentContext json = this.getAsJSONPath(response);
        Assert.assertEquals((long)1L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        MatcherAssert.assertThat((Object)((JSONArray)json.read("$.links[?(@.rel=='prev')].href", JSONArray.class, new Predicate[0])).get(0), (Matcher)CoreMatchers.equalTo((Object)expectedPrevURL));
        MatcherAssert.assertThat((Object)((JSONArray)json.read("$.links[?(@.rel=='next')].href", JSONArray.class, new Predicate[0])).get(0), (Matcher)CoreMatchers.equalTo((Object)expectedNextURL));
    }

    @Test
    public void testLastPage() throws Exception {
        String expectedPrevLink = "http://localhost:8080/geoserver/ogc/features/v1/collections/cite%3ARoadSegments/items?startIndex=0&limit=3";
        String roadSegments = this.getLayerId(MockData.ROAD_SEGMENTS);
        MockHttpServletResponse response = this.getAsMockHttpServletResponse("ogc/features/v1/collections/" + roadSegments + "/items?startIndex=3&limit=3", 200);
        List links = response.getHeaders("Link");
        MatcherAssert.assertThat((Object)links, (Matcher)Matchers.hasSize((int)1));
        Assert.assertEquals(links.get(0), (Object)("<" + expectedPrevLink + ">; rel=\"prev\"; type=\"application/geo+json\""));
        DocumentContext json = this.getAsJSONPath(response);
        Assert.assertEquals((long)2L, (long)((Integer)json.read("features.length()", Integer.class, new Predicate[0])).intValue());
        MatcherAssert.assertThat((Object)((JSONArray)json.read("$.links[?(@.rel=='prev')].href", JSONArray.class, new Predicate[0])).get(0), (Matcher)CoreMatchers.equalTo((Object)expectedPrevLink));
        MatcherAssert.assertThat((Object)((Collection)json.read("$.links[?(@.rel=='next')].href", new Predicate[0])), (Matcher)Matchers.empty());
    }

    @Test
    public void testErrorHandling() throws Exception {
        String roadSegments = this.getLayerId(MockData.ROAD_SEGMENTS);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/items?limit=abc", 400);
        Assert.assertEquals((Object)"InvalidParameterValue", (Object)json.read("code", new Predicate[0]));
        MatcherAssert.assertThat((Object)((String)json.read("description", new Predicate[0])), (Matcher)CoreMatchers.both((Matcher)CoreMatchers.containsString((String)"limit")).and(CoreMatchers.containsString((String)"abc")));
    }

    @Test
    public void testGetLayerAsHTML() throws Exception {
        String roadSegments = this.getLayerId(MockData.ROAD_SEGMENTS);
        String url = "ogc/features/v1/collections/" + roadSegments + "/items?f=html";
        Document document = this.getAsJSoup(url);
        Assert.assertEquals((long)5L, (long)document.select("td:matches(RoadSegments\\..*)").size());
        Assert.assertEquals((Object)"106", (Object)document.select("td:matches(RoadSegments\\.1107532045091) + td").text());
    }

    @Test
    public void testGetLayerAsHTMLHeader() throws Exception {
        String roadSegments = this.getLayerId(MockData.ROAD_SEGMENTS);
        String url = "ogc/features/v1/collections/" + roadSegments + "/items?f=html";
        MockHttpServletResponse response = this.getAsMockHttpServletResponse(url, 200);
        Assert.assertEquals((Object)"<http://www.opengis.net/def/crs/OGC/1.3/CRS84>", (Object)response.getHeader("Content-Crs"));
    }

    @Test
    public void testGetLayerAsHTMLPagingLinks() throws Exception {
        String roadSegments = ResponseUtils.urlEncode((String)this.getLayerId(MockData.ROAD_SEGMENTS), (char[])new char[0]);
        String urlBase = "ogc/features/v1/collections/" + roadSegments + "/items?f=html";
        String expectedBase = "http://localhost:8080/geoserver/ogc/features/v1/collections/" + roadSegments + "/items";
        String firstPageURL = urlBase + "&limit=2";
        Document document = this.getAsJSoup(firstPageURL);
        Assert.assertNull((Object)document.getElementById("prevPage"));
        Assert.assertNotNull((Object)document.getElementById("nextPage"));
        String expectedSecondPageURL = expectedBase + "?f=html&limit=2&startIndex=2";
        this.assertURL(expectedSecondPageURL, document.getElementById("nextPage").attr("href"));
        document = this.getAsJSoup(urlBase + "&limit=2&startIndex=2");
        Assert.assertNotNull((Object)document.getElementById("prevPage"));
        Assert.assertNotNull((Object)document.getElementById("nextPage"));
        String expectedThirdPageURL = expectedBase + "?f=html&limit=2&startIndex=4";
        this.assertURL(expectedThirdPageURL, document.getElementById("nextPage").attr("href"));
        document = this.getAsJSoup(urlBase + "&limit=2&startIndex=4");
        Assert.assertNotNull((Object)document.getElementById("prevPage"));
        Assert.assertNull((Object)document.getElementById("nextPage"));
        this.assertURL(expectedSecondPageURL, document.getElementById("prevPage").attr("href"));
    }

    private void assertURL(String expectedURL, String actualURL) {
        String expectedPath = ResponseUtils.stripQueryString((String)expectedURL);
        String actualPath = ResponseUtils.stripQueryString((String)actualURL);
        Assert.assertEquals((Object)expectedPath, (Object)actualPath);
        Map expectedKVP = KvpUtils.parseQueryString((String)expectedPath);
        Map actualKVP = KvpUtils.parseQueryString((String)expectedPath);
        Assert.assertEquals((Object)expectedKVP, (Object)actualKVP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSpecialCharsInTypeName() throws Exception {
        FeatureTypeInfo genericEntity = this.getCatalog().getFeatureTypeByName(this.getLayerId(MockData.GENERICENTITY));
        genericEntity.setName("Entit\u00e9G\u00e9n\u00e9rique");
        this.getCatalog().save((ResourceInfo)genericEntity);
        try {
            String encodedLocalName = URLEncoder.encode(genericEntity.getName(), StandardCharsets.UTF_8.name());
            String typeName = URLEncoder.encode(genericEntity.prefixedName(), StandardCharsets.UTF_8.name());
            String encodedFeatureId = encodedLocalName + ".f004";
            DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + typeName + "/items/" + encodedFeatureId, 200);
            Assert.assertEquals((Object)"Feature", (Object)json.read("type", String.class, new Predicate[0]));
            String geoJsonLinkPath = "links[?(@.type == 'application/geo+json')]";
            List selfRels = (List)json.read(geoJsonLinkPath + ".rel", new Predicate[0]);
            Assert.assertEquals((long)1L, (long)selfRels.size());
            Assert.assertEquals((Object)"self", selfRels.get(0));
            String href = (String)((List)json.read(geoJsonLinkPath + "href", new Predicate[0])).get(0);
            String expected = "http://localhost:8080/geoserver/ogc/features/v1/collections/" + typeName + "/items/" + encodedFeatureId + "?f=application%2Fgeo%2Bjson";
            Assert.assertEquals((Object)expected, (Object)href);
            List alternatefRels = (List)json.read("links[?(@.type == 'application/json')].rel", new Predicate[0]);
            Assert.assertEquals((long)2L, (long)alternatefRels.size());
            Assert.assertEquals((Object)"alternate", alternatefRels.get(0));
            Assert.assertEquals((Object)"collection", alternatefRels.get(1));
        }
        finally {
            genericEntity.setName(MockData.GENERICENTITY.getLocalPart());
            this.getCatalog().save((ResourceInfo)genericEntity);
        }
    }

    @Test
    public void testGetItemAsGeoJson() throws Exception {
        String primitiveLayer = ResponseUtils.urlEncode((String)this.getLayerId(MockData.PRIMITIVEGEOFEATURE), (char[])new char[0]);
        MockHttpServletResponse response = this.getAsMockHttpServletResponse("ogc/features/v1/collections/" + primitiveLayer + "/items/PrimitiveGeoFeature.f002", 200);
        Assert.assertEquals((Object)"<http://www.opengis.net/def/crs/OGC/1.3/CRS84>", (Object)response.getHeader("Content-Crs"));
        DocumentContext json = this.getAsJSONPath(response);
        Assert.assertEquals((Object)"Feature", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"PrimitiveGeoFeature.f002", (Object)json.read("id", String.class, new Predicate[0]));
        List selfRels = (List)json.read("links[?(@.type == 'application/geo+json')].rel", new Predicate[0]);
        Assert.assertEquals((long)1L, (long)selfRels.size());
        Assert.assertEquals((Object)"self", selfRels.get(0));
        List alternatefRels = (List)json.read("links[?(@.type == 'application/json')].rel", new Predicate[0]);
        Assert.assertTrue((alternatefRels.size() > 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"alternate", alternatefRels.get(0));
        Assert.assertEquals((Object)"collection", alternatefRels.get(1));
        List selfLink = (List)json.read("links[?(@.rel == 'collection')].href", new Predicate[0]);
        MatcherAssert.assertThat((Object)selfLink.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)((String)selfLink.get(0)), (Matcher)Matchers.startsWith((String)("http://localhost:8080/geoserver/ogc/features/v1/collections/" + primitiveLayer + "?")));
    }

    @Test
    public void testGetItemAsGeoJsonWithCRS() throws Exception {
        String primitiveLayer = ResponseUtils.urlEncode((String)this.getLayerId(MockData.PRIMITIVEGEOFEATURE), (char[])new char[0]);
        MockHttpServletResponse response = this.getAsMockHttpServletResponse("ogc/features/v1/collections/" + primitiveLayer + "/items/PrimitiveGeoFeature.f002?crs=CRS:84", 200);
        Assert.assertEquals((Object)"<http://www.opengis.net/def/crs/OGC/1.3/CRS84>", (Object)response.getHeader("Content-Crs"));
        DocumentContext json = this.getAsJSONPath(response);
        Assert.assertEquals((Object)"Feature", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"PrimitiveGeoFeature.f002", (Object)json.read("id", String.class, new Predicate[0]));
        List selfRels = (List)json.read("links[?(@.type == 'application/geo+json')].rel", new Predicate[0]);
        Assert.assertEquals((long)1L, (long)selfRels.size());
        Assert.assertEquals((Object)"self", selfRels.get(0));
        List alternatefRels = (List)json.read("links[?(@.type == 'application/json')].rel", new Predicate[0]);
        Assert.assertTrue((alternatefRels.size() > 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"alternate", alternatefRels.get(0));
        Assert.assertEquals((Object)"collection", alternatefRels.get(1));
        List selfLink = (List)json.read("links[?(@.rel == 'collection')].href", new Predicate[0]);
        MatcherAssert.assertThat((Object)selfLink.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)((String)selfLink.get(0)), (Matcher)Matchers.startsWith((String)("http://localhost:8080/geoserver/ogc/features/v1/collections/" + primitiveLayer + "?")));
    }

    @Test
    public void testJSONFGSingleFeatureCRS84() throws Exception {
        String bridges = ResponseUtils.urlEncode((String)this.getLayerId(MockData.BRIDGES), (char[])new char[0]);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + bridges + "/items/Bridges.1107531599613?crs=CRS:84&f=" + ResponseUtils.urlEncode((String)"application/vnd.ogc.fg+json", (char[])new char[0]), 200);
        Assert.assertEquals((Object)"Feature", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertThrows(PathNotFoundException.class, () -> json.read("coordRefSys", String.class, new Predicate[0]));
        Assert.assertThrows(PathNotFoundException.class, () -> json.read("place", new Predicate[0]));
        Assert.assertEquals((Object)"Point", (Object)json.read("geometry.type", new Predicate[0]));
        Assert.assertArrayEquals((double[])new double[]{2.0E-4, 7.0E-4}, (double[])((double[])json.read("geometry.coordinates", double[].class, new Predicate[0])), (double)1.0E-4);
    }

    @Test
    public void testJSONFGSingleFeatureWebMercator() throws Exception {
        String bridges = ResponseUtils.urlEncode((String)this.getLayerId(MockData.BRIDGES), (char[])new char[0]);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + bridges + "/items/Bridges.1107531599613?crs=EPSG:3857&f=" + ResponseUtils.urlEncode((String)"application/vnd.ogc.fg+json", (char[])new char[0]), 200);
        Assert.assertEquals((Object)"Feature", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((Object)WEB_MERCATOR_URI, (Object)json.read("coordRefSys", String.class, new Predicate[0]));
        Assert.assertThrows(PathNotFoundException.class, () -> json.read("geometry", new Predicate[0]));
        Assert.assertEquals((Object)"Point", (Object)json.read("place.type", new Predicate[0]));
        Assert.assertArrayEquals((double[])new double[]{22.0, 78.0}, (double[])((double[])json.read("place.coordinates", double[].class, new Predicate[0])), (double)1.0);
        DocumentContext typeLink = this.readSingleContext(json, "links[?(@.rel == 'type')]");
        Assert.assertEquals((Object)"application/schema+json", (Object)typeLink.read("type", new Predicate[0]));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/features/v1/collections/cite%3ABridges/schemas/fg/feature.json", (Object)typeLink.read("href", new Predicate[0]));
    }

    @Test
    public void testJSONFGSingleFeatureETRS89() throws Exception {
        String bridges = ResponseUtils.urlEncode((String)this.getLayerId(MockData.BRIDGES), (char[])new char[0]);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + bridges + "/items/Bridges.1107531599613?crs=http://www.opengis.net/def/crs/EPSG/0/4258&f=" + ResponseUtils.urlEncode((String)"application/vnd.ogc.fg+json", (char[])new char[0]), 200);
        Assert.assertEquals((Object)"Feature", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"http://www.opengis.net/def/crs/EPSG/0/4258", (Object)json.read("coordRefSys", String.class, new Predicate[0]));
        Assert.assertThrows(PathNotFoundException.class, () -> json.read("geometry", new Predicate[0]));
        Assert.assertEquals((Object)"Point", (Object)json.read("place.type", new Predicate[0]));
        Assert.assertArrayEquals((double[])new double[]{7.0E-4, 2.0E-4}, (double[])((double[])json.read("place.coordinates", double[].class, new Predicate[0])), (double)1.0E-4);
    }

    @Test
    public void testJSONFG_CRS84() throws Exception {
        String bridges = ResponseUtils.urlEncode((String)this.getLayerId(MockData.BRIDGES), (char[])new char[0]);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + bridges + "/items?crs=CRS:84&f=" + ResponseUtils.urlEncode((String)"application/vnd.ogc.fg+json", (char[])new char[0]), 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertThrows(PathNotFoundException.class, () -> json.read("coordRefSys", String.class, new Predicate[0]));
        Assert.assertEquals((long)0L, (long)((Integer)json.read("geometryDimension", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((Object)"cite:Bridges", (Object)json.read("featureType", new Predicate[0]));
        DocumentContext feature = this.readContext(json, "features[0]");
        Assert.assertThrows(PathNotFoundException.class, () -> feature.read("place", new Predicate[0]));
        Assert.assertEquals((Object)"Point", (Object)feature.read("geometry.type", new Predicate[0]));
        Assert.assertArrayEquals((double[])new double[]{2.0E-4, 7.0E-4}, (double[])((double[])feature.read("geometry.coordinates", double[].class, new Predicate[0])), (double)1.0E-4);
        Assert.assertEquals((Object)"Point", (Object)feature.read("geometry.type", new Predicate[0]));
        DocumentContext typeLink = this.readSingleContext(json, "links[?(@.rel == 'type')]");
        Assert.assertEquals((Object)"application/schema+json", (Object)typeLink.read("type", new Predicate[0]));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/features/v1/collections/cite%3ABridges/schemas/fg/collection.json", (Object)typeLink.read("href", new Predicate[0]));
    }

    @Test
    public void testJSONFGWebMercator() throws Exception {
        String bridges = ResponseUtils.urlEncode((String)this.getLayerId(MockData.BRIDGES), (char[])new char[0]);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + bridges + "/items?crs=EPSG:3857&f=" + ResponseUtils.urlEncode((String)"application/vnd.ogc.fg+json", (char[])new char[0]), 200);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", String.class, new Predicate[0]));
        Assert.assertEquals((Object)WEB_MERCATOR_URI, (Object)json.read("coordRefSys", String.class, new Predicate[0]));
        DocumentContext feature = this.readContext(json, "features[0]");
        Assert.assertThrows(PathNotFoundException.class, () -> feature.read("geometry", new Predicate[0]));
        Assert.assertEquals((Object)"Point", (Object)feature.read("place.type", new Predicate[0]));
        Assert.assertArrayEquals((double[])new double[]{22.0, 78.0}, (double[])((double[])feature.read("place.coordinates", double[].class, new Predicate[0])), (double)1.0);
    }
}

