/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.features;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.JsonContext;
import java.util.List;
import org.geoserver.ogcapi.features.FeatureService;
import org.geoserver.ogcapi.features.FeaturesTestSupport;
import org.geoserver.platform.Service;
import org.geotools.util.Version;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class LandingPageTest
extends FeaturesTestSupport {
    @Test
    public void testServiceDescriptor() {
        Service service = this.getService("Features", new Version("1.0.1"));
        Assert.assertNotNull((Object)service);
        Assert.assertEquals((Object)"Features", (Object)service.getId());
        Assert.assertEquals((Object)new Version("1.0.1"), (Object)service.getVersion());
        MatcherAssert.assertThat((Object)service.getService(), (Matcher)CoreMatchers.instanceOf(FeatureService.class));
        MatcherAssert.assertThat((Object)service.getOperations(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"getApi", "describeCollection", "getCollections", "getConformanceDeclaration", "getFeature", "getFeatures", "getLandingPage", "getQueryables", "getFunctions"}));
    }

    @Test
    public void testLandingPageNoSlash() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/features", 200);
        this.checkJSONLandingPage(json);
    }

    @Test
    public void testLandingPageSlash() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/features/", 200);
        this.checkJSONLandingPage(json);
    }

    @Test
    public void testLandingPageJSON() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/features?f=json", 200);
        this.checkJSONLandingPage(json);
    }

    @Test
    public void testLandingPageWorkspaceSpecific() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/features", 200);
        this.checkJSONLandingPage(json);
    }

    @Test
    @Ignore
    public void testLandingPageXML() throws Exception {
        org.w3c.dom.Document dom = this.getAsDOM("ogc/features?f=application/xml");
        this.print(dom);
    }

    @Test
    public void testLandingPageYaml() throws Exception {
        String yaml = this.getAsString("ogc/features?f=application/x-yaml");
        JsonContext json = this.convertYamlToJsonPath(yaml);
        this.assertJSONList((DocumentContext)json, "links[?(@.type == 'application/x-yaml' && @.href =~ /.*ogc\\/features\\/\\?.*/)].rel", new String[]{"self"});
        this.assertJSONList((DocumentContext)json, "links[?(@.type != 'application/x-yaml' && @.href =~ /.*ogc\\/features\\/\\?.*/)].rel", new String[]{"alternate", "alternate"});
        this.checkJSONLandingPageShared((DocumentContext)json);
    }

    @Test
    public void testLandingPageHTML() throws Exception {
        Document document = this.getAsJSoup("ogc/features?f=html");
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/features/collections?f=text%2Fhtml", (Object)document.select("#htmlCollectionsLink").attr("href"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/features/openapi?f=text%2Fhtml", (Object)document.select("#htmlApiLink").attr("href"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/features/conformance?f=text%2Fhtml", (Object)document.select("#htmlConformanceLink").attr("href"));
    }

    @Test
    public void testLandingPageHTMLInWorkspace() throws Exception {
        Document document = this.getAsJSoup("sf/ogc/features?f=html");
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/sf/ogc/features/collections?f=text%2Fhtml", (Object)document.select("#htmlCollectionsLink").attr("href"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/sf/ogc/features/openapi?f=text%2Fhtml", (Object)document.select("#htmlApiLink").attr("href"));
    }

    void checkJSONLandingPage(DocumentContext json) {
        Assert.assertEquals((long)15L, (long)((Integer)json.read("links.length()", Integer.class, new Predicate[0])).intValue());
        this.assertJSONList(json, "links[?(@.type == 'application/json' && @.href =~ /.*ogc\\/features\\/\\?.*/)].rel", new String[]{"self"});
        this.assertJSONList(json, "links[?(@.type != 'application/json' && @.href =~ /.*ogc\\/features\\/\\?.*/)].rel", new String[]{"alternate", "alternate"});
        this.checkJSONLandingPageShared(json);
    }

    void checkJSONLandingPageShared(DocumentContext json) {
        this.assertJSONList(json, "links[?(@.href =~ /.*ogc\\/features\\/openapi.*/)].rel", new String[]{"service-desc", "service-desc", "service-doc"});
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/features/openapi?f=application%2Fvnd.oai.openapi%2Bjson%3Bversion%3D3.0", (Object)this.readSingle(json, "links[?(@.type=='application/vnd.oai.openapi+json;version=3.0')].href"));
        this.assertJSONList(json, "links[?(@.href =~ /.*ogc\\/features\\/conformance.*/)].rel", new String[]{"conformance", "conformance", "conformance"});
        this.assertJSONList(json, "links[?(@.href =~ /.*ogc\\/features\\/collections.*/)].rel", new String[]{"data", "data", "data"});
        Assert.assertEquals((Object)"Features 1.0 server", (Object)json.read("title", new Predicate[0]));
        Assert.assertEquals((Object)"", (Object)json.read("description", new Predicate[0]));
    }

    @Test
    public void testLandingPageHeaders() throws Exception {
        MockHttpServletResponse response = this.getAsMockHttpServletResponse("ogc/features", 200);
        List link = response.getHeaders("Link");
        MatcherAssert.assertThat((Object)link, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"<http://localhost:8080/geoserver/ogc/features/?f=application%2Fx-yaml>; rel=\"alternate\"; type=\"application/x-yaml\"; title=\"This document as application/x-yaml\"", "<http://localhost:8080/geoserver/ogc/features/?f=application%2Fjson>; rel=\"self\"; type=\"application/json\"; title=\"This document\""}));
    }
}

