/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.features;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import java.util.List;
import java.util.stream.Collectors;
import org.geoserver.ogcapi.features.FeaturesTestSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ConformanceTest
extends FeaturesTestSupport {
    @Test
    public void testConformanceJson() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/features/conformance", 200);
        this.checkConformance(json);
    }

    private void checkConformance(DocumentContext json) {
        Assert.assertEquals((long)2L, (long)((Integer)json.read("$.length()", Integer.class, new Predicate[0])).intValue());
        MatcherAssert.assertThat((Object)((Iterable)json.read("$.conformsTo", new Predicate[0])), (Matcher)Matchers.containsInAnyOrder((Object[])this.getExpectedConformanceClasses()));
    }

    private String[] getExpectedConformanceClasses() {
        return new String[]{"http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/core", "http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/oas30", "http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/html", "http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/geojson", "http://www.opengis.net/spec/ogcapi-features-2/1.0/conf/crs", "http://www.opengis.net/spec/ogcapi-features-3/1.0/req/features-filter", "http://www.opengis.net/spec/ogcapi-features-3/1.0/req/filter", "http://geoserver.org/spec/ecql/1.0/req/gs-ecql", "http://geoserver.org/spec/ecql/1.0/req/ecql-text", "http://www.opengis.net/spec/cql2/1.0/req/basic-cql2", "http://www.opengis.net/spec/cql2/1.0/req/advanced-comparison-operators", "http://www.opengis.net/spec/cql2/1.0/req/arithmetic", "http://www.opengis.net/spec/cql2/1.0/req/property-property", "http://www.opengis.net/spec/cql2/1.0/req/basic-spatial-operators", "http://www.opengis.net/spec/cql2/1.0/req/spatial-operators", "http://www.opengis.net/spec/cql2/1.0/req/functions", "http://www.opengis.net/spec/cql2/1.0/req/cql2-text", "http://www.opengis.net/spec/ogcapi-records-1/1.0/req/sorting"};
    }

    @Test
    @Ignore
    public void testConformanceXML() throws Exception {
        org.w3c.dom.Document dom = this.getAsDOM("ogc/features?f=application/xml");
        this.print(dom);
    }

    @Test
    public void testCollectionsYaml() throws Exception {
        String yaml = this.getAsString("ogc/features/conformance/?f=application/x-yaml");
        this.checkConformance((DocumentContext)this.convertYamlToJsonPath(yaml));
    }

    @Test
    public void testConformanceHTML() throws Exception {
        Document document = this.getAsJSoup("ogc/features/conformance?f=text/html");
        Assert.assertEquals((Object)"GeoServer OGC API Features Conformance", (Object)document.select("#title").text());
        List classes = document.select("#content li").stream().map(e -> e.text()).collect(Collectors.toList());
        MatcherAssert.assertThat(classes, (Matcher)Matchers.containsInAnyOrder((Object[])this.getExpectedConformanceClasses()));
    }
}

