/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.features;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.servers.Server;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.ogcapi.APIFilterParser;
import org.geoserver.ogcapi.features.FeaturesTestSupport;
import org.geoserver.test.GeoServerBaseTestSupport;
import org.geoserver.wfs.WFSInfo;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class ApiTest
extends FeaturesTestSupport {
    @Test
    public void testApiJson() throws Exception {
        MockHttpServletResponse response = this.getAsMockHttpServletResponse("ogc/features/openapi", 200);
        this.validateJSONAPI(response);
    }

    @Test
    public void testApiJsonExtension() throws Exception {
        MockHttpServletResponse response = this.getAsMockHttpServletResponse("ogc/features/openapi.json", 200);
        this.validateJSONAPI(response);
    }

    private void validateJSONAPI(MockHttpServletResponse response) throws UnsupportedEncodingException, JsonProcessingException {
        MatcherAssert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.startsWith((String)"application/vnd.oai.openapi+json;version=3.0"));
        String json = response.getContentAsString();
        GeoServerBaseTestSupport.LOGGER.log(Level.INFO, json);
        ObjectMapper mapper = Json.mapper();
        OpenAPI api = (OpenAPI)mapper.readValue(json, OpenAPI.class);
        this.validateApi(api);
    }

    @Test
    public void testHTMLEncoding() throws Exception {
        MockHttpServletResponse response = this.getAsMockHttpServletResponse("ogc/features?f=text/html", 200);
        Assert.assertEquals((Object)"text/html", (Object)response.getContentType());
        String html = response.getContentAsString();
        GeoServerBaseTestSupport.LOGGER.info(html);
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">"));
    }

    @Test
    public void testApiHTML() throws Exception {
        MockHttpServletResponse response = this.getAsMockHttpServletResponse("ogc/features/openapi?f=text/html", 200);
        Assert.assertEquals((Object)"text/html", (Object)response.getContentType());
        String html = response.getContentAsString();
        GeoServerBaseTestSupport.LOGGER.info(html);
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<link rel=\"icon\" type=\"image/png\" href=\"http://localhost:8080/geoserver/swagger-ui/favicon-32x32.png\" sizes=\"32x32\" />"));
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<link rel=\"icon\" type=\"image/png\" href=\"http://localhost:8080/geoserver/swagger-ui/favicon-16x16.png\" sizes=\"16x16\" />"));
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<script src=\"http://localhost:8080/geoserver/swagger-ui/swagger-ui-bundle.js\">"));
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<script src=\"http://localhost:8080/geoserver/swagger-ui/swagger-ui-standalone-preset.js\">"));
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"url: \"http://localhost:8080/geoserver/ogc/features/openapi?f=application%2Fvnd.oai.openapi%2Bjson%3Bversion%3D3.0"));
    }

    @Test
    public void testApiYaml() throws Exception {
        String yaml = this.getAsString("ogc/features/openapi?f=application/x-yaml");
        this.validateYAMLApi(yaml);
    }

    @Test
    public void testApiYamlExtension() throws Exception {
        String yaml = this.getAsString("ogc/features/openapi?f=application/x-yaml");
        this.validateYAMLApi(yaml);
    }

    private void validateYAMLApi(String yaml) throws JsonProcessingException {
        GeoServerBaseTestSupport.LOGGER.log(Level.INFO, yaml);
        ObjectMapper mapper = Yaml.mapper();
        OpenAPI api = (OpenAPI)mapper.readValue(yaml, OpenAPI.class);
        this.validateApi(api);
    }

    @Test
    public void testYamlAsAcceptsHeader() throws Exception {
        MockHttpServletRequest request = this.createRequest("ogc/features/openapi");
        request.setMethod("GET");
        request.setContent(new byte[0]);
        request.addHeader("Accept", (Object)"foo/bar, application/x-yaml, text/html");
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        MatcherAssert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.startsWith((String)"application/x-yaml"));
        String yaml = this.string(new ByteArrayInputStream(response.getContentAsString().getBytes()));
        ObjectMapper mapper = Yaml.mapper();
        OpenAPI api = (OpenAPI)mapper.readValue(yaml, OpenAPI.class);
        this.validateApi(api);
    }

    private void validateApi(OpenAPI api) {
        List servers = api.getServers();
        MatcherAssert.assertThat((Object)servers, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((Server)servers.get(0)).getUrl(), (Matcher)CoreMatchers.equalTo((Object)"http://localhost:8080/geoserver/ogc/features"));
        Paths paths = api.getPaths();
        PathItem landing = (PathItem)paths.get((Object)"/");
        Assert.assertNotNull((Object)landing);
        MatcherAssert.assertThat((Object)landing.getGet().getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"getLandingPage"));
        PathItem conformance = (PathItem)paths.get((Object)"/conformance");
        Assert.assertNotNull((Object)conformance);
        MatcherAssert.assertThat((Object)conformance.getGet().getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"getConformanceDeclaration"));
        PathItem collections = (PathItem)paths.get((Object)"/collections");
        Assert.assertNotNull((Object)collections);
        MatcherAssert.assertThat((Object)collections.getGet().getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"getCollections"));
        PathItem collection = (PathItem)paths.get((Object)"/collections/{collectionId}");
        Assert.assertNotNull((Object)collection);
        MatcherAssert.assertThat((Object)collection.getGet().getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"describeCollection"));
        PathItem items = (PathItem)paths.get((Object)"/collections/{collectionId}/items");
        Assert.assertNotNull((Object)items);
        Operation itemsGet = items.getGet();
        MatcherAssert.assertThat((Object)itemsGet.getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"getFeatures"));
        List parameters = itemsGet.getParameters();
        List itemGetParamNames = parameters.stream().map(p -> p.get$ref()).collect(Collectors.toList());
        MatcherAssert.assertThat(itemGetParamNames, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"#/components/parameters/collectionId", "#/components/parameters/limit", "#/components/parameters/bbox", "#/components/parameters/datetime", "#/components/parameters/filter", "#/components/parameters/filter-lang", "#/components/parameters/filter-crs", "#/components/parameters/sortby", "#/components/parameters/crs", "#/components/parameters/bbox-crs", "#/components/parameters/otherParameters"}));
        Parameter langs = (Parameter)api.getComponents().getParameters().get("filter-lang");
        Assert.assertEquals((Object)langs.getSchema().getEnum(), new ArrayList(APIFilterParser.SUPPORTED_ENCODINGS));
        PathItem item = (PathItem)paths.get((Object)"/collections/{collectionId}/items/{featureId}");
        Assert.assertNotNull((Object)item);
        MatcherAssert.assertThat((Object)item.getGet().getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"getFeature"));
        Map params = api.getComponents().getParameters();
        Parameter collectionId = (Parameter)params.get("collectionId");
        List collectionIdValues = collectionId.getSchema().getEnum();
        List expectedCollectionIds = this.getCatalog().getFeatureTypes().stream().map(ft -> ft.prefixedName()).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)collectionIdValues, (Matcher)CoreMatchers.equalTo(expectedCollectionIds));
        Parameter limit = (Parameter)params.get("limit");
        Schema limitSchema = limit.getSchema();
        Assert.assertEquals((Object)BigDecimal.valueOf(1L), (Object)limitSchema.getMinimum());
        WFSInfo wfs = (WFSInfo)this.getGeoServer().getService(WFSInfo.class);
        Assert.assertEquals((long)wfs.getMaxFeatures(), (long)limitSchema.getMaximum().intValue());
        Assert.assertEquals((long)wfs.getMaxFeatures(), (long)((Number)limitSchema.getDefault()).intValue());
    }

    @Test
    public void testWorkspaceQualifiedAPI() throws Exception {
        MockHttpServletRequest request = this.createRequest("cdf/ogc/features/openapi");
        request.setMethod("GET");
        request.setContent(new byte[0]);
        request.addHeader("Accept", (Object)"foo/bar, application/x-yaml, text/html");
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/x-yaml", (Object)response.getContentType());
        String yaml = this.string(new ByteArrayInputStream(response.getContentAsString().getBytes()));
        ObjectMapper mapper = Yaml.mapper();
        OpenAPI api = (OpenAPI)mapper.readValue(yaml, OpenAPI.class);
        Map params = api.getComponents().getParameters();
        Parameter collectionId = (Parameter)params.get("collectionId");
        List collectionIdValues = collectionId.getSchema().getEnum();
        List expectedCollectionIds = this.getCatalog().getFeatureTypesByNamespace(this.getCatalog().getNamespaceByPrefix("cdf")).stream().map(ft -> ft.getName()).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)collectionIdValues, (Matcher)CoreMatchers.equalTo(expectedCollectionIds));
    }
}

