/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.features;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.AbstractHTMLMessageConverter;
import org.geoserver.ogcapi.FreemarkerTemplateSupport;
import org.geoserver.ogcapi.features.FeaturesResponse;
import org.geoserver.wfs.TypeInfoCollectionWrapper;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeatureType;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.stereotype.Component;

@Component
public class GetFeatureHTMLMessageConverter
extends AbstractHTMLMessageConverter<FeaturesResponse> {
    public GetFeatureHTMLMessageConverter(FreemarkerTemplateSupport templateSupport, GeoServer geoServer) {
        super(FeaturesResponse.class, WFSInfo.class, templateSupport, geoServer);
    }

    private FeatureTypeInfo getResource(FeatureCollection collection) {
        FeatureTypeInfo info = null;
        if (collection instanceof TypeInfoCollectionWrapper) {
            info = ((TypeInfoCollectionWrapper)collection).getFeatureTypeInfo();
        }
        if (info == null && collection.getSchema() != null) {
            info = this.geoServer.getCatalog().getFeatureTypeByName(collection.getSchema().getName());
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeInternal(FeaturesResponse value, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        FeatureCollectionResponse response = value.getResponse();
        GetFeatureRequest request = GetFeatureRequest.adapt((Object)value.getRequest());
        FeatureTypeInfo referenceFeatureType = null;
        List collections = response.getFeature();
        if (collections.size() == 1) {
            referenceFeatureType = this.getResource((FeatureCollection)collections.get(0));
        }
        Template header = this.getHeaderTemplate(referenceFeatureType);
        Template footer = this.getFooterTemplate(referenceFeatureType);
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("baseURL", request.getBaseURL());
        model.put("request", (String)request);
        model.put("response", (String)response);
        this.addLinkFunctions(APIRequestInfo.get().getBaseURL(), model);
        try (OutputStreamWriter osw = new OutputStreamWriter(outputMessage.getBody());){
            try {
                header.process(model, (Writer)osw);
            }
            catch (TemplateException e) {
                String msg = "Error occurred processing header template.";
                throw new IOException(msg, e);
            }
            for (FeatureCollection fc : collections) {
                if (fc == null) continue;
                FeatureTypeInfo typeInfo = this.getResource(fc);
                if (!fc.isEmpty()) {
                    FeatureTypeInfo info;
                    Template content = null;
                    if (!(fc.getSchema() instanceof SimpleFeatureType)) {
                        content = this.getComplexContentTemplate(typeInfo);
                    }
                    if (content == null) {
                        content = this.getContentTemplate(typeInfo);
                    }
                    model.put("featureInfo", (String)typeInfo);
                    model.put("data", (String)fc);
                    if (fc instanceof TypeInfoCollectionWrapper && this.includeCollectionLink() && (info = ((TypeInfoCollectionWrapper)fc).getFeatureTypeInfo()) != null) {
                        model.put("collection", info.prefixedName());
                    }
                    try {
                        content.process(model, (Writer)osw);
                        continue;
                    }
                    catch (TemplateException e) {
                        String msg = "Error occurred processing content template " + content.getName() + " for " + typeInfo.prefixedName();
                        throw new IOException(msg, e);
                    }
                    finally {
                        model.remove("data");
                        continue;
                    }
                }
                Template template = this.getEmptyTemplate(typeInfo);
                model.put("collection", typeInfo.prefixedName());
                try {
                    template.process(model, (Writer)osw);
                }
                catch (TemplateException e) {
                    String msg = "Error occurred processing empty template " + template.getName() + " for " + typeInfo.prefixedName();
                    throw new IOException(msg, e);
                }
            }
            if (footer != null) {
                try {
                    footer.process(model, (Writer)osw);
                }
                catch (TemplateException e) {
                    String msg = "Error occured processing footer template.";
                    throw new IOException(msg, e);
                }
            }
            osw.flush();
        }
        finally {
            this.purgeIterators();
        }
    }

    protected boolean includeCollectionLink() {
        return APIRequestInfo.get() != null;
    }

    protected Template getContentTemplate(FeatureTypeInfo typeInfo) throws IOException {
        return this.templateSupport.getTemplate((ResourceInfo)typeInfo, "getfeature-content.ftl", ((Object)((Object)this)).getClass());
    }

    protected Template getEmptyTemplate(FeatureTypeInfo typeInfo) throws IOException {
        return this.templateSupport.getTemplate((ResourceInfo)typeInfo, "getfeature-empty.ftl", ((Object)((Object)this)).getClass());
    }

    protected Template getComplexContentTemplate(FeatureTypeInfo typeInfo) throws IOException {
        return this.templateSupport.getTemplate((ResourceInfo)typeInfo, "getfeature-complex-content.ftl", ((Object)((Object)this)).getClass());
    }

    protected Template getFooterTemplate(FeatureTypeInfo referenceFeatureType) throws IOException {
        return this.templateSupport.getTemplate((ResourceInfo)referenceFeatureType, "getfeature-footer.ftl", ((Object)((Object)this)).getClass());
    }

    protected Template getHeaderTemplate(FeatureTypeInfo referenceFeatureType) throws IOException {
        return this.templateSupport.getTemplate((ResourceInfo)referenceFeatureType, "getfeature-header.ftl", ((Object)((Object)this)).getClass());
    }
}

