/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.features;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.config.GeoServer;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.AbstractAPIExceptionHandler;
import org.springframework.stereotype.Component;

@Component
public class FeaturesExceptionHandler
extends AbstractAPIExceptionHandler {
    public FeaturesExceptionHandler(GeoServer geoServer) {
        super(geoServer);
    }

    public boolean canHandle(Throwable t, APIRequestInfo request) {
        return request.getService().getId().equals("Features");
    }

    protected void writeResponse(HttpServletResponse response, Throwable t, String type, String title) {
        LinkedHashMap<String, String> error = new LinkedHashMap<String, String>();
        error.put("code", type);
        error.put("description", title);
        try (ServletOutputStream os = response.getOutputStream();){
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue((OutputStream)os, error);
            os.flush();
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "Problem writing exception information back to calling client:", ex);
        }
    }
}

