/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.features;

import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.geoserver.catalog.Catalog;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ogcapi.APIFilterParser;
import org.geoserver.ogcapi.ConformanceDocument;
import org.geoserver.ogcapi.OpenAPIBuilder;
import org.geoserver.ogcapi.features.CollectionsDocument;
import org.geoserver.ogcapi.features.FeaturesResponse;
import org.geoserver.wfs.WFSInfo;

public class FeaturesAPIBuilder
extends OpenAPIBuilder<WFSInfo> {
    public FeaturesAPIBuilder() {
        super(FeaturesAPIBuilder.class, "openapi.yaml", "Features 1.0 server", "ogc/features");
    }

    public OpenAPI build(WFSInfo wfs) throws IOException {
        OpenAPI api = super.build((ServiceInfo)wfs);
        api.externalDocs(new ExternalDocumentation().description("WFS specification").url("https://github.com/opengeospatial/WFS_FES"));
        this.declareGetResponseFormats(api, "/", OpenAPI.class);
        this.declareGetResponseFormats(api, "/conformance", ConformanceDocument.class);
        this.declareGetResponseFormats(api, "/collections", CollectionsDocument.class);
        this.declareGetResponseFormats(api, "/collections/{collectionId}", CollectionsDocument.class);
        this.declareGetResponseFormats(api, "/collections/{collectionId}/items", FeaturesResponse.class);
        this.declareGetResponseFormats(api, "/collections/{collectionId}/items/{featureId}", FeaturesResponse.class);
        Map parameters = api.getComponents().getParameters();
        Parameter collectionId = (Parameter)parameters.get("collectionId");
        Catalog catalog = wfs.getGeoServer().getCatalog();
        List validCollectionIds = catalog.getFeatureTypes().stream().map(ft -> ft.prefixedName()).collect(Collectors.toList());
        collectionId.getSchema().setEnum(validCollectionIds);
        Parameter filterLang = (Parameter)parameters.get("filter-lang");
        filterLang.getSchema().setEnum(new ArrayList(APIFilterParser.SUPPORTED_ENCODINGS));
        Parameter limit = (Parameter)parameters.get("limit");
        BigDecimal limitMax = wfs.getMaxFeatures() > 0 ? BigDecimal.valueOf(wfs.getMaxFeatures()) : BigDecimal.valueOf(Integer.MAX_VALUE);
        limit.getSchema().setMaximum(limitMax);
        limit.getSchema().setDefault((Object)limitMax);
        return api;
    }
}

