/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.features;

import com.google.common.collect.ImmutableList;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import net.opengis.wfs20.Wfs20Factory;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ogcapi.APIBBoxParser;
import org.geoserver.ogcapi.APIFilterParser;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.APIService;
import org.geoserver.ogcapi.ConformanceDocument;
import org.geoserver.ogcapi.DefaultContentType;
import org.geoserver.ogcapi.FunctionsDocument;
import org.geoserver.ogcapi.HTMLResponseBody;
import org.geoserver.ogcapi.Queryables;
import org.geoserver.ogcapi.QueryablesBuilder;
import org.geoserver.ogcapi.features.CollectionDocument;
import org.geoserver.ogcapi.features.CollectionsDocument;
import org.geoserver.ogcapi.features.FeaturesAPIBuilder;
import org.geoserver.ogcapi.features.FeaturesGetFeature;
import org.geoserver.ogcapi.features.FeaturesLandingPage;
import org.geoserver.ogcapi.features.FeaturesResponse;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.kvp.TimeParser;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.StoredQueryProvider;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geoserver.wfs.request.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.DateRange;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.sort.SortBy;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@APIService(service="Features", version="1.0", landingPage="ogc/features", serviceClass=WFSInfo.class)
@RequestMapping(path={"ogc/features"})
public class FeatureService {
    static final Pattern INTEGER = Pattern.compile("\\d+");
    public static final String CORE = "http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/core";
    public static final String HTML = "http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/html";
    public static final String GEOJSON = "http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/geojson";
    public static final String GMLSF0 = "http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/gmlsf0";
    public static final String GMLSF2 = "http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/gmlsf2";
    public static final String OAS30 = "http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/oas30";
    public static final String CRS_PREFIX = "http://www.opengis.net/def/crs/EPSG/0/";
    public static final String DEFAULT_CRS = "http://www.opengis.net/def/crs/OGC/1.3/CRS84";
    public static String ITEM_ID = "OGCFeatures:ItemId";
    private static final String DISPLAY_NAME = "OGC API Features";
    private static final FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2();
    private final GeoServer geoServer;
    private final APIFilterParser filterParser;
    private TimeParser timeParser = new TimeParser();

    public FeatureService(GeoServer geoServer, APIFilterParser filterParser) {
        this.geoServer = geoServer;
        this.filterParser = filterParser;
    }

    public static List<String> getFeatureTypeCRS(FeatureTypeInfo featureType, List<String> defaultCRS) {
        if (featureType.isOverridingServiceSRS()) {
            List<String> result = featureType.getResponseSRS().stream().map(c -> CRS_PREFIX + c).collect(Collectors.toList());
            result.remove(DEFAULT_CRS);
            result.add(0, DEFAULT_CRS);
            return result;
        }
        return defaultCRS;
    }

    public static String getCRSURI(CoordinateReferenceSystem crs) throws FactoryException {
        if (CRS.equalsIgnoreMetadata((Object)crs, (Object)DefaultGeographicCRS.WGS84)) {
            return DEFAULT_CRS;
        }
        Integer code = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false);
        return CRS_PREFIX + code;
    }

    protected List<String> getServiceCRSList() {
        List<String> result = this.getService().getSRS();
        result = result == null || result.isEmpty() ? CRS.getSupportedCodes((String)"EPSG").stream().filter(c -> INTEGER.matcher((CharSequence)c).matches()).map(c -> CRS_PREFIX + c).collect(Collectors.toList()) : result.stream().map(c -> CRS_PREFIX + c).collect(Collectors.toList());
        result.add(0, DEFAULT_CRS);
        return result;
    }

    public WFSInfo getService() {
        return (WFSInfo)this.geoServer.getService(WFSInfo.class);
    }

    private Catalog getCatalog() {
        return this.geoServer.getCatalog();
    }

    @GetMapping(name="getLandingPage")
    @ResponseBody
    @HTMLResponseBody(templateName="landingPage.ftl", fileName="landingPage.html")
    public FeaturesLandingPage getLandingPage() {
        return new FeaturesLandingPage(this.getService(), this.getCatalog(), "ogc/features");
    }

    @GetMapping(path={"api"}, name="getApi", produces={"application/vnd.oai.openapi+json;version=3.0", "application/x-yaml", "text/xml"})
    @ResponseBody
    @HTMLResponseBody(templateName="api.ftl", fileName="api.html")
    public OpenAPI api() throws IOException {
        return new FeaturesAPIBuilder().build(this.getService());
    }

    @GetMapping(path={"collections"}, name="getCollections")
    @ResponseBody
    @HTMLResponseBody(templateName="collections.ftl", fileName="collections.html")
    public CollectionsDocument getCollections() {
        return new CollectionsDocument(this.geoServer, this.getServiceCRSList());
    }

    @GetMapping(path={"functions"}, name="getFunctions")
    @ResponseBody
    @HTMLResponseBody(templateName="functions.ftl", fileName="functions.html")
    public FunctionsDocument getFunctions() {
        return new FunctionsDocument();
    }

    @GetMapping(path={"collections/{collectionId}"}, name="describeCollection")
    @ResponseBody
    @HTMLResponseBody(templateName="collection.ftl", fileName="collection.html")
    public CollectionDocument collection(@PathVariable(name="collectionId") String collectionId) throws IOException {
        FeatureTypeInfo ft = this.getFeatureType(collectionId);
        CollectionDocument collection = new CollectionDocument(this.geoServer, ft, FeatureService.getFeatureTypeCRS(ft, this.getServiceCRSList()));
        return collection;
    }

    @GetMapping(path={"collections/{collectionId}/queryables"}, name="getQueryables", produces={"application/schema+json"})
    @ResponseBody
    @HTMLResponseBody(templateName="queryables.ftl", fileName="queryables.html")
    public Queryables queryables(@PathVariable(name="collectionId") String collectionId) throws IOException {
        FeatureTypeInfo ft = this.getFeatureType(collectionId);
        String id = ResponseUtils.buildURL((String)APIRequestInfo.get().getBaseURL(), (String)("ogc/features/collections/" + ResponseUtils.urlEncode((String)collectionId, (char[])new char[0]) + "/queryables"), null, (URLMangler.URLType)URLMangler.URLType.RESOURCE);
        Queryables queryables = new QueryablesBuilder(id).forType(ft).build();
        queryables.addSelfLinks("collections/" + collectionId + "/queryables");
        return queryables;
    }

    private FeatureTypeInfo getFeatureType(String collectionId) {
        FeatureTypeInfo featureType = this.getCatalog().getFeatureTypeByName(collectionId);
        if (featureType == null) {
            throw new ServiceException("Unknown collection " + collectionId, "InvalidParameterValue", "collectionId");
        }
        return featureType;
    }

    @GetMapping(path={"conformance"}, name="getConformanceDeclaration")
    @ResponseBody
    @HTMLResponseBody(templateName="conformance.ftl", fileName="conformance.html")
    public ConformanceDocument conformance() {
        List<String> classes = Arrays.asList(CORE, OAS30, HTML, GEOJSON, GMLSF0, "http://www.opengis.net/spec/ogcapi-features-3/1.0/req/features-filter", "http://www.opengis.net/spec/ogcapi-features-3/1.0/req/filter", "http://geoserver.org/spec/ecql/1.0/req/gs-ecql", "http://geoserver.org/spec/ecql/1.0/req/ecql-text", "http://www.opengis.net/spec/cql2/1.0/req/basic-cql2", "http://www.opengis.net/spec/cql2/1.0/req/advanced-comparison-operators", "http://www.opengis.net/spec/cql2/1.0/req/arithmetic", "http://www.opengis.net/spec/cql2/1.0/req/property-property", "http://www.opengis.net/spec/cql2/1.0/req/basic-spatial-operators", "http://www.opengis.net/spec/cql2/1.0/req/spatial-operators", "http://www.opengis.net/spec/cql2/1.0/req/functions", "http://www.opengis.net/spec/cql2/1.0/req/cql2-text", "http://www.opengis.net/spec/ogcapi-records-1/1.0/req/sorting");
        return new ConformanceDocument(DISPLAY_NAME, classes);
    }

    @GetMapping(path={"collections/{collectionId}/items/{itemId:.+}"}, name="getFeature")
    @ResponseBody
    @DefaultContentType(value="application/geo+json")
    public FeaturesResponse item(@PathVariable(name="collectionId") String collectionId, @RequestParam(name="startIndex", required=false, defaultValue="0") BigInteger startIndex, @RequestParam(name="limit", required=false) BigInteger limit, @RequestParam(name="bbox", required=false) String bbox, @RequestParam(name="bbox-crs", required=false) String bboxCRS, @RequestParam(name="time", required=false) String time, @PathVariable(name="itemId") String itemId, @RequestParam(name="crs", required=false) String crs) throws Exception {
        return this.items(collectionId, startIndex, limit, bbox, bboxCRS, crs, time, null, null, null, null, itemId);
    }

    @GetMapping(path={"collections/{collectionId}/items"}, name="getFeatures")
    @ResponseBody
    @DefaultContentType(value="application/geo+json")
    public FeaturesResponse items(@PathVariable(name="collectionId") String collectionId, @RequestParam(name="startIndex", required=false, defaultValue="0") BigInteger startIndex, @RequestParam(name="limit", required=false) BigInteger limit, @RequestParam(name="bbox", required=false) String bbox, @RequestParam(name="bbox-crs", required=false) String bboxCRS, @RequestParam(name="datetime", required=false) String datetime, @RequestParam(name="filter", required=false) String filter, @RequestParam(name="filter-lang", required=false) String filterLanguage, @RequestParam(name="filter-crs", required=false) String filterCRS, @RequestParam(name="sortby", required=false) SortBy[] sortBy, @RequestParam(name="crs", required=false) String crs, String itemId) throws Exception {
        FeatureTypeInfo ft = this.getFeatureType(collectionId);
        GetFeatureRequest request = GetFeatureRequest.adapt((Object)Wfs20Factory.eINSTANCE.createGetFeatureType());
        Query query = request.createQuery();
        query.setTypeNames(Arrays.asList(new QName(ft.getNamespace().getURI(), ft.getName())));
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (bbox != null) {
            DefaultGeographicCRS queryCRS = DefaultGeographicCRS.WGS84;
            if (bboxCRS != null) {
                queryCRS = CRS.decode((String)bboxCRS);
            }
            filters.add(APIBBoxParser.toFilter((String)bbox, (CoordinateReferenceSystem)queryCRS));
        }
        if (datetime != null) {
            filters.add(this.buildTimeFilter(ft, datetime));
        }
        if (itemId != null) {
            filters.add((Filter)FF.id(new FeatureId[]{FF.featureId(itemId)}));
        }
        if (filter != null) {
            Filter parsedFilter = this.filterParser.parse(filter, filterLanguage, filterCRS);
            filters.add(parsedFilter);
        }
        query.setFilter(this.mergeFiltersAnd(filters));
        if (sortBy != null) {
            query.setSortBy((List)ImmutableList.copyOf((Object[])sortBy));
        }
        if (crs != null) {
            query.setSrsName(new URI(crs));
        } else {
            query.setSrsName(new URI("EPSG:4326"));
        }
        request.setStartIndex(startIndex);
        request.setMaxFeatures(limit);
        request.setBaseUrl(APIRequestInfo.get().getBaseURL());
        request.getAdaptedQueries().add(query.getAdaptee());
        FeaturesGetFeature gf = new FeaturesGetFeature(this.getService(), this.getCatalog());
        gf.setFilterFactory(FF);
        gf.setStoredQueryProvider(this.getStoredQueryProvider());
        FeatureCollectionResponse response = gf.run(request);
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            requestAttributes.setAttribute(ITEM_ID, (Object)itemId, 0);
        }
        return new FeaturesResponse(request.getAdaptee(), response);
    }

    private Filter buildTimeFilter(FeatureTypeInfo ft, String time) throws ParseException, IOException {
        Collection times = this.timeParser.parse(time);
        if (times.isEmpty() || times.size() > 1) {
            throw new ServiceException("Invalid time specification, must be a single time, or a time range", "InvalidParameterValue", "time");
        }
        ArrayList<Filter> filters = new ArrayList<Filter>();
        Object timeSpec = times.iterator().next();
        for (String timeProperty : this.getTimeProperties(ft)) {
            PropertyIsEqualTo filter;
            PropertyName property = FF.property(timeProperty);
            if (timeSpec instanceof Date) {
                filter = FF.equals((Expression)property, (Expression)FF.literal(timeSpec));
            } else if (timeSpec instanceof DateRange) {
                DateRange dateRange = (DateRange)timeSpec;
                Literal before = FF.literal((Object)dateRange.getMinValue());
                Literal after = FF.literal((Object)dateRange.getMaxValue());
                filter = FF.between((Expression)property, (Expression)before, (Expression)after);
            } else {
                throw new IllegalArgumentException("Cannot build time filter out of " + timeSpec);
            }
            filters.add((Filter)filter);
        }
        return this.mergeFiltersOr(filters);
    }

    private List<String> getTimeProperties(FeatureTypeInfo ft) throws IOException {
        FeatureType schema = ft.getFeatureType();
        return schema.getDescriptors().stream().filter(pd -> Date.class.isAssignableFrom(pd.getType().getBinding())).map(pd -> pd.getName().getLocalPart()).collect(Collectors.toList());
    }

    private Filter mergeFiltersAnd(List<Filter> filters) {
        if (filters.isEmpty()) {
            return Filter.INCLUDE;
        }
        if (filters.size() == 1) {
            return filters.get(0);
        }
        return FF.and(filters);
    }

    private Filter mergeFiltersOr(List<Filter> filters) {
        if (filters.isEmpty()) {
            return Filter.EXCLUDE;
        }
        if (filters.size() == 1) {
            return filters.get(0);
        }
        return FF.or(filters);
    }

    private StoredQueryProvider getStoredQueryProvider() {
        return new StoredQueryProvider(this.getCatalog());
    }
}

