/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.features;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.ogcapi.MessageConverterResponseAdapter;
import org.geoserver.ogcapi.features.FeatureService;
import org.geoserver.ogcapi.features.FeaturesResponse;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.platform.Operation;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geotools.feature.FeatureCollection;
import org.geotools.referencing.CRS;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;

@Component
public class FeatureResponseMessageConverter
extends MessageConverterResponseAdapter<FeaturesResponse> {
    static final Logger LOGGER = Logging.getLogger(FeatureResponseMessageConverter.class);
    private static final Version V2 = new Version("2.0");
    public static final String CRS_RESPONSE_HEADER = "OGC-CRS";
    List<Response> responses;

    public FeatureResponseMessageConverter() {
        super(FeaturesResponse.class, FeatureCollectionResponse.class);
    }

    protected void writeResponse(FeaturesResponse value, HttpOutputMessage httpOutputMessage, Operation operation, Response response) throws IOException {
        this.setHeaders(value.getResponse(), operation, response, httpOutputMessage);
        response.write((Object)value.getResponse(), httpOutputMessage.getBody(), operation);
    }

    protected void setHeaders(Object result, Operation operation, Response response, HttpOutputMessage message) {
        super.setHeaders(result, operation, response, message);
        CoordinateReferenceSystem crs = Optional.ofNullable((FeatureCollectionResponse)result).map(fct -> (FeatureCollection)fct.getFeatures().get(0)).map(fc -> fc.getSchema()).map(ft -> ft.getCoordinateReferenceSystem()).orElse(null);
        if (crs != null) {
            try {
                String crsURI = FeatureService.getCRSURI(crs);
                String orderSpec = this.getOrderSpecification(crs);
                if (crsURI != null && orderSpec != null) {
                    message.getHeaders().set(CRS_RESPONSE_HEADER, crsURI + "; axisOrder=" + orderSpec);
                }
            }
            catch (FactoryException e) {
                LOGGER.log(Level.INFO, "Failed to lookup EPSG code of CRS, won't set the OGC-CRS header." + crs, e);
            }
        }
    }

    private String getOrderSpecification(CoordinateReferenceSystem crs) {
        CRS.AxisOrder order = CRS.getAxisOrder((CoordinateReferenceSystem)crs);
        CoordinateSystemAxis a0 = crs.getCoordinateSystem().getAxis(0);
        CoordinateSystemAxis a1 = crs.getCoordinateSystem().getAxis(1);
        String orderSpec = order == CRS.AxisOrder.EAST_NORTH ? a0.getAbbreviation() + "," + a1.getAbbreviation() : (order == CRS.AxisOrder.NORTH_EAST ? a1.getAbbreviation() + "," + a0.getAbbreviation() : null);
        return orderSpec;
    }

    protected Operation getOperation(FeaturesResponse result, Request dr, MediaType mediaType) {
        Operation op = dr.getOperation();
        return new Operation("GetFeature", op.getService(), op.getMethod(), new Object[]{result.getRequest()});
    }

    protected Predicate<Response> getResponseFilterPredicate() {
        return r -> r instanceof WFSGetFeatureOutputFormat && ((WFSGetFeatureOutputFormat)r).canHandle(V2);
    }
}

