/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.features;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.config.GeoServer;
import org.geoserver.ogcapi.AbstractDocument;
import org.geoserver.ogcapi.Link;
import org.geoserver.ogcapi.features.CollectionDocument;
import org.geoserver.ogcapi.features.FeatureService;
import org.geoserver.platform.ServiceException;
import org.opengis.filter.Filter;

@JacksonXmlRootElement(localName="Collections", namespace="http://www.opengis.net/wfs/3.0")
@JsonPropertyOrder(value={"links", "collections"})
public class CollectionsDocument
extends AbstractDocument {
    private final GeoServer geoServer;
    private final List<String> crs;
    private final List<Consumer<CollectionDocument>> collectionDecorators = new ArrayList<Consumer<CollectionDocument>>();

    public CollectionsDocument(GeoServer geoServer, List<String> crsList) {
        this.geoServer = geoServer;
        this.crs = crsList;
        String path = "ogc/features/collections/";
        this.addSelfLinks(path);
    }

    @JacksonXmlProperty(localName="Links")
    public List<Link> getLinks() {
        return this.links;
    }

    @JacksonXmlProperty(localName="Collection")
    public Iterator<CollectionDocument> getCollections() {
        final CloseableIterator featureTypes = this.geoServer.getCatalog().list(FeatureTypeInfo.class, (Filter)Filter.INCLUDE);
        return new Iterator<CollectionDocument>(){
            CollectionDocument next;

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                boolean hasNext = featureTypes.hasNext();
                if (!hasNext) {
                    featureTypes.close();
                    return false;
                }
                try {
                    FeatureTypeInfo featureType = (FeatureTypeInfo)featureTypes.next();
                    List<String> crs = FeatureService.getFeatureTypeCRS(featureType, Collections.singletonList("#/crs"));
                    CollectionDocument collection = new CollectionDocument(CollectionsDocument.this.geoServer, featureType, crs);
                    for (Consumer collectionDecorator : CollectionsDocument.this.collectionDecorators) {
                        collectionDecorator.accept(collection);
                    }
                    this.next = collection;
                    return true;
                }
                catch (Exception e) {
                    featureTypes.close();
                    throw new ServiceException("Failed to iterate over the feature types in the catalog", (Throwable)e);
                }
            }

            @Override
            public CollectionDocument next() {
                CollectionDocument result = this.next;
                this.next = null;
                return result;
            }
        };
    }

    public List<String> getCrs() {
        return this.crs;
    }

    public void addCollectionDecorator(Consumer<CollectionDocument> decorator) {
        this.collectionDecorators.add(decorator);
    }
}

