/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.features;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.AbstractCollectionDocument;
import org.geoserver.ogcapi.AbstractDocument;
import org.geoserver.ogcapi.CollectionExtents;
import org.geoserver.ogcapi.Link;
import org.geoserver.ogcapi.LinksBuilder;
import org.geoserver.ogcapi.Queryables;
import org.geoserver.ogcapi.TimeExtentCalculator;
import org.geoserver.ogcapi.features.FeatureService;
import org.geoserver.ogcapi.features.FeaturesResponse;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.DateRange;
import org.geotools.util.logging.Logging;
import org.opengis.feature.type.FeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.http.MediaType;

@JsonPropertyOrder(value={"id", "title", "description", "extent", "links"})
@JacksonXmlRootElement(localName="Collection", namespace="http://www.opengis.net/wfs/3.0")
public class CollectionDocument
extends AbstractCollectionDocument<FeatureTypeInfo> {
    static final Logger LOGGER = Logging.getLogger(CollectionDocument.class);
    FeatureTypeInfo featureType;
    String mapPreviewURL;
    List<String> crs;
    String storageCrs;

    public CollectionDocument(GeoServer geoServer, final FeatureTypeInfo featureType, List<String> crs) throws IOException {
        super((Object)featureType);
        String collectionId;
        this.id = collectionId = featureType.prefixedName();
        this.title = featureType.getTitle();
        this.description = featureType.getAbstract();
        ReferencedEnvelope bbox = featureType.getLatLonBoundingBox();
        DateRange timeExtent = TimeExtentCalculator.getTimeExtent((ResourceInfo)featureType);
        this.setExtent(new CollectionExtents(bbox, timeExtent));
        this.featureType = featureType;
        this.crs = crs;
        this.storageCrs = this.lookupStorageCrs();
        Collection formats = APIRequestInfo.get().getProducibleMediaTypes(FeaturesResponse.class, true);
        String baseUrl = APIRequestInfo.get().getBaseURL();
        for (MediaType format : formats) {
            String apiUrl = ResponseUtils.buildURL((String)baseUrl, (String)("ogc/features/collections/" + collectionId + "/items"), Collections.singletonMap("f", format.toString()), (URLMangler.URLType)URLMangler.URLType.SERVICE);
            this.addLink(new Link(apiUrl, "items", format.toString(), collectionId + " items as " + format.toString(), "items"));
        }
        this.addSelfLinks("ogc/features/collections/" + this.id);
        String describedByHref = ResponseUtils.buildURL((String)baseUrl, (String)"wfs", (Map)new HashMap<String, String>(){
            {
                this.put("service", "WFS");
                this.put("version", "2.0");
                this.put("request", "DescribeFeatureType");
                this.put("typenames", featureType.prefixedName());
            }
        }, (URLMangler.URLType)URLMangler.URLType.SERVICE);
        Link describedBy = new Link(describedByHref, "describedBy", "application/xml", "Schema for " + this.id);
        this.addLink(describedBy);
        new LinksBuilder(Queryables.class, "ogc/features/collections").segment(featureType.prefixedName(), true).segment("queryables").title("Queryable attributes as ").rel("http://www.opengis.net/def/rel/ogc/1.0/queryables").add((AbstractDocument)this);
        if (this.isWMSAvailable(geoServer)) {
            HashMap<String, String> kvp = new HashMap<String, String>();
            kvp.put("LAYERS", featureType.prefixedName());
            kvp.put("FORMAT", "application/openlayers");
            this.mapPreviewURL = ResponseUtils.buildURL((String)baseUrl, (String)"wms/reflect", kvp, (URLMangler.URLType)URLMangler.URLType.SERVICE);
        }
    }

    private boolean isWMSAvailable(GeoServer geoServer) {
        ServiceInfo si = geoServer.getServices().stream().filter(s -> "WMS".equals(s.getId())).findFirst().orElse(null);
        return si != null;
    }

    private String lookupStorageCrs() {
        CoordinateReferenceSystem crs = this.getSchemaCRS();
        if (crs != null) {
            try {
                return FeatureService.getCRSURI(crs);
            }
            catch (FactoryException e) {
                LOGGER.log(Level.FINER, "Error looking up epsg code", e);
            }
        }
        return null;
    }

    private CoordinateReferenceSystem getSchemaCRS() {
        FeatureType schema = this.getSchema();
        if (schema != null) {
            return schema.getCoordinateReferenceSystem();
        }
        return null;
    }

    @JsonIgnore
    public FeatureType getSchema() {
        try {
            return this.featureType.getFeatureType();
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Failed to compute feature type", e);
            return null;
        }
    }

    @JsonIgnore
    public String getMapPreviewURL() {
        return this.mapPreviewURL;
    }

    public List<String> getCrs() {
        return this.crs;
    }

    public String getStorageCrs() {
        return this.storageCrs;
    }
}

